/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.lootevents.command;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.MutableComponent;
import uk.co.dotcode.lootevents.LootEventSystem;
import uk.co.dotcode.lootevents.command.CommandUtil;
import uk.co.dotcode.lootevents.config.ConfigManager;

public class SettingsCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> build() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"settings").requires(source -> source.hasPermission(ConfigManager.CONFIG.adminPermissionLevel.intValue()))).executes(SettingsCommand::execute);
    }

    public static int execute(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtil.styledText("=== Current CLE Settings ===", -22016), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> SettingsCommand.checkValid("Announcer Name", ConfigManager.CONFIG.announcerName), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> SettingsCommand.checkValid("Admin Permission Level", Integer.toString(ConfigManager.CONFIG.adminPermissionLevel)), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> SettingsCommand.checkValid("Blacklisted Items", ConfigManager.CONFIG.blacklistedItems.size() + " (/cle blacklistedItems)"), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> SettingsCommand.checkValid("Event Countdown (seconds)", Integer.toString(ConfigManager.CONFIG.eventCountdownSeconds)), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> SettingsCommand.checkValid("Event Duration (seconds)", Integer.toString(ConfigManager.CONFIG.eventDurationSeconds)), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> SettingsCommand.checkValid("Event Type", ConfigManager.CONFIG.eventType), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> SettingsCommand.checkValid("Radius", ConfigManager.CONFIG.radius), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> SettingsCommand.checkValid("Event Center Dimension", ConfigManager.CONFIG.eventDimension), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> SettingsCommand.checkValid("Event Center Position", ConfigManager.CONFIG.eventCenterPosition), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> SettingsCommand.checkValid("Player Teleport Dimension", ConfigManager.CONFIG.playerTeleportDimension), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> SettingsCommand.checkValid("Player Teleport Position", ConfigManager.CONFIG.playerTeleportPosition), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> SettingsCommand.checkValid("Loot Frequency", ConfigManager.CONFIG.lootFrequency), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> SettingsCommand.checkValid("Loot Stack Limit", Integer.toString(ConfigManager.CONFIG.lootStackLimit)), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> SettingsCommand.checkValid("Maximum Stack Size", Integer.toString(ConfigManager.CONFIG.maximumStackSize)), false);
        if (LootEventSystem.isEventPrepared() && !LootEventSystem.isEventStarted()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtil.formatRow("Event Status", "Event is currently being prepared", -256), false);
        } else if (LootEventSystem.isEventStarted()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtil.formatRow("Event Status", "Event is underway!", -16711936), false);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtil.formatRow("Remaining Event Time", LootEventSystem.getRemainingTime() + " seconds", -16711936), false);
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtil.formatRow("Event Status", "No events underway", -2142128), false);
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtil.styledText("=========================", -22016), false);
        return 1;
    }

    private static MutableComponent checkValid(String key, Object value) {
        if (value != null) {
            return CommandUtil.formatRow(key, value.toString(), -16711936);
        }
        return CommandUtil.formatRow(key, "NOT SET", -2142128);
    }
}

