/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.lootevents.command;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import uk.co.dotcode.lootevents.LootEventSystem;
import uk.co.dotcode.lootevents.command.CommandUtil;
import uk.co.dotcode.lootevents.config.ConfigManager;

public class StartCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> build() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"start").requires(source -> source.hasPermission(ConfigManager.CONFIG.adminPermissionLevel.intValue()))).executes(StartCommand::execute);
    }

    public static int execute(CommandContext<CommandSourceStack> context) {
        ArrayList<String> eventReadyStatus = LootEventSystem.isEventReady();
        if (eventReadyStatus.isEmpty()) {
            LootEventSystem.startEvent(((CommandSourceStack)context.getSource()).getServer());
            CommandUtil.broadcastMessage(((CommandSourceStack)context.getSource()).getServer(), CommandUtil.getPrefix().append((Component)CommandUtil.styledText("An event has started! You can now no longer sign up.", -11141121)));
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)CommandUtil.failText("Event failed to start! Reason(s):"));
        for (String validation : eventReadyStatus) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)CommandUtil.warningText(validation));
        }
        return 0;
    }
}

