/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.lootevents.mixin;

import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import uk.co.dotcode.lootevents.LootEventSystem;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin {
    @Shadow
    public abstract ItemStack getItem();

    @Shadow
    public abstract void setItem(ItemStack var1);

    @Inject(method={"playerTouch(Lnet/minecraft/world/entity/player/Player;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onPickup(Player player, CallbackInfo ci) {
        if (!player.level().isClientSide() && LootEventSystem.isEventStarted() && LootEventSystem.pickupsBlocked()) {
            if (LootEventSystem.getPlayers().containsKey(player.getStringUUID())) {
                if (LootEventSystem.addLoot(player, this.getItem())) {
                    this.setItem(ItemStack.EMPTY);
                } else {
                    ci.cancel();
                }
            } else if (LootEventSystem.isItemEntityTracked((ItemEntity)this)) {
                ci.cancel();
            }
        }
    }
}

