/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.lootevents.mixin;

import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import uk.co.dotcode.lootevents.LootEventSystem;
import uk.co.dotcode.lootevents.command.CommandUtil;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin {
    @Inject(method={"drop(Lnet/minecraft/world/item/ItemStack;ZZ)Lnet/minecraft/world/entity/item/ItemEntity;"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventItemDrop(ItemStack stack, boolean throwRandomly, boolean retainOwnership, CallbackInfoReturnable<ItemEntity> cir) {
        Player player = (Player)this;
        if (!player.level().isClientSide() && (LootEventSystem.isEventPrepared() || LootEventSystem.isEventStarted()) && LootEventSystem.getPlayers().containsKey(player.getStringUUID())) {
            cir.setReturnValue(null);
            player.getInventory().add(stack);
            player.displayClientMessage((Component)CommandUtil.failText("You cannot drop items when participating in an event!"), false);
            cir.cancel();
        }
    }
}

