/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.lootevents;

import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import uk.co.dotcode.lootevents.LootEvents;
import uk.co.dotcode.lootevents.command.CommandUtil;
import uk.co.dotcode.lootevents.config.ConfigManager;

public class LootEventSystem {
    private static final HashMap<String, ArrayList<class_1799>> players = new HashMap();
    private static final HashMap<String, ArrayList<class_1799>> rewardsToClaim = new HashMap();
    private static final ArrayList<class_1542> eventItemEntities = new ArrayList();
    private static final Random RANDOM = new Random();
    private static int unclaimedRewardsNotificationTimer = 0;
    private static int timer = ConfigManager.CONFIG.eventDurationSeconds * 20;
    private static int eventCountdownTimer = ConfigManager.CONFIG.eventCountdownSeconds * 20;
    private static boolean eventPrepared = false;
    private static boolean eventStarted = false;
    private static boolean blockPickups = false;
    private static boolean eventCountdownComplete = false;
    private static class_1937 targetWorld = null;
    public static final SuggestionProvider<class_2168> BLACKLIST_SUGGESTIONS = (context, builder) -> {
        for (String blacklistedItem : ConfigManager.CONFIG.blacklistedItems) {
            if (!blacklistedItem.toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
            builder.suggest(blacklistedItem);
        }
        return builder.buildFuture();
    };

    public static void tick(MinecraftServer server) {
        if (!LootEventSystem.getRewardsToClaim().isEmpty() && ++unclaimedRewardsNotificationTimer % (20 * ConfigManager.CONFIG.unclaimedRewardsNotificationSeconds) == 0) {
            for (String uuid : LootEventSystem.getRewardsToClaim().keySet()) {
                server.method_3760().method_14602(UUID.fromString(uuid)).method_43502((class_2561)CommandUtil.warningText("You have unclaimed event rewards! /cle claim"), false);
            }
            unclaimedRewardsNotificationTimer = 0;
        }
        if (LootEventSystem.isEventPrepared() && LootEventSystem.isEventStarted()) {
            if (eventCountdownTimer > 0) {
                if (eventCountdownTimer % 20 == 0) {
                    LootEventSystem.announceToPlayers(server, "COUNTDOWN: " + eventCountdownTimer / 20);
                }
                --eventCountdownTimer;
            } else if (!eventCountdownComplete) {
                LootEventSystem.announceToPlayers(server, "!!! GO !!!");
                eventCountdownComplete = true;
                blockPickups = true;
            } else if (timer > 0) {
                --timer;
                switch (ConfigManager.CONFIG.eventType) {
                    case "itemdrop": {
                        LootEventSystem.processItemDropEvent(server, (class_5455)server.method_30611());
                        break;
                    }
                }
                if (timer % 100 == 0) {
                    LootEventSystem.announceToPlayers(server, timer / 20 + " SECONDS REMAIN!");
                }
            } else {
                LootEventSystem.finishEvent(server);
            }
        }
    }

    private static void processItemDropEvent(MinecraftServer server, class_5455 registryAccess) {
        for (int i = 0; i < ConfigManager.CONFIG.lootFrequency; ++i) {
            int spawnX = ConfigManager.CONFIG.eventCenterPosition.method_10263() - ConfigManager.CONFIG.radius + RANDOM.nextInt(ConfigManager.CONFIG.radius * 2) + 1;
            int spawnY = ConfigManager.CONFIG.eventCenterPosition.method_10264();
            int spawnZ = ConfigManager.CONFIG.eventCenterPosition.method_10260() - ConfigManager.CONFIG.radius + RANDOM.nextInt(ConfigManager.CONFIG.radius * 2) + 1;
            class_1542 itemEntity = new class_1542(targetWorld, (double)spawnX, (double)spawnY, (double)spawnZ, LootEventSystem.getRandomItem(registryAccess));
            eventItemEntities.add(itemEntity);
            targetWorld.method_8649((class_1297)itemEntity);
        }
    }

    public static void prepareEvent() {
        if (!eventStarted) {
            players.clear();
            eventPrepared = true;
            blockPickups = false;
        }
    }

    public static void startEvent(MinecraftServer server) {
        if (LootEventSystem.isEventPrepared() && !LootEventSystem.isEventStarted() && LootEventSystem.isEventReady().isEmpty()) {
            targetWorld = server.method_3847(LootEventSystem.getDimensionKey(ConfigManager.CONFIG.eventDimension));
            timer = ConfigManager.CONFIG.eventDurationSeconds * 20;
            eventCountdownTimer = ConfigManager.CONFIG.eventCountdownSeconds * 20;
            eventCountdownComplete = false;
            eventStarted = true;
            class_3218 teleportDim = server.method_3847(LootEventSystem.getDimensionKey(ConfigManager.CONFIG.playerTeleportDimension));
            try {
                players.forEach((id, loot) -> Optional.ofNullable(server.method_3760().method_14602(UUID.fromString(id))).ifPresentOrElse(player -> player.method_48105(teleportDim, (double)ConfigManager.CONFIG.playerTeleportPosition.method_10263(), (double)ConfigManager.CONFIG.playerTeleportPosition.method_10264(), (double)ConfigManager.CONFIG.playerTeleportPosition.method_10260(), Set.of(), 0.0f, 0.0f), () -> LootEvents.LOGGER.warn("Player with UUID {} is offline or does not exist", id)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void resetEvent() {
        players.clear();
        eventStarted = false;
        eventPrepared = false;
        eventCountdownComplete = false;
        blockPickups = false;
        for (class_1542 e : eventItemEntities) {
            if (e == null || !e.method_5805()) continue;
            e.method_5650(class_1297.class_5529.field_26999);
        }
        eventItemEntities.clear();
    }

    public static void finishEvent(MinecraftServer server) {
        LootEventSystem.announceToPlayers(server, "The event is over! Thanks for participating!");
        for (Map.Entry<String, ArrayList<class_1799>> entry : players.entrySet()) {
            ArrayList<class_1799> copiedList = new ArrayList<class_1799>();
            for (class_1799 item : entry.getValue()) {
                copiedList.add(item.method_7972());
            }
            rewardsToClaim.computeIfAbsent(entry.getKey(), k -> new ArrayList()).addAll(copiedList);
        }
        LootEventSystem.resetEvent();
    }

    public static ArrayList<String> isEventReady() {
        ArrayList<String> errors = new ArrayList<String>();
        if (LootEventSystem.isEventStarted()) {
            errors.add("Another Event Is Already Underway");
        }
        if (!LootEventSystem.isEventPrepared()) {
            errors.add("Event Not Prepared (/cle prepare)");
        }
        if (players.isEmpty()) {
            errors.add("No Players (/cle join)");
        }
        errors.addAll(ConfigManager.validate());
        return errors;
    }

    public static void addPlayer(class_1657 player) {
        if (!LootEventSystem.getPlayers().containsKey(player.method_5845())) {
            players.put(player.method_5845(), new ArrayList());
        }
    }

    public static boolean addLoot(class_1657 player, class_1799 loot) {
        if (players.containsKey(player.method_5845())) {
            if (players.get(player.method_5845()).size() < ConfigManager.CONFIG.lootStackLimit) {
                players.get(player.method_5845()).add(loot);
                return true;
            }
            return false;
        }
        return false;
    }

    public static void announceToPlayers(MinecraftServer server, String message) {
        for (String uuidString : players.keySet()) {
            try {
                UUID uuid = UUID.fromString(uuidString);
                class_3222 player = server.method_3760().method_14602(uuid);
                if (player == null) continue;
                player.method_43502((class_2561)CommandUtil.styledText(message, -11141121), false);
            }
            catch (IllegalArgumentException e) {
                System.err.println("Invalid UUID in players map: " + uuidString);
            }
        }
    }

    public static boolean isEventPrepared() {
        return eventPrepared;
    }

    public static boolean isEventStarted() {
        return eventStarted;
    }

    public static boolean isItemEntityTracked(class_1542 entity) {
        return eventItemEntities.contains(entity);
    }

    public static ArrayList<class_2561> getSignedUpPlayerNames(MinecraftServer server) {
        ArrayList<class_2561> names = new ArrayList<class_2561>();
        for (String uuidString : players.keySet()) {
            try {
                UUID uuid = UUID.fromString(uuidString);
                class_3222 player = server.method_3760().method_14602(uuid);
                if (player == null) continue;
                names.add(player.method_5476());
            }
            catch (IllegalArgumentException e) {
                System.err.println("Invalid UUID in players map: " + uuidString);
            }
        }
        return names;
    }

    public static HashMap<String, ArrayList<class_1799>> getPlayers() {
        return players;
    }

    public static float getRemainingTime() {
        return (float)(eventCountdownTimer + timer) / 20.0f;
    }

    public static boolean pickupsBlocked() {
        return blockPickups;
    }

    public static HashMap<String, ArrayList<class_1799>> getRewardsToClaim() {
        return rewardsToClaim;
    }

    private static class_5321<class_1937> getDimensionKey(String dimensionString) {
        return switch (dimensionString.toLowerCase()) {
            case "overworld", "minecraft:overworld" -> {
                class_5321 var3_3;
                yield var3_3 = class_1937.field_25179;
            }
            case "nether", "the_nether", "minecraft:the_nether" -> {
                class_5321 var3_4;
                yield var3_4 = class_1937.field_25180;
            }
            case "end", "the_end", "minecraft:the_end" -> {
                class_5321 var3_5;
                yield var3_5 = class_1937.field_25181;
            }
            default -> {
                try {
                    class_5321 var3_6;
                    class_2960 id = class_2960.method_12829((String)dimensionString);
                    yield var3_6 = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)id);
                }
                catch (Exception e) {
                    Object var3_7 = null;
                    yield var3_7;
                }
            }
        };
    }

    public static class_1799 getRandomItem(class_5455 registryAccess) {
        ArrayList allItems = new ArrayList();
        class_2378 itemRegistry = registryAccess.method_30530(class_7924.field_41197);
        itemRegistry.method_10220().forEach(item -> {
            class_2960 id = itemRegistry.method_10221(item);
            if (id != null && !ConfigManager.CONFIG.blacklistedItems.contains(id.toString())) {
                allItems.add(item);
            }
        });
        if (allItems.isEmpty()) {
            return class_1799.field_8037;
        }
        class_1792 randomItem = (class_1792)allItems.get(RANDOM.nextInt(allItems.size()));
        int quantity = RANDOM.nextInt(ConfigManager.CONFIG.maximumStackSize) + 1;
        return new class_1799((class_1935)randomItem, Math.min(Math.min(quantity, ConfigManager.CONFIG.maximumStackSize), randomItem.method_7882()));
    }
}

