/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.lootevents.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.class_1792;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2287;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_7157;
import net.minecraft.class_7924;
import uk.co.dotcode.lootevents.LootEventSystem;
import uk.co.dotcode.lootevents.command.CommandUtil;
import uk.co.dotcode.lootevents.config.ConfigManager;

public class BlacklistedItemsCommand {
    public static ArgumentBuilder<class_2168, ?> build(class_7157 commandRegistryAccess) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"blacklistedItems").requires(source -> source.method_9259(ConfigManager.CONFIG.adminPermissionLevel.intValue()))).executes(BlacklistedItemsCommand::getBlacklistedItems)).then(class_2170.method_9247((String)"get").executes(BlacklistedItemsCommand::getBlacklistedItems))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"item", (ArgumentType)class_2287.method_9776((class_7157)commandRegistryAccess)).executes(BlacklistedItemsCommand::addBlacklistedItem)))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"item", (ArgumentType)StringArgumentType.greedyString()).suggests(LootEventSystem.BLACKLIST_SUGGESTIONS).executes(BlacklistedItemsCommand::removeBlacklistedItem)));
    }

    public static int getBlacklistedItems(CommandContext<class_2168> context) {
        if (!ConfigManager.CONFIG.blacklistedItems.isEmpty()) {
            ((class_2168)context.getSource()).method_9226(() -> CommandUtil.styledText("=== Blacklisted Items ===", -22016), false);
            for (String s : ConfigManager.CONFIG.blacklistedItems) {
                ((class_2168)context.getSource()).method_9226(() -> CommandUtil.warningText(s), false);
            }
            ((class_2168)context.getSource()).method_9226(() -> CommandUtil.styledText("=========================", -22016), false);
            return 1;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)CommandUtil.failText("There are no blacklisted items"));
        return 0;
    }

    public static int addBlacklistedItem(CommandContext<class_2168> context) {
        class_1792 item = class_2287.method_9777(context, (String)"item").method_9785();
        class_5455.class_6890 registryAccess = ((class_2168)context.getSource()).method_9211().method_30611();
        class_2960 id = registryAccess.method_30530(class_7924.field_41197).method_10221((Object)item);
        String blacklistAdd = id.toString();
        if (ConfigManager.CONFIG.blacklistedItems.contains(blacklistAdd)) {
            ((class_2168)context.getSource()).method_9213((class_2561)CommandUtil.failText("This item is already blacklisted: ").method_10852((class_2561)CommandUtil.warningText(blacklistAdd)));
            return 0;
        }
        ConfigManager.CONFIG.blacklistedItems.add(blacklistAdd);
        ((class_2168)context.getSource()).method_9226(() -> CommandUtil.successText("Added ").method_10852((class_2561)CommandUtil.warningText(blacklistAdd)).method_10852((class_2561)CommandUtil.successText(" to the blacklist")), false);
        ConfigManager.save();
        return 1;
    }

    public static int removeBlacklistedItem(CommandContext<class_2168> context) {
        String blacklistRemove = StringArgumentType.getString(context, (String)"item");
        if (!ConfigManager.CONFIG.blacklistedItems.contains(blacklistRemove)) {
            ((class_2168)context.getSource()).method_9213((class_2561)CommandUtil.failText("This item is not blacklisted: ").method_10852((class_2561)CommandUtil.warningText(blacklistRemove)));
            return 0;
        }
        ConfigManager.CONFIG.blacklistedItems.removeIf(str -> str.equalsIgnoreCase(blacklistRemove));
        ((class_2168)context.getSource()).method_9226(() -> CommandUtil.successText("Removed ").method_10852((class_2561)CommandUtil.warningText(blacklistRemove)).method_10852((class_2561)CommandUtil.successText(" from the blacklist")), false);
        ConfigManager.save();
        return 1;
    }
}

