/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.lootevents.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import uk.co.dotcode.lootevents.LootEventSystem;
import uk.co.dotcode.lootevents.command.CommandUtil;
import uk.co.dotcode.lootevents.config.ConfigManager;

public class SetCommand {
    public static final SuggestionProvider<class_2168> EVENT_TYPE_SUGGESTIONS = (context, builder) -> {
        for (String eventType : ConfigManager.VALID_EVENT_TYPES) {
            if (!eventType.toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
            builder.suggest(eventType);
        }
        return builder.buildFuture();
    };

    public static ArgumentBuilder<class_2168, ?> build() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"set").requires(source -> source.method_9259(ConfigManager.CONFIG.adminPermissionLevel.intValue()))).then(class_2170.method_9247((String)"announcerName").then(class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(SetCommand::setAnnouncerName)))).then(class_2170.method_9247((String)"adminPermissionLevel").then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)4)).executes(SetCommand::setAdminPermissionLevel)))).then(class_2170.method_9247((String)"eventCountdownSeconds").then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)3)).executes(SetCommand::setEventCountdownSeconds)))).then(class_2170.method_9247((String)"eventDurationSeconds").then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)5)).executes(SetCommand::setEventDurationSeconds)))).then(class_2170.method_9247((String)"eventType").then(class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.string()).suggests(EVENT_TYPE_SUGGESTIONS).executes(SetCommand::setEventType)))).then(class_2170.method_9247((String)"radius").then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)50)).executes(SetCommand::setRadius)))).then(class_2170.method_9247((String)"eventCenterPosition").executes(SetCommand::setEventCenterPosition))).then(class_2170.method_9247((String)"playerTeleportPosition").executes(SetCommand::setTeleportPosition))).then(class_2170.method_9247((String)"lootFrequency").then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)10)).executes(SetCommand::setLootFrequency)))).then(class_2170.method_9247((String)"lootStackLimit").then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)50)).executes(SetCommand::setLootStackLimit)))).then(class_2170.method_9247((String)"maximumStackSize").then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(SetCommand::setMaximumStackSize)))).then(class_2170.method_9247((String)"unclaimedRewardsNotificationSeconds").then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)5)).executes(SetCommand::setNotificationSeconds)));
    }

    private static boolean checkCanModify() {
        return !LootEventSystem.isEventStarted();
    }

    private static int setAnnouncerName(CommandContext<class_2168> context) {
        if (SetCommand.checkCanModify()) {
            ConfigManager.CONFIG.announcerName = StringArgumentType.getString(context, (String)"value");
            ConfigManager.save();
            ((class_2168)context.getSource()).method_9226(() -> CommandUtil.successText("Set announcer name to: " + ConfigManager.CONFIG.announcerName), false);
            return 1;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)CommandUtil.failText("You cannot modify any settings because an event is underway"));
        return 0;
    }

    private static int setAdminPermissionLevel(CommandContext<class_2168> context) {
        if (SetCommand.checkCanModify()) {
            ConfigManager.CONFIG.adminPermissionLevel = IntegerArgumentType.getInteger(context, (String)"value");
            ConfigManager.save();
            ((class_2168)context.getSource()).method_9226(() -> CommandUtil.successText("Set admin permission level to: " + ConfigManager.CONFIG.adminPermissionLevel), false);
            return 1;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)CommandUtil.failText("You cannot modify any settings because an event is underway"));
        return 0;
    }

    private static int setEventCountdownSeconds(CommandContext<class_2168> context) {
        if (SetCommand.checkCanModify()) {
            ConfigManager.CONFIG.eventCountdownSeconds = IntegerArgumentType.getInteger(context, (String)"value");
            ConfigManager.save();
            ((class_2168)context.getSource()).method_9226(() -> CommandUtil.successText("Set event countdown (seconds) to: " + ConfigManager.CONFIG.eventCountdownSeconds), false);
            return 1;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)CommandUtil.failText("You cannot modify any settings because an event is underway"));
        return 0;
    }

    private static int setEventDurationSeconds(CommandContext<class_2168> context) {
        if (SetCommand.checkCanModify()) {
            ConfigManager.CONFIG.eventDurationSeconds = IntegerArgumentType.getInteger(context, (String)"value");
            ConfigManager.save();
            ((class_2168)context.getSource()).method_9226(() -> CommandUtil.successText("Set event duration (seconds) to: " + ConfigManager.CONFIG.eventDurationSeconds), false);
            return 1;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)CommandUtil.failText("You cannot modify any settings because an event is underway"));
        return 0;
    }

    private static int setEventType(CommandContext<class_2168> context) {
        if (SetCommand.checkCanModify()) {
            String eventType = StringArgumentType.getString(context, (String)"value");
            if (ConfigManager.VALID_EVENT_TYPES.contains(eventType)) {
                ConfigManager.CONFIG.eventType = eventType;
                ConfigManager.save();
                ((class_2168)context.getSource()).method_9226(() -> CommandUtil.successText("Set event type to: " + ConfigManager.CONFIG.eventType), false);
                return 1;
            }
            ((class_2168)context.getSource()).method_9213((class_2561)CommandUtil.failText("'" + eventType + "' is not a valid event type. Valid options: " + String.join((CharSequence)", ", ConfigManager.VALID_EVENT_TYPES)));
            return 0;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)CommandUtil.failText("You cannot modify any settings because an event is underway"));
        return 0;
    }

    private static int setRadius(CommandContext<class_2168> context) {
        if (SetCommand.checkCanModify()) {
            ConfigManager.CONFIG.radius = IntegerArgumentType.getInteger(context, (String)"value");
            ConfigManager.save();
            ((class_2168)context.getSource()).method_9226(() -> CommandUtil.successText("Set radius to: " + ConfigManager.CONFIG.radius), false);
            return 1;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)CommandUtil.failText("You cannot modify any settings because an event is underway"));
        return 0;
    }

    private static int setEventCenterPosition(CommandContext<class_2168> context) {
        if (SetCommand.checkCanModify()) {
            if (((class_2168)context.getSource()).method_43737()) {
                ConfigManager.CONFIG.eventDimension = ((class_2168)context.getSource()).method_44023().method_37908().method_27983().method_29177().toString();
                ConfigManager.CONFIG.eventCenterPosition = ((class_2168)context.getSource()).method_44023().method_24515();
                ConfigManager.save();
                ((class_2168)context.getSource()).method_9226(() -> CommandUtil.successText("Set event center position to: " + ConfigManager.CONFIG.eventDimension + ", " + String.valueOf(ConfigManager.CONFIG.eventCenterPosition)), false);
                return 1;
            }
            ((class_2168)context.getSource()).method_9213((class_2561)CommandUtil.failText("This command can only be run by a player"));
            return 0;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)CommandUtil.failText("You cannot modify any settings because an event is underway"));
        return 0;
    }

    private static int setTeleportPosition(CommandContext<class_2168> context) {
        if (SetCommand.checkCanModify()) {
            if (((class_2168)context.getSource()).method_43737()) {
                ConfigManager.CONFIG.playerTeleportDimension = ((class_2168)context.getSource()).method_44023().method_37908().method_27983().method_29177().toString();
                ConfigManager.CONFIG.playerTeleportPosition = ((class_2168)context.getSource()).method_44023().method_24515();
                ConfigManager.save();
                ((class_2168)context.getSource()).method_9226(() -> CommandUtil.successText("Set teleport position to: " + ConfigManager.CONFIG.playerTeleportDimension + ", " + String.valueOf(ConfigManager.CONFIG.playerTeleportPosition)), false);
                return 1;
            }
            ((class_2168)context.getSource()).method_9213((class_2561)CommandUtil.failText("This command can only be run by a player"));
            return 0;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)CommandUtil.failText("You cannot modify any settings because an event is underway"));
        return 0;
    }

    private static int setLootFrequency(CommandContext<class_2168> context) {
        if (SetCommand.checkCanModify()) {
            ConfigManager.CONFIG.lootFrequency = IntegerArgumentType.getInteger(context, (String)"value");
            ConfigManager.save();
            ((class_2168)context.getSource()).method_9226(() -> CommandUtil.successText("Set loot frequency to: " + ConfigManager.CONFIG.lootFrequency), false);
            return 1;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)CommandUtil.failText("You cannot modify any settings because an event is underway"));
        return 0;
    }

    private static int setLootStackLimit(CommandContext<class_2168> context) {
        if (SetCommand.checkCanModify()) {
            ConfigManager.CONFIG.lootStackLimit = IntegerArgumentType.getInteger(context, (String)"value");
            ConfigManager.save();
            ((class_2168)context.getSource()).method_9226(() -> CommandUtil.successText("Set loot stack limit to: " + ConfigManager.CONFIG.lootStackLimit), false);
            return 1;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)CommandUtil.failText("You cannot modify any settings because an event is underway"));
        return 0;
    }

    private static int setMaximumStackSize(CommandContext<class_2168> context) {
        if (SetCommand.checkCanModify()) {
            ConfigManager.CONFIG.maximumStackSize = IntegerArgumentType.getInteger(context, (String)"value");
            ConfigManager.save();
            ((class_2168)context.getSource()).method_9226(() -> CommandUtil.successText("Set maximum stack size to: " + ConfigManager.CONFIG.maximumStackSize), false);
            return 1;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)CommandUtil.failText("You cannot modify any settings because an event is underway"));
        return 0;
    }

    private static int setNotificationSeconds(CommandContext<class_2168> context) {
        if (SetCommand.checkCanModify()) {
            ConfigManager.CONFIG.unclaimedRewardsNotificationSeconds = IntegerArgumentType.getInteger(context, (String)"value");
            ConfigManager.save();
            ((class_2168)context.getSource()).method_9226(() -> CommandUtil.successText("Set unclaimed rewards notification (seconds) to: " + ConfigManager.CONFIG.unclaimedRewardsNotificationSeconds), false);
            return 1;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)CommandUtil.failText("You cannot modify any settings because an event is underway"));
        return 0;
    }
}

