/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.lootevents.command;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_5250;
import uk.co.dotcode.lootevents.LootEventSystem;
import uk.co.dotcode.lootevents.command.CommandUtil;
import uk.co.dotcode.lootevents.config.ConfigManager;

public class SettingsCommand {
    public static ArgumentBuilder<class_2168, ?> build() {
        return ((LiteralArgumentBuilder)class_2170.method_9247((String)"settings").requires(source -> source.method_9259(ConfigManager.CONFIG.adminPermissionLevel.intValue()))).executes(SettingsCommand::execute);
    }

    public static int execute(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> CommandUtil.styledText("=== Current CLE Settings ===", -22016), false);
        ((class_2168)context.getSource()).method_9226(() -> SettingsCommand.checkValid("Announcer Name", ConfigManager.CONFIG.announcerName), false);
        ((class_2168)context.getSource()).method_9226(() -> SettingsCommand.checkValid("Admin Permission Level", Integer.toString(ConfigManager.CONFIG.adminPermissionLevel)), false);
        ((class_2168)context.getSource()).method_9226(() -> SettingsCommand.checkValid("Blacklisted Items", ConfigManager.CONFIG.blacklistedItems.size() + " (/cle blacklistedItems)"), false);
        ((class_2168)context.getSource()).method_9226(() -> SettingsCommand.checkValid("Event Countdown (seconds)", Integer.toString(ConfigManager.CONFIG.eventCountdownSeconds)), false);
        ((class_2168)context.getSource()).method_9226(() -> SettingsCommand.checkValid("Event Duration (seconds)", Integer.toString(ConfigManager.CONFIG.eventDurationSeconds)), false);
        ((class_2168)context.getSource()).method_9226(() -> SettingsCommand.checkValid("Event Type", ConfigManager.CONFIG.eventType), false);
        ((class_2168)context.getSource()).method_9226(() -> SettingsCommand.checkValid("Radius", ConfigManager.CONFIG.radius), false);
        ((class_2168)context.getSource()).method_9226(() -> SettingsCommand.checkValid("Event Center Dimension", ConfigManager.CONFIG.eventDimension), false);
        ((class_2168)context.getSource()).method_9226(() -> SettingsCommand.checkValid("Event Center Position", ConfigManager.CONFIG.eventCenterPosition), false);
        ((class_2168)context.getSource()).method_9226(() -> SettingsCommand.checkValid("Player Teleport Dimension", ConfigManager.CONFIG.playerTeleportDimension), false);
        ((class_2168)context.getSource()).method_9226(() -> SettingsCommand.checkValid("Player Teleport Position", ConfigManager.CONFIG.playerTeleportPosition), false);
        ((class_2168)context.getSource()).method_9226(() -> SettingsCommand.checkValid("Loot Frequency", ConfigManager.CONFIG.lootFrequency), false);
        ((class_2168)context.getSource()).method_9226(() -> SettingsCommand.checkValid("Loot Stack Limit", Integer.toString(ConfigManager.CONFIG.lootStackLimit)), false);
        ((class_2168)context.getSource()).method_9226(() -> SettingsCommand.checkValid("Maximum Stack Size", Integer.toString(ConfigManager.CONFIG.maximumStackSize)), false);
        if (LootEventSystem.isEventPrepared() && !LootEventSystem.isEventStarted()) {
            ((class_2168)context.getSource()).method_9226(() -> CommandUtil.formatRow("Event Status", "Event is currently being prepared", -256), false);
        } else if (LootEventSystem.isEventStarted()) {
            ((class_2168)context.getSource()).method_9226(() -> CommandUtil.formatRow("Event Status", "Event is underway!", -16711936), false);
            ((class_2168)context.getSource()).method_9226(() -> CommandUtil.formatRow("Remaining Event Time", LootEventSystem.getRemainingTime() + " seconds", -16711936), false);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> CommandUtil.formatRow("Event Status", "No events underway", -2142128), false);
        }
        ((class_2168)context.getSource()).method_9226(() -> CommandUtil.styledText("=========================", -22016), false);
        return 1;
    }

    private static class_5250 checkValid(String key, Object value) {
        if (value != null) {
            return CommandUtil.formatRow(key, value.toString(), -16711936);
        }
        return CommandUtil.formatRow(key, "NOT SET", -2142128);
    }
}

