/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.lootevents.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import uk.co.dotcode.lootevents.config.ModConfig;

public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File("config/Collapsing Loot Events.json");
    public static ModConfig CONFIG = new ModConfig();
    public static final List<String> VALID_EVENT_TYPES = Arrays.asList("itemdrop");

    public static ArrayList<String> validate() {
        ArrayList<String> errors = new ArrayList<String>();
        if (ConfigManager.CONFIG.announcerName == null || ConfigManager.CONFIG.announcerName.isEmpty()) {
            errors.add("Announcer Name invalid (/cle set announcerName)");
        }
        if (ConfigManager.CONFIG.adminPermissionLevel == null || ConfigManager.CONFIG.adminPermissionLevel < 0) {
            errors.add("Admin Permission Level invalid (/cle set adminPermissionLevel)");
        }
        if (ConfigManager.CONFIG.eventCountdownSeconds == null || ConfigManager.CONFIG.eventCountdownSeconds < 3) {
            errors.add("Event Countdown (Seconds) invalid (/cle set eventCountdownSeconds)");
        }
        if (ConfigManager.CONFIG.eventDurationSeconds == null || ConfigManager.CONFIG.eventDurationSeconds < 5) {
            errors.add("Event Duration (Seconds) invalid (/cle set eventDurationSeconds)");
        }
        if (ConfigManager.CONFIG.eventType == null || !VALID_EVENT_TYPES.contains(ConfigManager.CONFIG.eventType)) {
            errors.add("Event Type invalid (/cle set eventType)");
        }
        if (ConfigManager.CONFIG.radius == null || ConfigManager.CONFIG.radius < 1 || ConfigManager.CONFIG.radius > 50) {
            errors.add("Radius invalid (/cle set radius)");
        }
        if (ConfigManager.CONFIG.eventCenterPosition == null) {
            errors.add("Event Center Position invalid (/cle set eventCenterPosition)");
        }
        if (ConfigManager.CONFIG.eventDimension == null || ConfigManager.CONFIG.eventDimension.isEmpty()) {
            errors.add("Event Dimension invalid (/cle set eventCenterPosition)");
        }
        if (ConfigManager.CONFIG.playerTeleportPosition == null) {
            errors.add("Player Teleport Position invalid (/cle set playerTeleportPosition)");
        }
        if (ConfigManager.CONFIG.playerTeleportDimension == null || ConfigManager.CONFIG.playerTeleportDimension.isEmpty()) {
            errors.add("Player Teleport Dimension invalid (/cle set playerTeleportPosition)");
        }
        if (ConfigManager.CONFIG.lootFrequency == null || ConfigManager.CONFIG.lootFrequency < 1 || ConfigManager.CONFIG.lootFrequency > 10) {
            errors.add("Loot Frequency invalid (/cle set lootFrequency)");
        }
        if (ConfigManager.CONFIG.lootStackLimit == null || ConfigManager.CONFIG.lootStackLimit < 1) {
            errors.add("Loot Stack Limit invalid (/cle set lootStackLimit)");
        }
        if (ConfigManager.CONFIG.maximumStackSize == null || ConfigManager.CONFIG.maximumStackSize < 1 || ConfigManager.CONFIG.maximumStackSize > 64) {
            errors.add("Maximum Stack Size invalid (/cle set maximumStackSize");
        }
        return errors;
    }

    public static void load() {
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                CONFIG = (ModConfig)GSON.fromJson((Reader)reader, ModConfig.class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        ConfigManager.save();
    }

    public static void save() {
        try {
            CONFIG_FILE.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(CONFIG_FILE);){
                GSON.toJson((Object)CONFIG, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

