/*
 * Decompiled with CFR 0.152.
 */
package chat.cosmic.client.client;

import chat.cosmic.client.client.KeyBinds.KeyBinds;
import chat.cosmic.client.client.SettingsManager;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1787;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1831;
import net.minecraft.class_1835;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class Amor
implements ClientModInitializer {
    private static final String DEFAULT_SOUND = "minecraft:block.note_block.pling";
    private final Map<class_1799, Integer> notificationCounts = new HashMap<class_1799, Integer>();
    private final Map<UUID, Integer> playerThresholds = new HashMap<UUID, Integer>();
    private final Map<UUID, String> playerSoundPreferences = new HashMap<UUID, String>();
    public static boolean enabled = true;
    private final List<ArmorDisplayInfo> lowDurabilityItems = new ArrayList<ArmorDisplayInfo>();
    private static final SuggestionProvider<?> SOUND_SUGGESTIONS = (context, builder) -> {
        List<String> suggestions = Arrays.asList(DEFAULT_SOUND, "reset");
        for (String suggestion : suggestions) {
            builder.suggest(suggestion);
        }
        return CompletableFuture.completedFuture(builder.build());
    };

    public void onInitializeClient() {
        ClientTickEvents.END_CLIENT_TICK.register(this::onClientTick);
        this.registerCommands();
        HudRenderCallback.EVENT.register(this::renderArmorDisplay);
    }

    private void onClientTick(class_310 client) {
        if (client.field_1724 == null) {
            return;
        }
        while (KeyBinds.getToggleDurabilityAlerts().method_1436()) {
            enabled = !enabled;
            SettingsManager.getToggleSettings().put("Armor Durability Alerts", enabled);
            SettingsManager.saveSettings();
            client.field_1724.method_7353(class_2561.method_30163((String)(enabled ? "\u00a7aDurability alerts enabled" : "\u00a7cDurability alerts disabled")), true);
        }
        if (!enabled) {
            this.lowDurabilityItems.clear();
            return;
        }
        UUID playerUUID = client.field_1724.method_5667();
        int threshold = this.playerThresholds.getOrDefault(playerUUID, 15);
        String soundName = this.playerSoundPreferences.getOrDefault(playerUUID, DEFAULT_SOUND);
        ArrayList<class_1799> itemsToCheck = new ArrayList<class_1799>();
        for (int i = 0; i < 4; ++i) {
            class_1799 armorStack = (class_1799)client.field_1724.method_31548().field_7548.get(i);
            if (armorStack.method_7960() || i == 3 && this.isPlayerHead(armorStack)) continue;
            itemsToCheck.add(armorStack);
        }
        this.addHandItem(itemsToCheck, client.field_1724.method_6047());
        this.addHandItem(itemsToCheck, client.field_1724.method_6079());
        this.lowDurabilityItems.clear();
        boolean shouldPlaySound = false;
        for (class_1799 stack : itemsToCheck) {
            if (stack.method_7936() <= 0) continue;
            int currentDurability = stack.method_7936() - stack.method_7919();
            int durabilityPercent = (int)((double)currentDurability / (double)stack.method_7936() * 100.0);
            if (currentDurability <= threshold) {
                String itemName = this.getSimpleName(stack.method_7964().getString());
                this.lowDurabilityItems.add(new ArmorDisplayInfo(stack, durabilityPercent, itemName));
                int count = this.notificationCounts.getOrDefault(stack, 0);
                if (count >= 1) continue;
                client.field_1724.method_7353(class_2561.method_30163((String)("\u00a7c" + itemName + " is low on durability! (" + durabilityPercent + "%)")), false);
                this.notificationCounts.put(stack, count + 1);
                shouldPlaySound = true;
                continue;
            }
            this.notificationCounts.remove(stack);
        }
        if (shouldPlaySound) {
            this.playCustomSound(client, soundName);
        }
    }

    private String getSimpleName(String fullName) {
        return fullName.replace("Diamond ", "").replace("Iron ", "").replace("Golden ", "Gold ").replace("Leather ", "").replace("Chainmail ", "Chain ").replace("Netherite ", "Neth ");
    }

    private void playCustomSound(class_310 client, String soundName) {
        try {
            class_2960 soundId = new class_2960(soundName);
            class_3414 soundEvent = class_3414.method_47908((class_2960)soundId);
            client.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)soundEvent, (float)1.0f));
        }
        catch (Exception e) {
            client.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3414.method_47908((class_2960)new class_2960(DEFAULT_SOUND)), (float)1.0f));
        }
    }

    private void renderArmorDisplay(class_332 context, float tickDelta) {
        if (!enabled || this.lowDurabilityItems.isEmpty()) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        int screenWidth = context.method_51421();
        int screenHeight = context.method_51443();
        class_327 textRenderer = client.field_1772;
        ArmorDisplayInfo info = this.lowDurabilityItems.get(0);
        int centerX = screenWidth / 2;
        int centerY = screenHeight / 2 - 30;
        String alertText = "about to break";
        int textWidth = textRenderer.method_1727(alertText);
        int totalWidth = 20 + textWidth + 4 + textRenderer.method_1727("!");
        int itemX = centerX - totalWidth / 2;
        int itemY = centerY - 8;
        context.method_51427(info.stack, itemX, itemY);
        int textX = itemX + 16 + 4;
        int textY = centerY - 4;
        context.method_51433(textRenderer, alertText, textX, textY, -65536, true);
        int exclamationX = textX + textWidth + 4;
        context.method_51433(textRenderer, "!", exclamationX, textY, -65536, true);
    }

    private void addHandItem(List<class_1799> list, class_1799 stack) {
        if (!stack.method_7960() && this.isToolOrWeapon(stack)) {
            list.add(stack);
        }
    }

    private boolean isPlayerHead(class_1799 stack) {
        class_2960 itemId = class_7923.field_41178.method_10221((Object)stack.method_7909());
        return itemId.toString().equals("minecraft:player_head");
    }

    private boolean isToolOrWeapon(class_1799 stack) {
        class_1792 item = stack.method_7909();
        return item instanceof class_1831 || item instanceof class_1829 || item instanceof class_1835 || item instanceof class_1753 || item instanceof class_1764 || item instanceof class_1787;
    }

    private void registerCommands() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"dur").then(ClientCommandManager.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)300)).executes(context -> {
                int value = IntegerArgumentType.getInteger((CommandContext)context, (String)"value");
                class_310 client = class_310.method_1551();
                if (client.field_1724 != null) {
                    UUID playerUUID = client.field_1724.method_5667();
                    this.playerThresholds.put(playerUUID, value);
                    client.field_1724.method_7353(class_2561.method_30163((String)("\u00a7aDurability warning set to: " + value)), false);
                }
                return 1;
            })));
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"dursound").then(ClientCommandManager.argument((String)"sound", (ArgumentType)StringArgumentType.string()).suggests(SOUND_SUGGESTIONS).executes(context -> {
                String sound = StringArgumentType.getString((CommandContext)context, (String)"sound");
                class_310 client = class_310.method_1551();
                if (client.field_1724 != null) {
                    UUID playerUUID = client.field_1724.method_5667();
                    if (sound.equalsIgnoreCase("reset")) {
                        this.playerSoundPreferences.remove(playerUUID);
                        client.field_1724.method_7353(class_2561.method_30163((String)"\u00a7aAlert sound reset to default."), false);
                        this.playCustomSound(client, DEFAULT_SOUND);
                    } else {
                        this.playerSoundPreferences.put(playerUUID, sound);
                        client.field_1724.method_7353(class_2561.method_30163((String)("\u00a7aAlert sound set to: " + sound)), false);
                        this.playCustomSound(client, sound);
                    }
                }
                return 1;
            })));
        });
    }

    @Environment(value=EnvType.CLIENT)
    private static class ArmorDisplayInfo {
        final class_1799 stack;
        final int durabilityPercent;
        final String name;

        ArmorDisplayInfo(class_1799 stack, int durabilityPercent, String name) {
            this.stack = stack;
            this.durabilityPercent = durabilityPercent;
            this.name = name;
        }
    }
}

