/*
 * Decompiled with CFR 0.152.
 */
package chat.cosmic.client.client;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;

@Environment(value=EnvType.CLIENT)
public class CalculatorMod
implements ClientModInitializer {
    public void onInitializeClient() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"calculator").then(ClientCommandManager.argument((String)"expression", (ArgumentType)StringArgumentType.greedyString()).executes((Command)new CalculatorCommand())));
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"calc").then(ClientCommandManager.argument((String)"expression", (ArgumentType)StringArgumentType.greedyString()).executes((Command)new CalculatorCommand())));
        });
    }

    @Environment(value=EnvType.CLIENT)
    private static class CalculatorCommand
    implements Command<FabricClientCommandSource> {
        private CalculatorCommand() {
        }

        public int run(CommandContext<FabricClientCommandSource> context) throws CommandSyntaxException {
            String input = StringArgumentType.getString(context, (String)"expression").replaceAll("\\s", "").toLowerCase();
            if (input.isEmpty()) {
                this.sendError(context, "Expression cannot be empty! Example: /calc 1.5k*2");
                return 0;
            }
            try {
                List<Object> tokens = this.tokenize(input);
                List<Object> processedTokens = this.evaluateMultDiv(tokens);
                double result = this.evaluateAddSub(processedTokens);
                this.sendFormattedResult(context, input, result);
            }
            catch (Exception e) {
                this.sendError(context, "Error: " + e.getMessage());
            }
            return 1;
        }

        private List<Object> tokenize(String expr) throws Exception {
            ArrayList<Object> tokens = new ArrayList<Object>();
            int index = 0;
            while (index < expr.length()) {
                char c = expr.charAt(index);
                if (Character.isDigit(c) || c == '.' || c == '-' && (tokens.isEmpty() || this.isOperator(tokens.get(tokens.size() - 1)))) {
                    NumberToken token = this.parseNumber(expr, index);
                    tokens.add(token.value);
                    index += token.length;
                    continue;
                }
                if (c == '+' || c == '-' || c == '*' || c == '/' || c == 'x') {
                    tokens.add(Character.valueOf(c));
                    ++index;
                    continue;
                }
                throw new Exception("Invalid character: '" + c + "'");
            }
            return tokens;
        }

        private boolean isOperator(Object token) {
            return token instanceof Character && "+-*/x".indexOf(((Character)token).charValue()) >= 0;
        }

        private NumberToken parseNumber(String expr, int start) throws Exception {
            double value;
            int end;
            int originalStart = start;
            boolean isNegative = false;
            if (expr.charAt(start) == '-') {
                isNegative = true;
                ++start;
            }
            for (end = start; end < expr.length() && (Character.isDigit(expr.charAt(end)) || expr.charAt(end) == '.'); ++end) {
            }
            String numberPart = expr.substring(start, end);
            if (numberPart.isEmpty() || numberPart.equals(".")) {
                throw new Exception("Invalid number format");
            }
            try {
                value = Double.parseDouble(numberPart);
            }
            catch (NumberFormatException e) {
                throw new Exception("Invalid number: " + numberPart);
            }
            if (isNegative) {
                value = -value;
            }
            int suffixLength = 0;
            if (end < expr.length()) {
                char suffix = expr.charAt(end);
                switch (suffix) {
                    case 'k': {
                        value *= 1000.0;
                        suffixLength = 1;
                        break;
                    }
                    case 'm': {
                        value *= 1000000.0;
                        suffixLength = 1;
                        break;
                    }
                    case 'b': {
                        value *= 1.0E9;
                        suffixLength = 1;
                    }
                }
            }
            int totalLength = end - start + suffixLength + (isNegative ? 1 : 0);
            return new NumberToken(value, totalLength);
        }

        private List<Object> evaluateMultDiv(List<Object> tokens) throws Exception {
            ArrayList<Object> result = new ArrayList<Object>();
            int i = 0;
            while (i < tokens.size()) {
                if (tokens.get(i) instanceof Character) {
                    char operator = ((Character)tokens.get(i)).charValue();
                    if (operator == '*' || operator == 'x' || operator == '/') {
                        double calculated;
                        if (result.isEmpty() || i + 1 >= tokens.size() || !(tokens.get(i + 1) instanceof Double)) {
                            throw new Exception("Missing operand for operator '" + operator + "'");
                        }
                        double left = (Double)result.remove(result.size() - 1);
                        double right = (Double)tokens.get(i + 1);
                        if (operator == '*' || operator == 'x') {
                            calculated = left * right;
                        } else {
                            if (right == 0.0) {
                                throw new Exception("Division by zero");
                            }
                            calculated = left / right;
                        }
                        result.add(calculated);
                        i += 2;
                        continue;
                    }
                    result.add(Character.valueOf(operator));
                    ++i;
                    continue;
                }
                result.add(tokens.get(i));
                ++i;
            }
            return result;
        }

        private double evaluateAddSub(List<Object> tokens) throws Exception {
            if (tokens.isEmpty()) {
                throw new Exception("Empty expression");
            }
            if (!(tokens.get(0) instanceof Double)) {
                throw new Exception("Expression must start with a number");
            }
            double result = (Double)tokens.get(0);
            for (int i = 1; i < tokens.size(); i += 2) {
                if (i + 1 >= tokens.size()) {
                    throw new Exception("Missing operand");
                }
                char operator = ((Character)tokens.get(i)).charValue();
                double operand = (Double)tokens.get(i + 1);
                if (operator == '+') {
                    result += operand;
                    continue;
                }
                if (operator == '-') {
                    result -= operand;
                    continue;
                }
                throw new Exception("Unexpected operator: " + operator);
            }
            return result;
        }

        private void sendFormattedResult(CommandContext<FabricClientCommandSource> context, String input, double result) {
            String formatted;
            if (result == (double)((long)result)) {
                formatted = String.format("%,d", (long)result);
            } else {
                BigDecimal bd = BigDecimal.valueOf(result).setScale(4, RoundingMode.HALF_UP).stripTrailingZeros();
                formatted = bd.toPlainString();
            }
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a76" + input + " \u00a7r= \u00a7a" + formatted)));
        }

        private void sendError(CommandContext<FabricClientCommandSource> context, String message) {
            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)("\u00a7c" + message)));
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class NumberToken {
        public final double value;
        public final int length;

        public NumberToken(double value, int length) {
            this.value = value;
            this.length = length;
        }
    }
}

