/*
 * Decompiled with CFR 0.152.
 */
package chat.cosmic.client.client;

import chat.cosmic.client.client.KeyBinds.KeyBinds;
import chat.cosmic.client.client.UniversalGuiMover;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1041;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1787;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_746;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class ChestTrackerMod
implements ClientModInitializer {
    private static int mythicCount = 0;
    private static int godlyCount = 0;
    private static int heroicCount = 0;
    private static int artifactCount = 0;
    private static int sunkenGemsCount = 0;
    private static int skullCount = 0;
    private static final Map<String, Integer> chestCounts = new HashMap<String, Integer>();
    private static final Map<String, Integer> sysChestCounts = new HashMap<String, Integer>();
    private static final Map<String, Integer> questCounts = new HashMap<String, Integer>();
    private static final Map<String, Map<String, Integer>> gemSourceCounts = new HashMap<String, Map<String, Integer>>();
    private static final Map<String, Integer> tierColors = Map.of("Basic", 0xFFFFFF, "Elite", 5569788, "Legendary", 16753920, "Godly", 0xFF0000, "Heroic", 16738740, "Mythic", 0x800080, "Tire", 0xC0C0C0);
    private static final String[] TIERS = new String[]{"Basic", "Elite", "Legendary", "Godly", "Heroic", "Mythic"};
    private static final String[] SYS_TIERS = new String[]{"Basic", "Elite", "Legendary", "Godly", "Heroic", "Mythic", "Tire"};
    private static final String[] GEM_SOURCES = new String[]{"Attribute", "Gem Finder", "Mining Rush", "Dug Up", "Mystery"};
    private static final String[] GEM_TYPES = new String[]{"Minor", "Major", "Perfect"};
    private static final Pattern CHEST_PATTERN = Pattern.compile("\\* (Basic|Elite|Legendary|Godly|Heroic|Mythic) Chest dropped nearby! \\*");
    private static final Pattern SYS_CHEST_PATTERN = Pattern.compile("\\* (Basic|Elite|Legendary|Godly|Heroic|Mythic) Chest dropped nearby!\\s+\\(System Override\\) \\*");
    private static final Pattern TIRE_SYS_CHEST_PATTERN = Pattern.compile("\\* Tire Chest dropped nearby!\\s+\\(System Override\\) \\*");
    private static final Pattern MAX_GEM_PATTERN = Pattern.compile("\\* \\+1 MAX GEM FOUND \\*");
    private static final Pattern QUEST_PATTERN = Pattern.compile(".*Island Quest COMPLETE: (Basic|Elite|Legendary|Godly|Heroic|Mythic).*");
    private static final Pattern PICKAXE_ATTRIBUTE_PATTERN = Pattern.compile(".*attribute found you a (Minor|Major|Perfect) (Diamond|Iron|Stone) Gem.*");
    private static final Pattern GEM_FINDER_PATTERN = Pattern.compile(".*Gem Finder \\(.*\\) found you a (Minor|Major|Perfect) (Diamond|Iron|Stone) Gem.*");
    private static final Pattern DUG_UP_PATTERN = Pattern.compile(".*You've dug up a (Minor|Major|Perfect) (Diamond|Iron|Stone) Gem.*");
    private static final Pattern MINING_RUSH_GEM_PATTERN = Pattern.compile(".*Mining Rush found you a (Minor|Major|Perfect) (Diamond|Iron|Stone) Gem.*");
    private static int maxGemCount = 0;
    private static int minorGemCount = 0;
    private static int majorGemCount = 0;
    private static int perfectGemCount = 0;
    private static boolean hudVisible = true;
    private static final Path CONFIG_PATH = Path.of("config/unifiedtracker_hud.dat", new String[0]);
    private static long startTime = 0L;
    private static long pausedTime = 0L;
    private static boolean isTimerRunning = false;
    private static boolean needsBoundaryCheck = true;
    private static boolean showSysView = false;
    private static boolean showGemsView = false;
    private static boolean showQuestView = false;
    private static boolean modEnabled = true;
    private static long sysViewEndTime = 0L;
    private static long gemsViewEndTime = 0L;
    private static long questViewEndTime = 0L;
    public static final class_2960 MYTHIC_SOUND_ID = new class_2960("mythictracker", "mythic_sound");
    public static final class_2960 GODLY_SOUND_ID = new class_2960("mythictracker", "godly_sound");
    public static final class_2960 HEROIC_SOUND_ID = new class_2960("mythictracker", "heroic_sound");
    public static class_3414 MYTHIC_SOUND = class_3414.method_47908((class_2960)MYTHIC_SOUND_ID);
    public static class_3414 GODLY_SOUND = class_3414.method_47908((class_2960)GODLY_SOUND_ID);
    public static class_3414 HEROIC_SOUND = class_3414.method_47908((class_2960)HEROIC_SOUND_ID);
    private static final UniversalGuiMover.HudContainer hudContainer = new UniversalGuiMover.HudContainer(10, 100, 120, 9, 8);

    public static void setModEnabled(boolean enabled) {
        modEnabled = enabled;
    }

    public static void setHudEnabled(boolean enabled) {
        hudVisible = enabled;
    }

    public void onInitializeClient() {
        this.initializeCounts();
        this.initializeGemSourceCounts();
        this.loadHudPosition();
        UniversalGuiMover.trackHudContainer("unifiedTrackerHud", hudContainer);
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)MYTHIC_SOUND_ID, (Object)MYTHIC_SOUND);
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)GODLY_SOUND_ID, (Object)GODLY_SOUND);
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)HEROIC_SOUND_ID, (Object)HEROIC_SOUND);
        ClientTickEvents.END_CLIENT_TICK.register(this::handleClientTick);
        ClientTickEvents.START_CLIENT_TICK.register(this::handleBoundaryCheck);
        HudRenderCallback.EVENT.register(this::renderHud);
        ClientReceiveMessageEvents.GAME.register(this::handleChatMessage);
        this.registerCommands();
    }

    private void initializeCounts() {
        for (String tier : TIERS) {
            chestCounts.put(tier, 0);
            questCounts.put(tier, 0);
        }
        for (String tier : SYS_TIERS) {
            sysChestCounts.put(tier, 0);
        }
    }

    private void initializeGemSourceCounts() {
        for (String source : GEM_SOURCES) {
            gemSourceCounts.put(source, new HashMap());
            for (String type : GEM_TYPES) {
                gemSourceCounts.get(source).put(type, 0);
            }
        }
    }

    private void registerCommands() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"sys").executes(ctx -> {
                showSysView = true;
                showGemsView = false;
                showQuestView = false;
                sysViewEndTime = System.currentTimeMillis() + 10000L;
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Showing System Override stats for 10 seconds"));
                return 1;
            }));
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"gems").executes(ctx -> {
                showGemsView = true;
                showSysView = false;
                showQuestView = false;
                gemsViewEndTime = System.currentTimeMillis() + 10000L;
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Showing Gem Source stats for 10 seconds"));
                return 1;
            }));
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"quests").executes(ctx -> {
                showQuestView = true;
                showSysView = false;
                showGemsView = false;
                questViewEndTime = System.currentTimeMillis() + 10000L;
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Showing Quest stats for 10 seconds"));
                return 1;
            }));
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"trackerreset").executes(ctx -> {
                this.resetAllCounts();
                this.resetTimer();
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Reset all counts and timer!"));
                return 1;
            }));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"timer").then(ClientCommandManager.literal((String)"reset").executes(ctx -> {
                this.resetTimer();
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Timer reset!"));
                return 1;
            }))).then(ClientCommandManager.literal((String)"start").executes(ctx -> {
                if (!isTimerRunning) {
                    this.startTimer();
                }
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Timer started!"));
                return 1;
            }))).then(ClientCommandManager.literal((String)"pause").executes(ctx -> {
                if (isTimerRunning) {
                    this.pauseTimer();
                }
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Timer paused!"));
                return 1;
            })));
        });
    }

    private void handleClientTick(class_310 client) {
        if (KeyBinds.getChestTrackerReset().method_1436()) {
            this.resetAllCounts();
            this.resetTimer();
            this.sendClientMessage("Reset all counts and timer!");
        }
        if (KeyBinds.getChestTrackerStartPause().method_1436()) {
            this.handleTimerToggle();
        }
        if (KeyBinds.getChestTrackerToggleHud().method_1436()) {
            this.toggleHudVisibility();
        }
        if (showSysView && System.currentTimeMillis() > sysViewEndTime) {
            showSysView = false;
        }
        if (showGemsView && System.currentTimeMillis() > gemsViewEndTime) {
            showGemsView = false;
        }
        if (showQuestView && System.currentTimeMillis() > questViewEndTime) {
            showQuestView = false;
        }
    }

    private void handleBoundaryCheck(class_310 client) {
        if (needsBoundaryCheck && client.method_22683() != null) {
            class_1041 window = client.method_22683();
            ChestTrackerMod.hudContainer.x = this.clampHudX(ChestTrackerMod.hudContainer.x, window);
            ChestTrackerMod.hudContainer.y = this.clampHudY(ChestTrackerMod.hudContainer.y, window);
            needsBoundaryCheck = false;
            this.saveHudPosition();
        }
    }

    private int clampHudX(int x, class_1041 window) {
        return Math.max(5, Math.min(x, window.method_4486() - hudContainer.getScaledWidth() - 5));
    }

    private int clampHudY(int y, class_1041 window) {
        return Math.max(5, Math.min(y, window.method_4502() - hudContainer.getScaledHeight() - 5));
    }

    private void handleChatMessage(class_2561 message, boolean overlay) {
        boolean isServerMessage;
        String msg = message.getString();
        class_310 client = class_310.method_1551();
        boolean isPlayerMessage = msg.contains("->") || msg.matches(".*\\[.*\\].*");
        boolean bl = isServerMessage = !isPlayerMessage;
        if (isServerMessage || overlay) {
            String clean = msg.replaceAll("\u00a7[0-9a-fk-or]", "").trim();
            if (clean.contains("Mythic Treasure")) {
                ++mythicCount;
                this.playSound(client, MYTHIC_SOUND);
            } else if (clean.contains("Godly Treasure")) {
                ++godlyCount;
                this.playSound(client, GODLY_SOUND);
            } else if (clean.contains("Heroic Treasure")) {
                ++heroicCount;
                this.playSound(client, HEROIC_SOUND);
            } else if (clean.toUpperCase().contains("ARTIFACT FOUND:")) {
                ++artifactCount;
                this.playSound(client, HEROIC_SOUND);
            } else if (clean.toUpperCase().contains("* SUNKEN GEMS")) {
                ++sunkenGemsCount;
                this.playSound(client, HEROIC_SOUND);
            } else if (clean.startsWith("+") && clean.contains("Marauder Skull")) {
                String[] parts = clean.split(" ");
                try {
                    String numberPart = parts[0].replace("+", "").trim();
                    int amount = Integer.parseInt(numberPart);
                    skullCount += amount;
                    this.playSound(client, HEROIC_SOUND);
                }
                catch (NumberFormatException e) {
                    System.err.println("Failed to parse skull amount from: " + msg);
                }
            }
            Matcher chestMatcher = CHEST_PATTERN.matcher(clean);
            Matcher sysMatcher = SYS_CHEST_PATTERN.matcher(clean);
            Matcher tireSysMatcher = TIRE_SYS_CHEST_PATTERN.matcher(clean);
            Matcher maxGemMatcher = MAX_GEM_PATTERN.matcher(clean);
            Matcher questMatcher = QUEST_PATTERN.matcher(clean);
            Matcher pickaxeAttributeMatcher = PICKAXE_ATTRIBUTE_PATTERN.matcher(clean);
            Matcher gemFinderMatcher = GEM_FINDER_PATTERN.matcher(clean);
            Matcher dugUpMatcher = DUG_UP_PATTERN.matcher(clean);
            Matcher miningRushMatcher = MINING_RUSH_GEM_PATTERN.matcher(clean);
            if (chestMatcher.matches()) {
                String tier = chestMatcher.group(1);
                chestCounts.put(tier, chestCounts.getOrDefault(tier, 0) + 1);
            } else if (sysMatcher.matches()) {
                String tier = sysMatcher.group(1);
                sysChestCounts.put(tier, sysChestCounts.getOrDefault(tier, 0) + 1);
            } else if (tireSysMatcher.matches()) {
                sysChestCounts.put("Tire", sysChestCounts.getOrDefault("Tire", 0) + 1);
            } else if (questMatcher.matches() && this.isInSkyblockWorld()) {
                String tier = questMatcher.group(1);
                questCounts.put(tier, questCounts.getOrDefault(tier, 0) + 1);
            } else if (maxGemMatcher.matches() && this.isInSkyblockWorld() && this.isHoldingPickaxe()) {
                ++maxGemCount;
            } else if (this.isInSkyblockWorld() && this.isHoldingPickaxe()) {
                if (pickaxeAttributeMatcher.matches()) {
                    String gemType = pickaxeAttributeMatcher.group(1);
                    this.addGemToSource("Attribute", gemType);
                    this.updateGemCounts(gemType);
                } else if (gemFinderMatcher.matches()) {
                    String gemType = gemFinderMatcher.group(1);
                    this.addGemToSource("Gem Finder", gemType);
                    this.updateGemCounts(gemType);
                } else if (dugUpMatcher.matches()) {
                    String gemType = dugUpMatcher.group(1);
                    this.addGemToSource("Dug Up", gemType);
                    this.updateGemCounts(gemType);
                } else if (miningRushMatcher.matches()) {
                    String gemType = miningRushMatcher.group(1);
                    this.addGemToSource("Mining Rush", gemType);
                    this.updateGemCounts(gemType);
                }
            }
        }
    }

    private void addGemToSource(String source, String type) {
        Map<String, Integer> sourceMap = gemSourceCounts.get(source);
        if (sourceMap != null) {
            sourceMap.put(type, sourceMap.getOrDefault(type, 0) + 1);
        }
    }

    private void updateGemCounts(String gemType) {
        switch (gemType) {
            case "Minor": {
                ++minorGemCount;
                break;
            }
            case "Major": {
                ++majorGemCount;
                break;
            }
            case "Perfect": {
                ++perfectGemCount;
            }
        }
    }

    private void renderHud(class_332 context, float tickDelta) {
        if (!modEnabled || !hudVisible) {
            return;
        }
        class_310 client = class_310.method_1551();
        class_1041 window = client.method_22683();
        UniversalGuiMover.HudContainer container = UniversalGuiMover.getHudContainer("unifiedTrackerHud");
        if (client == null || window == null || container == null) {
            return;
        }
        ChestTrackerMod.hudContainer.x = container.x;
        ChestTrackerMod.hudContainer.y = container.y;
        if (UniversalGuiMover.isDragging()) {
            needsBoundaryCheck = true;
        } else if (needsBoundaryCheck) {
            ChestTrackerMod.hudContainer.x = this.clampHudX(ChestTrackerMod.hudContainer.x, window);
            ChestTrackerMod.hudContainer.y = this.clampHudY(ChestTrackerMod.hudContainer.y, window);
            this.saveHudPosition();
            needsBoundaryCheck = false;
        }
        float scale = UniversalGuiMover.getGlobalTextScale();
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)ChestTrackerMod.hudContainer.x, (float)ChestTrackerMod.hudContainer.y, 0.0f);
        context.method_51448().method_22905(scale, scale, 1.0f);
        class_327 renderer = client.field_1772;
        int yPos = 2;
        int padding = 2;
        context.method_25303(renderer, "\u00a7bTime: " + this.getElapsedTime(), 2, yPos, 0xFFFFFF);
        Objects.requireNonNull(renderer);
        yPos += 9 + (int)(2.0f / scale);
        if (this.isHoldingFishingRod()) {
            context.method_25303(renderer, "\u00a7b=== Fishing Tracker ===", 2, yPos, 0xFFFFFF);
            Objects.requireNonNull(renderer);
            context.method_25303(renderer, "\u00a7cGodly: " + godlyCount, 2, yPos += 9 + (int)(2.0f / scale), 0xFFFFFF);
            Objects.requireNonNull(renderer);
            context.method_25303(renderer, "\u00a7dHeroic: " + heroicCount, 2, yPos += 9 + (int)(2.0f / scale), 0xFFFFFF);
            Objects.requireNonNull(renderer);
            context.method_25303(renderer, "\u00a75Mythic: " + mythicCount, 2, yPos += 9 + (int)(2.0f / scale), 0xFFFFFF);
            Objects.requireNonNull(renderer);
            context.method_25303(renderer, "\u00a7bArtifact: " + artifactCount, 2, yPos += 9 + (int)(2.0f / scale), 0xFFFFFF);
            Objects.requireNonNull(renderer);
            context.method_25303(renderer, "\u00a76Gems: " + sunkenGemsCount, 2, yPos += 9 + (int)(2.0f / scale), 0xFFFFFF);
            Objects.requireNonNull(renderer);
            context.method_25303(renderer, "\u00a76Skulls: " + skullCount, 2, yPos += 9 + (int)(2.0f / scale), 0xFFFFFF);
        } else if (showGemsView) {
            context.method_25303(renderer, "=== Gem Sources ===", 2, yPos, 16766720);
            Objects.requireNonNull(renderer);
            yPos += 9 + (int)(2.0f / scale);
            for (String source : GEM_SOURCES) {
                Map<String, Integer> sourceMap = gemSourceCounts.get(source);
                int total = sourceMap.values().stream().mapToInt(Integer::intValue).sum();
                if (total <= 0) continue;
                context.method_25303(renderer, source + ": " + total, 2, yPos, 0xFFFFFF);
                Objects.requireNonNull(renderer);
                yPos += 9 + (int)(2.0f / scale);
            }
        } else if (showSysView) {
            for (String tier : SYS_TIERS) {
                int count = sysChestCounts.get(tier);
                if (count <= 0) continue;
                context.method_25303(renderer, tier + " (Sys): " + count, 2, yPos, tierColors.getOrDefault(tier, 0xFFFFFF).intValue());
                Objects.requireNonNull(renderer);
                yPos += 9 + (int)(2.0f / scale);
            }
        } else if (showQuestView) {
            for (String tier : TIERS) {
                int count = questCounts.get(tier);
                if (count <= 0) continue;
                context.method_25303(renderer, tier + " Quest: " + count, 2, yPos, tierColors.getOrDefault(tier, 0xFFFFFF).intValue());
                Objects.requireNonNull(renderer);
                yPos += 9 + (int)(2.0f / scale);
            }
        } else if (this.isInSkyblockWorld()) {
            if (this.isHoldingPickaxe()) {
                context.method_25303(renderer, "=== Gems ===", 2, yPos, 16766720);
                Objects.requireNonNull(renderer);
                context.method_25303(renderer, "Minor: " + minorGemCount, 2, yPos += 9 + (int)(2.0f / scale), 0xFFFFFF);
                Objects.requireNonNull(renderer);
                context.method_25303(renderer, "Major: " + majorGemCount, 2, yPos += 9 + (int)(2.0f / scale), 5569788);
                Objects.requireNonNull(renderer);
                context.method_25303(renderer, "Perfect: " + perfectGemCount, 2, yPos += 9 + (int)(2.0f / scale), 16753920);
                Objects.requireNonNull(renderer);
                context.method_25303(renderer, "Max: " + maxGemCount, 2, yPos += 9 + (int)(2.0f / scale), 0x800080);
            }
        } else if (this.isInTrackedDimension()) {
            for (String tier : TIERS) {
                context.method_25303(renderer, tier + ": " + chestCounts.get(tier), 2, yPos, tierColors.getOrDefault(tier, 0xFFFFFF).intValue());
                Objects.requireNonNull(renderer);
                yPos += 9 + (int)(2.0f / scale);
            }
        }
        context.method_51448().method_22909();
    }

    private boolean isHoldingFishingRod() {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return false;
        }
        class_746 player = client.field_1724;
        class_1799 mainHand = player.method_6047();
        class_1799 offHand = player.method_6079();
        return mainHand.method_7909() instanceof class_1787 || offHand.method_7909() instanceof class_1787;
    }

    private boolean isHoldingPickaxe() {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return false;
        }
        class_1799 heldItem = client.field_1724.method_6047();
        String itemName = heldItem.method_7909().toString().toLowerCase();
        return itemName.contains("pickaxe");
    }

    private boolean isInTrackedDimension() {
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null) {
            return false;
        }
        String dimension = client.field_1687.method_27983().method_29177().toString();
        return dimension.contains("minecraft:adventure") || dimension.contains("minecraft:the_end");
    }

    private boolean isInSkyblockWorld() {
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null) {
            return false;
        }
        String dimension = client.field_1687.method_27983().method_29177().toString();
        return dimension.contains("skyblock_world") || dimension.contains("minecraft:the_nether");
    }

    private void handleTimerToggle() {
        if (isTimerRunning) {
            this.pauseTimer();
        } else {
            this.startTimer();
        }
        this.sendClientMessage("Timer " + (isTimerRunning ? "started" : "paused"));
    }

    private void startTimer() {
        if (!isTimerRunning) {
            startTime = System.currentTimeMillis() - pausedTime;
            isTimerRunning = true;
        }
    }

    private void pauseTimer() {
        if (isTimerRunning) {
            pausedTime = System.currentTimeMillis() - startTime;
            isTimerRunning = false;
        }
    }

    private void resetTimer() {
        startTime = 0L;
        pausedTime = 0L;
        isTimerRunning = false;
    }

    private String getElapsedTime() {
        long elapsedMillis = isTimerRunning ? System.currentTimeMillis() - startTime : pausedTime;
        long seconds = elapsedMillis / 1000L;
        return String.format("%02d:%02d:%02d", seconds / 3600L % 24L, seconds / 60L % 60L, seconds % 60L);
    }

    private void resetAllCounts() {
        mythicCount = 0;
        godlyCount = 0;
        heroicCount = 0;
        artifactCount = 0;
        sunkenGemsCount = 0;
        skullCount = 0;
        for (String tier : TIERS) {
            chestCounts.put(tier, 0);
            questCounts.put(tier, 0);
        }
        for (String tier : SYS_TIERS) {
            sysChestCounts.put(tier, 0);
        }
        maxGemCount = 0;
        minorGemCount = 0;
        majorGemCount = 0;
        perfectGemCount = 0;
        for (String source : GEM_SOURCES) {
            for (String type : GEM_TYPES) {
                gemSourceCounts.get(source).put(type, 0);
            }
        }
    }

    private void toggleHudVisibility() {
        hudVisible = !hudVisible;
        this.sendClientMessage("HUD " + (hudVisible ? "enabled" : "disabled"));
    }

    private void sendClientMessage(String message) {
        if (class_310.method_1551().field_1724 != null) {
            class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)message), false);
        }
    }

    private void playSound(class_310 client, class_3414 sound) {
        if (client.field_1724 != null) {
            client.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)sound, (float)1.0f, (float)1.0f));
        }
    }

    private void saveHudPosition() {
        try {
            class_2487 nbt = new class_2487();
            nbt.method_10569("hudX", ChestTrackerMod.hudContainer.x);
            nbt.method_10569("hudY", ChestTrackerMod.hudContainer.y);
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            class_2507.method_10630((class_2487)nbt, (Path)CONFIG_PATH);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void loadHudPosition() {
        try {
            if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                class_2487 nbt = class_2507.method_10633((Path)CONFIG_PATH);
                ChestTrackerMod.hudContainer.x = nbt.method_10550("hudX");
                ChestTrackerMod.hudContainer.y = nbt.method_10550("hudY");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

