/*
 * Decompiled with CFR 0.152.
 */
package chat.cosmic.client.client;

import chat.cosmic.client.client.KeyBinds.KeyBinds;
import chat.cosmic.client.client.SettingsManager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3966;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_7833;

@Environment(value=EnvType.CLIENT)
public class DamageDisplayMod
implements ModInitializer {
    public static final List<DamageEntry> DAMAGE_ENTRIES = new ArrayList<DamageEntry>();
    private static final Random RANDOM = new Random();
    private static final Map<UUID, Float> ENTITY_LAST_HEALTH = new HashMap<UUID, Float>();
    private static final Path CONFIG_PATH = Paths.get("config", "damage_display.properties");
    private static int tickCounter = 0;
    private static final int HEALTH_CHECK_INTERVAL = 1;
    public static boolean enabled = true;
    private static UUID lastHitEntityId = null;
    private static long lastHitTime = 0L;
    private static final long HIT_DETECTION_WINDOW = 250L;
    private static boolean wasCriticalHit = false;
    private static final float TEXT_SCALE = 0.035f;
    private static final float FLOAT_SPEED = 0.7f;
    private static final long DISPLAY_DURATION = 1500L;
    private static final float HORIZONTAL_SPREAD = 0.6f;
    private static final float VERTICAL_SPREAD = 0.6f;
    private static final float DEPTH_SPREAD = 0.6f;
    private static final float FRONT_OFFSET = 1.2f;
    private static final float SCALE_FACTOR_PER_ENTRY = 0.5f;

    public void onInitialize() {
        this.loadConfig();
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (KeyBinds.getToggleDamageDisplay().method_1436()) {
                enabled = !enabled;
                SettingsManager.getToggleSettings().put("Damage Intercaters", enabled);
                SettingsManager.saveSettings();
                if (client.field_1724 != null) {
                    client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("Damage Intercaters: " + (enabled ? "ON" : "OFF"))), true);
                }
            }
            if (enabled) {
                this.checkAttackAndEntityHealth(client);
            }
        });
        WorldRenderEvents.AFTER_ENTITIES.register(this::renderDamageNumbers);
    }

    private void loadConfig() {
        try {
            if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                Properties props = new Properties();
                props.load(Files.newInputStream(CONFIG_PATH, new OpenOption[0]));
                enabled = Boolean.parseBoolean(props.getProperty("enabled", "true"));
            }
            enabled = SettingsManager.getToggleSettings().getOrDefault("Damage Intercaters", true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void saveConfig() {
        try {
            Properties props = new Properties();
            props.setProperty("enabled", String.valueOf(enabled));
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            props.store(Files.newOutputStream(CONFIG_PATH, new OpenOption[0]), "Damage Display Mod Configuration");
            SettingsManager.getToggleSettings().put("Damage Intercaters", enabled);
            SettingsManager.saveSettings();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void checkAttackAndEntityHealth(class_310 client) {
        class_3966 hitResult;
        class_1297 hitEntity;
        Object object;
        if (client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        ++tickCounter;
        boolean attacking = client.field_1690.field_1886.method_1434();
        if (attacking && (object = client.field_1765) instanceof class_3966 && (hitEntity = (hitResult = (class_3966)object).method_17782()) instanceof class_1309) {
            class_1309 class_13092 = (class_1309)hitEntity;
            lastHitEntityId = class_13092.method_5667();
            lastHitTime = System.currentTimeMillis();
            boolean bl = wasCriticalHit = client.field_1724.field_6017 > 0.0f && !client.field_1724.method_24828() && !client.field_1724.method_6101() && !client.field_1724.method_5799() && !client.field_1724.method_6059(class_1294.field_5919) && !client.field_1724.method_3144();
            if (!ENTITY_LAST_HEALTH.containsKey(lastHitEntityId)) {
                ENTITY_LAST_HEALTH.put(lastHitEntityId, Float.valueOf(class_13092.method_6032()));
            }
        }
        if (tickCounter % 1 == 0) {
            ArrayList<UUID> keysToRemove = new ArrayList<UUID>();
            for (Map.Entry entry : ENTITY_LAST_HEALTH.entrySet()) {
                UUID entityId = (UUID)entry.getKey();
                float lastKnownHealth = ((Float)entry.getValue()).floatValue();
                client.field_1687.method_8390(class_1309.class, client.field_1724.method_5829().method_1014(20.0), e -> e.method_5667().equals(entityId)).stream().findFirst().ifPresent(livingEntity -> {
                    float currentHealth = livingEntity.method_6032();
                    if (currentHealth < lastKnownHealth) {
                        float damageDealt = lastKnownHealth - currentHealth;
                        if (damageDealt > 0.0f) {
                            long currentTime = System.currentTimeMillis();
                            boolean isRecentHit = entityId.equals(lastHitEntityId) && currentTime - lastHitTime < 250L;
                            double distanceToPlayer = livingEntity.method_5858((class_1297)client.field_1724);
                            boolean isPlayerNearby = distanceToPlayer < 36.0;
                            boolean isPlayer = livingEntity instanceof class_1657;
                            if ((isRecentHit || isPlayerNearby) && livingEntity != client.field_1724) {
                                boolean isCrit = isRecentHit && wasCriticalHit;
                                DAMAGE_ENTRIES.add(new DamageEntry((class_1309)livingEntity, damageDealt, client.field_1724.method_19538(), isCrit, false, isPlayer));
                            }
                        }
                        ENTITY_LAST_HEALTH.put(entityId, Float.valueOf(currentHealth));
                    } else if (currentHealth > lastKnownHealth) {
                        float healingAmount = currentHealth - lastKnownHealth;
                        long currentTime = System.currentTimeMillis();
                        boolean isRecentHit = entityId.equals(lastHitEntityId) && currentTime - lastHitTime < 250L;
                        double distanceToPlayer = livingEntity.method_5858((class_1297)client.field_1724);
                        boolean isPlayerNearby = distanceToPlayer < 36.0;
                        boolean isPlayer = livingEntity instanceof class_1657;
                        if (healingAmount > 0.0f && (isRecentHit || isPlayerNearby) && livingEntity != client.field_1724) {
                            DAMAGE_ENTRIES.add(new DamageEntry((class_1309)livingEntity, healingAmount, client.field_1724.method_19538(), false, true, isPlayer));
                        }
                        ENTITY_LAST_HEALTH.put(entityId, Float.valueOf(currentHealth));
                    }
                });
                if (System.currentTimeMillis() - lastHitTime <= 5000L || entityId.equals(lastHitEntityId)) continue;
                keysToRemove.add(entityId);
            }
            for (UUID uUID : keysToRemove) {
                ENTITY_LAST_HEALTH.remove(uUID);
            }
            client.field_1687.method_8390(class_1309.class, client.field_1724.method_5829().method_1014(20.0), e -> e instanceof class_1309 && !ENTITY_LAST_HEALTH.containsKey(e.method_5667())).forEach(entity -> ENTITY_LAST_HEALTH.put(entity.method_5667(), Float.valueOf(entity.method_6032())));
        }
        wasCriticalHit = false;
    }

    private void renderDamageNumbers(WorldRenderContext context) {
        if (!enabled) {
            return;
        }
        DAMAGE_ENTRIES.removeIf(DamageEntry::isExpired);
        for (DamageEntry entry : DAMAGE_ENTRIES) {
            this.renderFloatingDamage(context, entry);
        }
    }

    private void renderFloatingDamage(WorldRenderContext context, DamageEntry entry) {
        class_310 client = class_310.method_1551();
        class_4587 matrices = context.matrixStack();
        class_4184 camera = context.camera();
        float amount = entry.getAmount();
        if (amount <= 0.0f) {
            return;
        }
        matrices.method_22903();
        class_243 camPos = camera.method_19326();
        class_243 entityPos = entry.getCurrentEntityPos();
        double distanceToEntity = entityPos.method_1022(camPos);
        float elapsedTimeSeconds = (float)(System.currentTimeMillis() - entry.getCreatedTime()) / 1000.0f;
        float verticalMovement = this.calculateVerticalMovement(elapsedTimeSeconds);
        class_243 cameraForward = class_243.method_1030((float)camera.method_19329(), (float)camera.method_19330());
        class_243 offset = new class_243((double)(entry.getHorizontalOffset() * 0.6f), (double)(entry.getVerticalOffset() * 0.6f), (double)(entry.getDepthOffset() * 0.6f));
        float dynamicFrontOffset = 1.2f * (float)Math.max(1.0, distanceToEntity * 0.3);
        class_243 textPos = entityPos.method_1031(cameraForward.field_1352 * (double)dynamicFrontOffset + offset.field_1352, (double)(entry.getEntityHeight() * 0.5f) + offset.field_1351 + (double)verticalMovement, cameraForward.field_1350 * (double)dynamicFrontOffset + offset.field_1350);
        matrices.method_22904(textPos.field_1352 - camPos.field_1352, textPos.field_1351 - camPos.field_1351, textPos.field_1350 - camPos.field_1350);
        matrices.method_22907(class_7833.field_40716.rotationDegrees(-camera.method_19330()));
        matrices.method_22907(class_7833.field_40714.rotationDegrees(camera.method_19329()));
        float scale = 0.035f * (float)(1.0 + 1.0 / (distanceToEntity + 1.0));
        scale = Math.min(scale, 0.065f);
        List sameEntityEntries = DAMAGE_ENTRIES.stream().filter(e -> e.entityUUID.equals(entry.entityUUID) && !e.isExpired()).sorted((e1, e2) -> Long.compare(e2.createdTime, e1.createdTime)).collect(Collectors.toList());
        int entryIndex = sameEntityEntries.indexOf(entry);
        float orderScale = (float)Math.pow(0.5, entryIndex);
        scale *= orderScale;
        float animationProgress = elapsedTimeSeconds / 1.5f;
        if (animationProgress < 0.2f) {
            scale *= 0.8f + animationProgress;
        } else if (animationProgress > 0.7f) {
            scale *= 1.0f - (animationProgress - 0.7f) * 0.7f;
        }
        matrices.method_22905(-scale, -scale, scale);
        class_327 textRenderer = client.field_1772;
        String text = entry.isHealing() ? String.format("+%d \u2764", Math.round(amount)) : String.format("-%d \u2764", Math.round(amount));
        int colorWithAlpha = this.getTextColor(entry, animationProgress);
        class_5250 class_52502 = class_2561.method_43470((String)text);
        float f = -textRenderer.method_1727(text) / 2;
        Objects.requireNonNull(textRenderer);
        textRenderer.method_30882((class_2561)class_52502, f, (float)(-9 / 2), colorWithAlpha, true, matrices.method_23760().method_23761(), context.consumers(), class_327.class_6415.field_33994, 0, 0xF000F0);
        matrices.method_22909();
    }

    private float calculateVerticalMovement(float elapsedTime) {
        if (elapsedTime < 0.2f) {
            return elapsedTime * 2.5f;
        }
        return 0.5f - (elapsedTime - 0.2f) * 0.4f;
    }

    private int getTextColor(DamageEntry entry, float progress) {
        int color = entry.isHealing() ? -16711936 : (entry.isPlayer() ? -65536 : -1);
        int alpha = (int)(255.0f * (1.0f - Math.max(0.0f, (progress - 0.7f) / 0.3f)));
        return color & 0xFFFFFF | alpha << 24;
    }

    @Environment(value=EnvType.CLIENT)
    private static class DamageEntry {
        private final UUID entityUUID;
        private class_243 entityPos;
        private final float entityHeight;
        private final float entityWidth;
        private final long createdTime;
        private final float amount;
        private final float horizontalOffset;
        private final float verticalOffset;
        private final float depthOffset;
        private final boolean isCritical;
        private final boolean isHealing;
        private final boolean isPlayer;
        public final class_243 attackPos;

        public DamageEntry(class_1309 entity, float amount, class_243 attackPos, boolean isCritical, boolean isHealing, boolean isPlayer) {
            this.entityUUID = entity.method_5667();
            this.entityPos = entity.method_19538();
            this.entityHeight = entity.method_17682();
            this.entityWidth = entity.method_17681();
            this.attackPos = attackPos;
            this.createdTime = System.currentTimeMillis();
            this.amount = amount;
            this.isCritical = isCritical;
            this.isHealing = isHealing;
            this.isPlayer = isPlayer;
            this.horizontalOffset = RANDOM.nextFloat() * 2.0f - 1.0f;
            this.verticalOffset = RANDOM.nextFloat() * 2.0f - 1.0f;
            this.depthOffset = RANDOM.nextFloat() * 2.0f - 1.0f;
        }

        public long getCreatedTime() {
            return this.createdTime;
        }

        public float getAmount() {
            return this.amount;
        }

        public float getHorizontalOffset() {
            return this.horizontalOffset;
        }

        public float getVerticalOffset() {
            return this.verticalOffset;
        }

        public float getDepthOffset() {
            return this.depthOffset;
        }

        public boolean isCritical() {
            return this.isCritical;
        }

        public boolean isHealing() {
            return this.isHealing;
        }

        public boolean isPlayer() {
            return this.isPlayer;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.createdTime > 1500L;
        }

        public class_243 getCurrentEntityPos() {
            class_1309 entity;
            class_310 client = class_310.method_1551();
            if (client.field_1687 != null && (entity = (class_1309)client.field_1687.method_8390(class_1309.class, new class_238(this.entityPos.field_1352 - 10.0, this.entityPos.field_1351 - 10.0, this.entityPos.field_1350 - 10.0, this.entityPos.field_1352 + 10.0, this.entityPos.field_1351 + 10.0, this.entityPos.field_1350 + 10.0), e -> e.method_5667().equals(this.entityUUID)).stream().findFirst().orElse(null)) != null) {
                this.entityPos = entity.method_19538();
            }
            return this.entityPos;
        }

        public float getEntityHeight() {
            return this.entityHeight;
        }

        public float getEntityWidth() {
            return this.entityWidth;
        }
    }
}

