/*
 * Decompiled with CFR 0.152.
 */
package chat.cosmic.client.client;

import chat.cosmic.client.client.KeyBinds.KeyBinds;
import chat.cosmic.client.client.SettingsManager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;

@Environment(value=EnvType.CLIENT)
public class HighlightSearchMod
implements ClientModInitializer {
    public static boolean isSearchVisible = true;
    private static final Path CONFIG_PATH = Paths.get("config", "highlight_search.properties");

    public void onInitializeClient() {
        this.loadConfig();
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (KeyBinds.getToggleSearch().method_1436()) {
                isSearchVisible = !isSearchVisible;
                SettingsManager.getToggleSettings().put("Search Bar", isSearchVisible);
                SettingsManager.saveSettings();
                this.saveConfig();
            }
        });
    }

    private void loadConfig() {
        try {
            if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                Properties props = new Properties();
                props.load(Files.newInputStream(CONFIG_PATH, new OpenOption[0]));
                isSearchVisible = Boolean.parseBoolean(props.getProperty("visible", "true"));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveConfig() {
        try {
            Properties props = new Properties();
            props.setProperty("visible", String.valueOf(isSearchVisible));
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            props.store(Files.newOutputStream(CONFIG_PATH, new OpenOption[0]), "Highlight Search Mod Configuration");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

