/*
 * Decompiled with CFR 0.152.
 */
package chat.cosmic.client.client;

import chat.cosmic.client.client.KeyBinds.KeyBinds;
import chat.cosmic.client.client.SettingsManager;
import chat.cosmic.client.client.UniversalGuiMover;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1787;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_746;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class MythicTrackerMod
implements ClientModInitializer {
    private static int mythicCount = 0;
    private static int godlyCount = 0;
    private static int heroicCount = 0;
    private static int ArtifactfoundCount = 0;
    private static int SUNKENGEMSCount = 0;
    private static int skullCount = 0;
    public static boolean isHudVisible = true;
    private static boolean wasToggleKeyPressed = false;
    private static final String CONFIG_FILE = "config/mythictracker.properties";
    public static final class_2960 MYTHIC_SOUND_ID = new class_2960("mythictracker", "mythic_sound");
    public static final class_2960 GODLY_SOUND_ID = new class_2960("mythictracker", "godly_sound");
    public static final class_2960 HEROIC_SOUND_ID = new class_2960("mythictracker", "heroic_sound");
    public static class_3414 MYTHIC_SOUND = class_3414.method_47908((class_2960)MYTHIC_SOUND_ID);
    public static class_3414 GODLY_SOUND = class_3414.method_47908((class_2960)GODLY_SOUND_ID);
    public static class_3414 HEROIC_SOUND = class_3414.method_47908((class_2960)HEROIC_SOUND_ID);

    public void onInitializeClient() {
        this.loadConfig();
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)MYTHIC_SOUND_ID, (Object)MYTHIC_SOUND);
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)GODLY_SOUND_ID, (Object)GODLY_SOUND);
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)HEROIC_SOUND_ID, (Object)HEROIC_SOUND);
        UniversalGuiMover.HudContainer hudContainer = new UniversalGuiMover.HudContainer(10, 10, 50, 12, 7);
        UniversalGuiMover.trackHudContainer("mythicTrackerHud", hudContainer);
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"fish").then(ClientCommandManager.literal((String)"reset").executes(context -> {
            mythicCount = 0;
            godlyCount = 0;
            heroicCount = 0;
            ArtifactfoundCount = 0;
            skullCount = 0;
            class_310 client = class_310.method_1551();
            if (client.field_1724 != null) {
                client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7aAll fishing counters have been reset!"), false);
            }
            return 1;
        }))));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            boolean isTogglePressed = KeyBinds.getToggleFishingHud().method_1434();
            if (isTogglePressed && !wasToggleKeyPressed) {
                isHudVisible = !isHudVisible;
                SettingsManager.getToggleSettings().put("Mythic Fishing HUD", isHudVisible);
                SettingsManager.saveSettings();
                this.saveConfig();
            }
            wasToggleKeyPressed = isTogglePressed;
        });
        ClientReceiveMessageEvents.GAME.register((message, overlay) -> {
            boolean isServerMessage;
            String msg = message.getString();
            class_310 client = class_310.method_1551();
            boolean isPlayerMessage = msg.contains("->") || msg.matches(".*\\[.*\\].*");
            boolean bl = isServerMessage = !isPlayerMessage;
            if (isServerMessage || overlay) {
                if (msg.contains("Mythic Treasure")) {
                    ++mythicCount;
                    this.playSound(client, MYTHIC_SOUND);
                } else if (msg.contains("Godly Treasure")) {
                    ++godlyCount;
                    this.playSound(client, GODLY_SOUND);
                } else if (msg.contains("Heroic Treasure")) {
                    ++heroicCount;
                    this.playSound(client, HEROIC_SOUND);
                } else if (msg.toUpperCase().contains("ARTIFACT FOUND:")) {
                    ++ArtifactfoundCount;
                    this.playSound(client, HEROIC_SOUND);
                } else if (msg.toUpperCase().contains("* SUNKEN GEMS")) {
                    ++SUNKENGEMSCount;
                    this.playSound(client, HEROIC_SOUND);
                } else if (msg.startsWith("+") && msg.contains("Marauder Skull")) {
                    String[] parts = msg.split(" ");
                    try {
                        String numberPart = parts[0].replace("+", "").trim();
                        int amount = Integer.parseInt(numberPart);
                        skullCount += amount;
                        this.playSound(client, HEROIC_SOUND);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("Failed to parse skull amount from: " + msg);
                    }
                }
            }
        });
        HudRenderCallback.EVENT.register((context, delta) -> {
            if (isHudVisible && this.isHoldingFishingRod()) {
                this.drawHud(context);
            }
        });
    }

    private boolean isHoldingFishingRod() {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return false;
        }
        class_746 player = client.field_1724;
        class_1799 mainHand = player.method_6047();
        class_1799 offHand = player.method_6079();
        return mainHand.method_7909() instanceof class_1787 || offHand.method_7909() instanceof class_1787;
    }

    private void loadConfig() {
        File configFile = new File(CONFIG_FILE);
        if (configFile.exists()) {
            try (FileInputStream input = new FileInputStream(CONFIG_FILE);){
                Properties prop = new Properties();
                prop.load(input);
                isHudVisible = Boolean.parseBoolean(prop.getProperty("hudVisible", "true"));
            }
            catch (IOException ex) {
                System.err.println("Could not load config: " + ex.getMessage());
            }
        }
    }

    private void saveConfig() {
        try {
            new File(CONFIG_FILE).getParentFile().mkdirs();
            try (FileOutputStream output = new FileOutputStream(CONFIG_FILE);){
                Properties prop = new Properties();
                prop.setProperty("hudVisible", Boolean.toString(isHudVisible));
                prop.store(output, "Mythic Tracker Config");
            }
        }
        catch (IOException ex) {
            System.err.println("Could not save config: " + ex.getMessage());
        }
    }

    private void drawHud(class_332 context) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        UniversalGuiMover.HudContainer container = UniversalGuiMover.getHudContainer("mythicTrackerHud");
        if (container == null) {
            return;
        }
        float scale = UniversalGuiMover.getGlobalTextScale();
        int scaledX = container.x;
        int scaledY = container.y;
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)scaledX, (float)scaledY, 0.0f);
        context.method_51448().method_22905(scale, scale, 1.0f);
        context.method_51439(client.field_1772, (class_2561)class_2561.method_43470((String)"\u00a7bFishing Tracker"), 2, 2, 0xFFFFFF, true);
        context.method_51439(client.field_1772, (class_2561)class_2561.method_43470((String)("\u00a7cGodly: " + godlyCount)), 2, 14, 0xFFFFFF, true);
        context.method_51439(client.field_1772, (class_2561)class_2561.method_43470((String)("\u00a7dHeroic: " + heroicCount)), 2, 26, 0xFFFFFF, true);
        context.method_51439(client.field_1772, (class_2561)class_2561.method_43470((String)("\u00a75Mythic: " + mythicCount)), 2, 38, 0xFFFFFF, true);
        context.method_51439(client.field_1772, (class_2561)class_2561.method_43470((String)("\u00a7bArtifact found: " + ArtifactfoundCount)), 2, 50, 0xFFFFFF, true);
        context.method_51439(client.field_1772, (class_2561)class_2561.method_43470((String)("\u00a76SUNKEN GEMS: " + SUNKENGEMSCount)), 2, 62, 0xFFFFFF, true);
        context.method_51439(client.field_1772, (class_2561)class_2561.method_43470((String)("\u00a76Skulls: " + skullCount)), 2, 74, 0xFFFFFF, true);
        context.method_51448().method_22909();
    }

    private void playSound(class_310 client, class_3414 sound) {
        if (client.field_1724 != null) {
            client.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)sound, (float)1.0f, (float)1.0f));
        }
    }
}

