/*
 * Decompiled with CFR 0.152.
 */
package chat.cosmic.client.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;

@Environment(value=EnvType.CLIENT)
public class NameTagSystem
implements ClientModInitializer {
    private static final String CONFIG_FILE = "cosmic-client-nametags.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static NameTagSystem INSTANCE;
    public final Map<String, Boolean> tierVisibility = new HashMap<String, Boolean>();
    public final Map<String, Boolean> glowVisibility = new HashMap<String, Boolean>();

    public NameTagSystem() {
        String[] glowTiers;
        String[] tiers;
        for (String tier : tiers = new String[]{"basic", "elite", "legendary", "godly", "mythic", "heroic"}) {
            String key = tier + "_marauder";
            this.tierVisibility.put(key, true);
        }
        for (String tier : glowTiers = new String[]{"legendary", "godly", "mythic", "heroic"}) {
            String key = tier + "_marauder";
            this.glowVisibility.put(key, true);
        }
    }

    public void onInitializeClient() {
        INSTANCE = this;
        this.load();
        this.registerCommands();
    }

    public boolean shouldShowNameTag(String mobName) {
        String lowerName = mobName.toLowerCase();
        for (Map.Entry<String, Boolean> entry : this.tierVisibility.entrySet()) {
            String tier = entry.getKey().replace("_", " ");
            if (!lowerName.contains(tier) || entry.getValue().booleanValue()) continue;
            return false;
        }
        return true;
    }

    public boolean shouldGlow(String mobName) {
        String lowerName = mobName.toLowerCase();
        if (lowerName.contains("basic") || lowerName.contains("elite")) {
            return false;
        }
        for (Map.Entry<String, Boolean> entry : this.glowVisibility.entrySet()) {
            String tier = entry.getKey().replace("_", " ");
            if (!lowerName.contains(tier) || entry.getValue().booleanValue()) continue;
            return false;
        }
        return true;
    }

    public void toggleTier(String tier) {
        String key = tier.toLowerCase().replace(" ", "_");
        if (this.tierVisibility.containsKey(key)) {
            this.tierVisibility.put(key, this.tierVisibility.get(key) == false);
            this.save();
        }
    }

    public void toggleAllTiers(boolean value) {
        this.tierVisibility.replaceAll((k, v) -> value);
        this.save();
    }

    public void toggleGlow(String tier) {
        String key = tier.toLowerCase().replace(" ", "_");
        if (this.glowVisibility.containsKey(key)) {
            this.glowVisibility.put(key, this.glowVisibility.get(key) == false);
            this.save();
        }
    }

    public void toggleAllGlow(boolean value) {
        this.glowVisibility.replaceAll((k, v) -> value);
        this.save();
    }

    public void load() {
        File configFile = FabricLoader.getInstance().getConfigDir().resolve(CONFIG_FILE).toFile();
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                NameTagSystem loaded = (NameTagSystem)GSON.fromJson((Reader)reader, NameTagSystem.class);
                this.tierVisibility.clear();
                this.tierVisibility.putAll(loaded.tierVisibility);
                for (Map.Entry<String, Boolean> entry : loaded.glowVisibility.entrySet()) {
                    String key = entry.getKey();
                    if (!this.glowVisibility.containsKey(key)) continue;
                    this.glowVisibility.put(key, entry.getValue());
                }
            }
            catch (IOException e) {
                System.err.println("Failed to load config: " + e.getMessage());
            }
        } else {
            this.save();
        }
    }

    public void save() {
        File configFile = FabricLoader.getInstance().getConfigDir().resolve(CONFIG_FILE).toFile();
        try (FileWriter writer = new FileWriter(configFile);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            System.err.println("Failed to save config: " + e.getMessage());
        }
    }

    private void registerCommands() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            this.registerNameTagCommands((CommandDispatcher<FabricClientCommandSource>)dispatcher);
            this.registerGlowCommands((CommandDispatcher<FabricClientCommandSource>)dispatcher);
        });
    }

    private void registerNameTagCommands(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        LiteralArgumentBuilder cmd = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"nametag").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"toggle").then(this.createTierNode("basic"))).then(this.createTierNode("elite"))).then(this.createTierNode("legendary"))).then(this.createTierNode("godly"))).then(this.createTierNode("mythic"))).then(this.createTierNode("heroic")))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"all").then(ClientCommandManager.literal((String)"show").executes(ctx -> {
            this.toggleAllTiers(true);
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7aAll name tags are now visible"));
            return 1;
        }))).then(ClientCommandManager.literal((String)"hide").executes(ctx -> {
            this.toggleAllTiers(false);
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7cAll name tags are now hidden"));
            return 1;
        })))).then(ClientCommandManager.literal((String)"status").executes(this::showNameTagStatus));
        dispatcher.register(cmd);
    }

    private void registerGlowCommands(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        LiteralArgumentBuilder cmd = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"glow").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"toggle").then(this.createGlowTierNode("legendary"))).then(this.createGlowTierNode("godly"))).then(this.createGlowTierNode("mythic"))).then(this.createGlowTierNode("heroic")))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"all").then(ClientCommandManager.literal((String)"on").executes(ctx -> {
            this.toggleAllGlow(true);
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7aAll glow effects are now enabled"));
            return 1;
        }))).then(ClientCommandManager.literal((String)"off").executes(ctx -> {
            this.toggleAllGlow(false);
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7cAll glow effects are now disabled"));
            return 1;
        })))).then(ClientCommandManager.literal((String)"status").executes(this::showGlowStatus));
        dispatcher.register(cmd);
    }

    private LiteralArgumentBuilder<FabricClientCommandSource> createTierNode(String tier) {
        return (LiteralArgumentBuilder)ClientCommandManager.literal((String)tier).executes(ctx -> {
            this.toggleTier(tier + "_marauder");
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7a" + this.capitalize(tier) + " name tags: " + (this.tierVisibility.get(tier + "_marauder") != false ? "\u00a7aON" : "\u00a7cOFF"))));
            return 1;
        });
    }

    private LiteralArgumentBuilder<FabricClientCommandSource> createGlowTierNode(String tier) {
        return (LiteralArgumentBuilder)ClientCommandManager.literal((String)tier).executes(ctx -> {
            this.toggleGlow(tier + "_marauder");
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7b" + this.capitalize(tier) + " glow: " + (this.glowVisibility.get(tier + "_marauder") != false ? "\u00a7aON" : "\u00a7cOFF"))));
            return 1;
        });
    }

    private int showNameTagStatus(CommandContext<FabricClientCommandSource> ctx) {
        ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a76=== NameTags ==="));
        this.tierVisibility.forEach((k, v) -> ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("  \u00a77- " + this.capitalize(k.replace("_", " ")) + ": " + (v != false ? "\u00a7aSHOWN" : "\u00a7cHIDDEN")))));
        return 1;
    }

    private int showGlowStatus(CommandContext<FabricClientCommandSource> ctx) {
        ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a76=== Glow ==="));
        this.glowVisibility.forEach((k, v) -> ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("  \u00a77- " + this.capitalize(k.replace("_", " ")) + ": " + (v != false ? "\u00a7aON" : "\u00a7cOFF")))));
        return 1;
    }

    private String capitalize(String text) {
        return text.substring(0, 1).toUpperCase() + text.substring(1).toLowerCase();
    }

    public static NameTagSystem getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new NameTagSystem();
        }
        return INSTANCE;
    }
}

