/*
 * Decompiled with CFR 0.152.
 */
package chat.cosmic.client.client;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashMap;
import java.util.UUID;
import java.util.prefs.Preferences;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_310;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class RankManager {
    private static final HashMap<UUID, String> playerRanks = new HashMap();
    private static final String DEFAULT_RANK = "Default";
    private static final Preferences prefs = Preferences.userNodeForPackage(RankManager.class);
    private static int reminderTimer = 0;
    private static boolean reminderSent = false;

    public static void initialize() {
        RankManager.loadSavedRanks();
        RankManager.registerSetRankCommand();
        RankManager.setupReminderSystem();
    }

    private static void setupReminderSystem() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1724 == null) {
                return;
            }
            if (!reminderSent && client.field_1724.field_6012 > 100 && RankManager.getCurrentRank().equals(DEFAULT_RANK)) {
                RankManager.sendRankReminder();
                reminderSent = true;
            }
        });
    }

    private static void sendRankReminder() {
        String[] ranks;
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        class_5250 message = class_2561.method_43470((String)"\n[Cooldown Mod] ").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)"Set your rank so the cooldown mod will work for you rank :\n").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"Available ranks:\n").method_27692(class_124.field_1080));
        for (String rank : ranks = new String[]{"Non-Rank", "Comet", "Titan", "Galactic", "Celestial"}) {
            message.method_10852(RankManager.createClickableRank(rank)).method_10852((class_2561)class_2561.method_43470((String)"\n"));
        }
        message.method_10852((class_2561)class_2561.method_43470((String)"\nNon-Rank = No command access").method_27692(class_124.field_1061));
        client.field_1724.method_7353((class_2561)message, false);
    }

    private static class_2561 createClickableRank(String rank) {
        String commandRank = rank.equals("Non-Rank") ? DEFAULT_RANK : rank;
        return class_2561.method_43470((String)("-> " + rank)).method_27694(style -> style.method_10977(rank.equals("Non-Rank") ? class_124.field_1061 : class_124.field_1060).method_10958(new class_2558(class_2558.class_2559.field_11745, "/setrank " + commandRank)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)("Click to set " + rank + (String)(rank.equals("Non-Rank") ? "\n(Blocks all commands)" : "\nCooldowns: " + RankManager.getRankDescription(rank)))))));
    }

    private static String getRankDescription(String rank) {
        return switch (rank) {
            case "Comet" -> "/fix: 10m";
            case "Titan" -> "/fix: 5m, /feed/eat/heal: 10m";
            case "Galactic" -> "/fix & /fix all: 2m, /near: 30s, /feed/eat/heal: 5m";
            case "Celestial" -> "/fix & /fix all: 90s, /near: 30s, /feed/eat/heal: 3m, /mule: 20m";
            default -> "";
        };
    }

    private static void loadSavedRanks() {
        try {
            for (String key : prefs.keys()) {
                UUID uuid = UUID.fromString(key);
                String rank = prefs.get(key, DEFAULT_RANK);
                playerRanks.put(uuid, rank);
            }
        }
        catch (Exception e) {
            System.err.println("Error loading saved ranks: " + e.getMessage());
        }
    }

    private static void registerSetRankCommand() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"setrank").then(ClientCommandManager.argument((String)"rank", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            builder.suggest(DEFAULT_RANK);
            builder.suggest("Comet");
            builder.suggest("Titan");
            builder.suggest("Galactic");
            builder.suggest("Celestial");
            return builder.buildFuture();
        }).executes(context -> {
            String rank = StringArgumentType.getString((CommandContext)context, (String)"rank");
            UUID playerId = class_310.method_1551().field_1724.method_5667();
            RankManager.setPlayerRank(playerId, rank);
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Set rank to: " + RankManager.getCurrentRankDisplay())));
            reminderSent = true;
            return 1;
        }))));
    }

    private static void setPlayerRank(UUID playerId, String rank) {
        playerRanks.put(playerId, rank);
        prefs.put(playerId.toString(), rank);
        try {
            prefs.flush();
        }
        catch (Exception e) {
            System.err.println("Failed to save rank: " + e.getMessage());
        }
    }

    public static int getCooldown(String command) {
        if (RankManager.getCurrentRankDisplay().equals("Non-Rank")) {
            return -1;
        }
        String[] parts = command.toLowerCase().split(" ");
        String baseCommand = parts[0];
        boolean isFixAll = command.equalsIgnoreCase("fix all");
        String rank = RankManager.getCurrentRank();
        if (baseCommand.equals("feed") || baseCommand.equals("eat") || baseCommand.equals("heal")) {
            baseCommand = "feed";
        }
        if (isFixAll && !rank.equals("Galactic") && !rank.equals("Celestial")) {
            return -1;
        }
        if (baseCommand.equals("fix")) {
            return switch (rank) {
                case "Galactic" -> 120;
                case "Celestial" -> 90;
                case "Comet" -> 600;
                case "Titan" -> 300;
                default -> -1;
            };
        }
        if (baseCommand.equals("mule")) {
            return rank.equals("Celestial") ? 1200 : -1;
        }
        return switch (rank) {
            case "Galactic" -> RankManager.getGalacticCooldown(baseCommand);
            case "Celestial" -> RankManager.getCelestialCooldown(baseCommand);
            case "Titan" -> RankManager.getTitanCooldown(baseCommand);
            default -> -1;
        };
    }

    private static int getGalacticCooldown(String command) {
        return switch (command) {
            case "near" -> 30;
            case "feed" -> 300;
            default -> -1;
        };
    }

    private static int getCelestialCooldown(String command) {
        return switch (command) {
            case "near" -> 30;
            case "feed" -> 180;
            default -> -1;
        };
    }

    private static int getTitanCooldown(String command) {
        return switch (command) {
            case "feed" -> 600;
            default -> -1;
        };
    }

    private static String getCurrentRank() {
        UUID playerId = class_310.method_1551().field_1724.method_5667();
        return playerRanks.getOrDefault(playerId, DEFAULT_RANK);
    }

    public static String getCurrentRankDisplay() {
        String rank = RankManager.getCurrentRank();
        return rank.equals(DEFAULT_RANK) ? "Non-Rank" : rank;
    }

    public static boolean hasMuleAccess() {
        return RankManager.getCurrentRank().equals("Celestial");
    }
}

