/*
 * Decompiled with CFR 0.152.
 */
package chat.cosmic.client.client;

import chat.cosmic.client.client.SettingsManager;
import chat.cosmic.client.client.SettingsRenderer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;

@Environment(value=EnvType.CLIENT)
public class SettingsInputHandler {
    private static boolean wasClickHandled = false;
    private static boolean lastMouseState = false;
    private static String editingKeybind = null;
    private static boolean waitingForKey = false;
    private static long keyPressTime = 0L;
    private static final long KEY_PRESS_DELAY = 150L;

    public static void handleClick(double mouseX, double mouseY, boolean mouseDown) {
        if (!mouseDown) {
            wasClickHandled = false;
            return;
        }
        if (wasClickHandled) {
            return;
        }
        if (SettingsRenderer.isMouseOverSettings(mouseX, mouseY)) {
            wasClickHandled = true;
        }
    }

    public static boolean shouldToggleSettings(double mouseX, double mouseY, boolean mouseDown) {
        boolean overButton;
        if (!mouseDown || wasClickHandled) {
            return false;
        }
        class_1041 window = class_310.method_1551().method_22683();
        int buttonX = window.method_4486() - 65;
        int buttonY = 5;
        int buttonWidth = 60;
        int buttonHeight = 20;
        boolean bl = overButton = mouseX >= (double)buttonX && mouseX <= (double)(buttonX + buttonWidth) && mouseY >= (double)buttonY && mouseY <= (double)(buttonY + buttonHeight);
        if (overButton) {
            wasClickHandled = true;
            return true;
        }
        return false;
    }

    public static void handleKeyPress(int key, int scancode, int action, int modifiers) {
        if (!SettingsManager.isSettingsOpen() || !waitingForKey || editingKeybind == null) {
            return;
        }
        if (action == 1 && System.currentTimeMillis() - keyPressTime > 150L) {
            if (key == 256) {
                SettingsInputHandler.cancelKeybindEditing();
                return;
            }
            class_304 keyBinding = SettingsManager.getKeybindList().get(editingKeybind);
            if (keyBinding != null) {
                keyBinding.method_1422(class_3675.class_307.field_1668.method_1447(key));
                class_304.method_1426();
            }
            SettingsInputHandler.cancelKeybindEditing();
        }
    }

    public static void handleCharInput(char character) {
    }

    public static void startEditingKeybind(String keybindName) {
        editingKeybind = keybindName;
        waitingForKey = true;
        keyPressTime = System.currentTimeMillis();
    }

    public static void cancelKeybindEditing() {
        editingKeybind = null;
        waitingForKey = false;
    }

    public static String getEditingKeybind() {
        return editingKeybind;
    }

    public static boolean isWaitingForKey() {
        return waitingForKey;
    }

    public static boolean getLastMouseState() {
        return lastMouseState;
    }

    public static void setLastMouseState(boolean state) {
        lastMouseState = state;
    }

    public static void saveThresholdsIfEditing() {
    }
}

