/*
 * Decompiled with CFR 0.152.
 */
package chat.cosmic.client.client;

import chat.cosmic.client.client.Amor;
import chat.cosmic.client.client.AnnouncementHiderClient;
import chat.cosmic.client.client.ArmorToggleMod;
import chat.cosmic.client.client.ChestTrackerMod;
import chat.cosmic.client.client.DamageDisplayMod;
import chat.cosmic.client.client.HighlightSearchMod;
import chat.cosmic.client.client.KeyBinds.KeyBinds;
import chat.cosmic.client.client.NameTagSystem;
import chat.cosmic.client.client.SettingsInputHandler;
import chat.cosmic.client.client.SettingsRenderer;
import chat.cosmic.client.client.StatusEffectsTracker;
import chat.cosmic.client.client.TrinketMod;
import chat.cosmic.client.client.XPBoosterMod;
import chat.cosmic.client.join;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_304;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class SettingsManager {
    private static final Path CONFIG_PATH = Paths.get("config", "untitled20_settings.properties");
    private static boolean settingsOpen = false;
    private static boolean initialized = false;
    private static final Map<String, Boolean> toggleSettings = new LinkedHashMap<String, Boolean>();
    private static final Map<String, Float> sliderSettings = new LinkedHashMap<String, Float>();
    private static final Map<String, class_304> keybindList = new LinkedHashMap<String, class_304>();
    private static final List<String> commandHelp = new ArrayList<String>();
    private static final Map<String, Boolean> boosterToggleSettings = new LinkedHashMap<String, Boolean>();
    private static final Map<String, Boolean> mobNameTagSettings = new LinkedHashMap<String, Boolean>();
    private static final Map<String, Boolean> mobGlowSettings = new LinkedHashMap<String, Boolean>();
    private static final Map<String, Boolean> petToggleSettings = new LinkedHashMap<String, Boolean>();
    private static final Map<String, Integer> trinketThresholdSettings = new LinkedHashMap<String, Integer>();
    private static final Map<String, Integer> trinketCriticalSettings = new LinkedHashMap<String, Integer>();
    private static final Map<String, Integer> defaultThresholds = Map.of("Healing", 50, "Speed", 6, "Strength", 6, "Ender", 7);
    private static final Map<String, Integer> defaultCriticalThresholds = Map.of("Healing", 25, "Speed", 4, "Strength", 4, "Ender", 5);

    public static void setMuleHudEnabled(Boolean muleHud) {
    }

    public static void setCombatHudEnabled(Boolean combatHud) {
    }

    public static void initialize() {
        block15: {
            String[] pets;
            String[] mobTiers;
            if (initialized) {
                return;
            }
            SettingsManager.loadSettings();
            if (toggleSettings.containsKey("Damage Numbers")) {
                toggleSettings.put("Damage Intercaters", toggleSettings.get("Damage Numbers"));
                toggleSettings.remove("Damage Numbers");
            }
            if (toggleSettings.containsKey("Highlight Search")) {
                toggleSettings.put("Search Bar", toggleSettings.get("Highlight Search"));
                toggleSettings.remove("Highlight Search");
            }
            if (toggleSettings.containsKey("Hide Announcements")) {
                toggleSettings.put("Hide Quest Announcements", toggleSettings.get("Hide Announcements"));
                toggleSettings.remove("Hide Announcements");
            }
            if (toggleSettings.containsKey("Hide Armor")) {
                toggleSettings.put("Hide Mob Armor", toggleSettings.get("Hide Armor"));
                toggleSettings.remove("Hide Armor");
            }
            SettingsManager.setDefaultIfMissing("Show Notifications", true);
            SettingsManager.setDefaultIfMissing("Show Player List", true);
            SettingsManager.setDefaultIfMissing("XP Booster HUD", true);
            SettingsManager.setDefaultIfMissing("Trinket Display HUD", true);
            SettingsManager.setDefaultIfMissing("Chest Tracker HUD", true);
            SettingsManager.setDefaultIfMissing("Curse HUD", true);
            SettingsManager.setDefaultIfMissing("Chaotic Zone HUD", true);
            SettingsManager.setDefaultIfMissing("Combat HUD", true);
            SettingsManager.setDefaultIfMissing("Mule HUD", true);
            SettingsManager.setDefaultIfMissing("Armor Durability Alerts", true);
            SettingsManager.setDefaultIfMissing("Hide Mob Armor", false);
            SettingsManager.setDefaultIfMissing("Players per Column", 15.0f);
            SettingsManager.setDefaultIfMissing("Damage Intercaters", true);
            SettingsManager.setDefaultIfMissing("Search Bar", true);
            SettingsManager.setDefaultIfMissing("Mythic Fishing HUD", true);
            SettingsManager.setDefaultIfMissing("Hide Quest Announcements", true);
            SettingsManager.setDefaultIfMissing("Pet Active Effects HUD", true);
            SettingsManager.setBoosterDefaultIfMissing("Island Xp Booster", true);
            SettingsManager.setBoosterDefaultIfMissing("Treasure Chance Booster", true);
            SettingsManager.setBoosterDefaultIfMissing("Ender Pearl", true);
            SettingsManager.setBoosterDefaultIfMissing("/feed", true);
            SettingsManager.setBoosterDefaultIfMissing("/heal", true);
            SettingsManager.setBoosterDefaultIfMissing("/fix", true);
            SettingsManager.setBoosterDefaultIfMissing("/near", true);
            for (String tier : mobTiers = new String[]{"basic", "elite", "legendary", "godly", "mythic", "heroic"}) {
                SettingsManager.setDefaultIfMissing("Mob " + tier + " Nametag", true);
                if (tier.equals("basic") || tier.equals("elite")) continue;
                SettingsManager.setDefaultIfMissing("Mob " + tier + " Glow", true);
            }
            for (String pet : pets = new String[]{"Battle Pig Pet", "Miner Matt Pet", "Slayer Sam Pet", "Chaos Cow Pet", "Blacksmith Brandon Pet", "Fisherman Fred Pet", "Alchemist Alex Pet", "Blood Sheep Pet", "Merchant Pet", "Dire Wolf Pet", "Void Chicken Pet", "Loot Llama Pet", "Barry Bee Pet"}) {
                SettingsManager.setPetDefaultIfMissing("Pet " + pet, true);
            }
            keybindList.put("Toggle GUI Movement", KeyBinds.getToggleGUIMovement());
            keybindList.put("Toggle Notifications", KeyBinds.getToggleNotifications());
            keybindList.put("Toggle Player List", KeyBinds.getTogglePlayerList());
            keybindList.put("Scale Up", KeyBinds.getScaleUp());
            keybindList.put("Scale Down", KeyBinds.getScaleDown());
            keybindList.put("Toggle Durability Alerts", KeyBinds.getToggleDurabilityAlerts());
            keybindList.put("Toggle Chest HUD", KeyBinds.Chest_tracker_toggle_hud);
            keybindList.put("Reset Chest Tracker", KeyBinds.Chest_tracker_timer_reset);
            keybindList.put("Start/Pause Chest Timer", KeyBinds.Chest_tracker_start_pause_timer);
            keybindList.put("Toggle Fishing HUD", KeyBinds.getToggleFishingHud());
            keybindList.put("Toggle Search", KeyBinds.getToggleSearch());
            keybindList.put("Toggle Damage Display", KeyBinds.getToggleDamageDisplay());
            keybindList.put("Toggle Armor Visibility", KeyBinds.getToggleArmorVisibility());
            keybindList.put("Toggle Trinket HUD", KeyBinds.trinket_hud_toggle);
            keybindList.put("Open Trophy Tracker", KeyBinds.TrophyTracker_hud);
            commandHelp.add("/pr <name> - Red name");
            commandHelp.add("/pg <name> - Green name");
            commandHelp.add("/pdb <name> - Aqua name");
            commandHelp.add("/pw <name> - Reset color");
            commandHelp.add("/prr - Reset all colors");
            commandHelp.add("/player list ignore <name> - Toggle ignore");
            commandHelp.add("/setmaxplayers <count> - Set max players per column");
            commandHelp.add("/dur <value> - Set durability warning threshold (1-300)");
            commandHelp.add("/dursound <sound> - Set alert sound (or 'reset') does not work for something later on ");
            commandHelp.add("/chestreset - Reset chest counts and gems");
            commandHelp.add("/chesttimer reset - Reset timer to 00:00:00");
            commandHelp.add("/chesttimer start - Start/resume timer");
            commandHelp.add("/chesttimer pause - Pause timer");
            commandHelp.add("/sys - Show System Override stats for 10s");
            commandHelp.add("/fish reset - Reset all fishing counters");
            commandHelp.add("/glow toggle tire");
            SettingsManager.applySettings();
            SettingsManager.saveSettings();
            initialized = true;
            try {
                Path oldConfig = Paths.get(class_310.method_1551().field_1697.getPath(), "config", "armorvisibility.cfg");
                if (!Files.exists(oldConfig, new LinkOption[0])) break block15;
                Properties prop = new Properties();
                try (InputStream is = Files.newInputStream(oldConfig, new OpenOption[0]);){
                    prop.load(is);
                }
                boolean hideArmor = Boolean.parseBoolean(prop.getProperty("hideArmor", "false"));
                toggleSettings.put("Hide Armor", hideArmor);
                Files.delete(oldConfig);
                SettingsManager.applySettings();
                SettingsManager.saveSettings();
            }
            catch (IOException e) {
                System.err.println("Error migrating armor config: " + e.getMessage());
            }
        }
    }

    private static void setDefaultIfMissing(String name, boolean defaultValue) {
        if (!toggleSettings.containsKey(name)) {
            toggleSettings.put(name, defaultValue);
        }
    }

    private static void setDefaultIfMissing(String name, float defaultValue) {
        if (!sliderSettings.containsKey(name)) {
            sliderSettings.put(name, Float.valueOf(defaultValue));
        }
    }

    private static void setBoosterDefaultIfMissing(String name, boolean defaultValue) {
        if (!boosterToggleSettings.containsKey(name)) {
            boosterToggleSettings.put(name, defaultValue);
        }
    }

    private static void setPetDefaultIfMissing(String name, boolean defaultValue) {
        if (!petToggleSettings.containsKey(name)) {
            petToggleSettings.put(name, defaultValue);
        }
    }

    public static void loadSettings() {
        block12: {
            try {
                if (!Files.exists(CONFIG_PATH, new LinkOption[0])) break block12;
                Properties props = new Properties();
                try (InputStream is = Files.newInputStream(CONFIG_PATH, new OpenOption[0]);){
                    props.load(is);
                }
                for (String key : props.stringPropertyNames()) {
                    boolean value;
                    String settingName;
                    if (key.startsWith("toggle_")) {
                        settingName = key.substring(7);
                        value = Boolean.parseBoolean(props.getProperty(key));
                        toggleSettings.put(settingName, value);
                        continue;
                    }
                    if (key.startsWith("slider_")) {
                        settingName = key.substring(7);
                        float value2 = Float.parseFloat(props.getProperty(key));
                        sliderSettings.put(settingName, Float.valueOf(value2));
                        continue;
                    }
                    if (key.startsWith("booster_")) {
                        settingName = key.substring(8);
                        value = Boolean.parseBoolean(props.getProperty(key));
                        boosterToggleSettings.put(settingName, value);
                        continue;
                    }
                    if (!key.startsWith("pet_")) continue;
                    settingName = key.substring(4);
                    value = Boolean.parseBoolean(props.getProperty(key));
                    petToggleSettings.put(settingName, value);
                }
            }
            catch (IOException e) {
                System.err.println("Failed to load settings: " + e.getMessage());
            }
        }
    }

    public static void saveSettings() {
        Properties props = new Properties();
        for (Map.Entry<String, Boolean> entry : toggleSettings.entrySet()) {
            props.setProperty("toggle_" + entry.getKey(), entry.getValue().toString());
        }
        for (Map.Entry<String, Comparable<Boolean>> entry : sliderSettings.entrySet()) {
            props.setProperty("slider_" + entry.getKey(), ((Float)entry.getValue()).toString());
        }
        for (Map.Entry<String, Comparable<Boolean>> entry : boosterToggleSettings.entrySet()) {
            props.setProperty("booster_" + entry.getKey(), ((Boolean)entry.getValue()).toString());
        }
        for (Map.Entry<String, Comparable<Boolean>> entry : petToggleSettings.entrySet()) {
            props.setProperty("pet_" + entry.getKey(), ((Boolean)entry.getValue()).toString());
        }
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            try (OutputStream os = Files.newOutputStream(CONFIG_PATH, new OpenOption[0]);){
                props.store(os, "Untitled20 Mod Settings");
            }
        }
        catch (IOException e) {
            System.err.println("Failed to save settings: " + e.getMessage());
        }
    }

    public static void toggleSettings() {
        settingsOpen = !settingsOpen;
        SettingsInputHandler.cancelKeybindEditing();
        if (settingsOpen) {
            class_1041 window = class_310.method_1551().method_22683();
            SettingsRenderer.setPosition((window.method_4486() - SettingsRenderer.getWidth()) / 2, (window.method_4502() - SettingsRenderer.getHeight()) / 2);
        }
    }

    public static void closeSettings() {
        settingsOpen = false;
        SettingsInputHandler.saveThresholdsIfEditing();
        SettingsInputHandler.cancelKeybindEditing();
    }

    public static boolean isSettingsOpen() {
        return settingsOpen;
    }

    public static boolean isWaitingForKey() {
        return SettingsInputHandler.isWaitingForKey();
    }

    public static void applySettings() {
        String[] mobTiers;
        join.NOTIFICATIONS_ENABLED = toggleSettings.getOrDefault("Show Notifications", false);
        join.GUI_VISIBLE = toggleSettings.getOrDefault("Show Player List", false);
        join.MAX_PLAYERS_PER_COLUMN = sliderSettings.getOrDefault("Players per Column", Float.valueOf(15.0f)).intValue();
        AnnouncementHiderClient.hideAnnouncements = toggleSettings.getOrDefault("Hide Announcements", true);
        TrinketMod.setModEnabled(toggleSettings.getOrDefault("Trinket Display HUD", true));
        TrinketMod.setHudEnabled(toggleSettings.getOrDefault("Trinket Display HUD", true));
        ChestTrackerMod.setModEnabled(toggleSettings.getOrDefault("Chest Tracker HUD", true));
        XPBoosterMod.setColorAlertsEnabled(toggleSettings.getOrDefault("Color Alerts for Boosters", true));
        Amor.enabled = toggleSettings.getOrDefault("Armor Durability Alerts", true);
        ArmorToggleMod.hideArmor = toggleSettings.getOrDefault("Hide Armor", false);
        StatusEffectsTracker.setCombatHudEnabled(toggleSettings.getOrDefault("Combat HUD", true));
        StatusEffectsTracker.setMuleHudEnabled(toggleSettings.getOrDefault("Mule HUD", true));
        DamageDisplayMod.enabled = toggleSettings.getOrDefault("Damage Intercaters", true);
        HighlightSearchMod.isSearchVisible = toggleSettings.getOrDefault("Highlight Search", true);
        ChestTrackerMod.setHudEnabled(toggleSettings.getOrDefault("Mythic Fishing HUD", true));
        for (String tier : mobTiers = new String[]{"basic", "elite", "legendary", "godly", "mythic", "heroic"}) {
            String nametagKey = "Mob " + tier + " Nametag";
            String glowKey = "Mob " + tier + " Glow";
            if (toggleSettings.containsKey(nametagKey)) {
                NameTagSystem.getInstance().tierVisibility.put(tier + "_marauder", toggleSettings.get(nametagKey));
            }
            if (!toggleSettings.containsKey(glowKey)) continue;
            NameTagSystem.getInstance().glowVisibility.put(tier + "_marauder", toggleSettings.get(glowKey));
        }
    }

    public static boolean isBoosterEnabled(String boosterKey) {
        return boosterToggleSettings.getOrDefault(boosterKey, true);
    }

    public static Map<String, Boolean> getToggleSettings() {
        return toggleSettings;
    }

    public static Map<String, Float> getSliderSettings() {
        return sliderSettings;
    }

    public static Map<String, class_304> getKeybindList() {
        return keybindList;
    }

    public static List<String> getCommandHelp() {
        return commandHelp;
    }

    public static Map<String, Boolean> getBoosterToggleSettings() {
        return boosterToggleSettings;
    }

    public static Map<String, Boolean> getPetToggleSettings() {
        return petToggleSettings;
    }

    @Environment(value=EnvType.CLIENT)
    private static class ChaoticMessage {
        final String message;
        int timer;
        final UUID uuid;

        ChaoticMessage(String message, int duration) {
            this.message = message;
            this.timer = duration;
            this.uuid = UUID.randomUUID();
        }
    }
}

