/*
 * Decompiled with CFR 0.152.
 */
package chat.cosmic.client.client;

import chat.cosmic.client.client.SettingsInputHandler;
import chat.cosmic.client.client.SettingsManager;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.lwjgl.glfw.GLFW;

@Environment(value=EnvType.CLIENT)
public class SettingsRenderer {
    private static Tab currentTab = Tab.SETTINGS;
    private static int settingsX = 0;
    private static int settingsY = 0;
    private static final int WIDTH = 350;
    private static final int HEIGHT = 300;
    private static final int TAB_HEIGHT = 20;
    private static final Map<String, Boolean> lastToggleState = new HashMap<String, Boolean>();
    private static final Map<String, Boolean> lastSliderState = new HashMap<String, Boolean>();
    private static int sliderDragX = -1;
    private static final Map<String, Boolean> mobSectionOpen = new HashMap<String, Boolean>();

    public static void setPosition(int x, int y) {
        settingsX = x;
        settingsY = y;
    }

    public static int getWidth() {
        return 350;
    }

    public static int getHeight() {
        return 300;
    }

    public static void render(class_332 context, class_310 client) {
        if (!SettingsManager.isSettingsOpen()) {
            return;
        }
        context.method_25294(0, 0, client.method_22683().method_4486(), client.method_22683().method_4502(), Integer.MIN_VALUE);
        context.method_25294(settingsX, settingsY, settingsX + 350, settingsY + 300, -1440735200);
        context.method_49601(settingsX, settingsY, 350, 300, -2130706433);
        int tabWidth = 350 / Tab.values().length;
        for (Tab tab : Tab.values()) {
            boolean mouseOver;
            int tabX = settingsX + tab.index * tabWidth;
            boolean isActive = tab == currentTab;
            int color = isActive ? -1438629824 : -1439682512;
            context.method_25294(tabX, settingsY, tabX + tabWidth, settingsY + 20, color);
            context.method_27534(client.field_1772, class_2561.method_30163((String)tab.name), tabX + tabWidth / 2, settingsY + 6, 0xFFFFFF);
            double mouseX = client.field_1729.method_1603() * (double)client.method_22683().method_4486() / (double)client.method_22683().method_4480();
            double mouseY = client.field_1729.method_1604() * (double)client.method_22683().method_4502() / (double)client.method_22683().method_4507();
            boolean bl = mouseOver = mouseX >= (double)tabX && mouseX <= (double)(tabX + tabWidth) && mouseY >= (double)settingsY && mouseY <= (double)(settingsY + 20);
            if (!mouseOver || GLFW.glfwGetMouseButton((long)client.method_22683().method_4490(), (int)0) != 1) continue;
            SettingsInputHandler.saveThresholdsIfEditing();
            currentTab = tab;
        }
        int contentY = settingsY + 20;
        int contentHeight = 280;
        switch (currentTab) {
            case SETTINGS: {
                SettingsRenderer.renderSettingsTab(context, client, settingsX, contentY, 350, contentHeight);
                break;
            }
            case COMMANDS: {
                SettingsRenderer.renderCommandsTab(context, client, settingsX, contentY, 350, contentHeight);
                break;
            }
            case HUD_SETTINGS: {
                SettingsRenderer.renderHudSettingsTab(context, client, settingsX, contentY, 350, contentHeight);
                break;
            }
            case PETS: {
                SettingsRenderer.renderPetsTab(context, client, settingsX, contentY, 350, contentHeight);
                break;
            }
            case MOBS: {
                SettingsRenderer.renderMobsTab(context, client, settingsX, contentY, 350, contentHeight);
            }
        }
    }

    private static void renderSettingsTab(class_332 context, class_310 client, int x, int y, int width, int height) {
        int optionY = y + 10;
        double mouseX = client.field_1729.method_1603() * (double)client.method_22683().method_4486() / (double)client.method_22683().method_4480();
        double mouseY = client.field_1729.method_1604() * (double)client.method_22683().method_4502() / (double)client.method_22683().method_4507();
        boolean mouseDown = GLFW.glfwGetMouseButton((long)client.method_22683().method_4490(), (int)0) == 1;
        boolean mousePressed = mouseDown && !SettingsInputHandler.getLastMouseState();
        SettingsInputHandler.setLastMouseState(mouseDown);
        for (Map.Entry<String, Boolean> entry : SettingsManager.getToggleSettings().entrySet()) {
            boolean mouseOver;
            String key = entry.getKey();
            if (key.contains("HUD") && !key.equals("Trinket Display HUD") || key.startsWith("Mob ")) continue;
            String text = key + ": " + (entry.getValue() != false ? "ON" : "OFF");
            context.method_25303(client.field_1772, text, x + 10, optionY, 0xFFFFFF);
            boolean bl = mouseOver = mouseX >= (double)(x + 10) && mouseX <= (double)(x + width - 10) && mouseY >= (double)optionY && mouseY <= (double)(optionY + 10);
            if (mouseOver) {
                context.method_25294(x + 10, optionY, x + width - 10, optionY + 10, 0x20FFFFFF);
                if (mousePressed && !lastToggleState.getOrDefault(key, false).booleanValue()) {
                    SettingsInputHandler.saveThresholdsIfEditing();
                    SettingsManager.getToggleSettings().put(key, entry.getValue() == false);
                    SettingsManager.applySettings();
                    lastToggleState.put(key, true);
                }
            }
            if (!mouseOver || !mouseDown) {
                lastToggleState.put(key, false);
            }
            optionY += 12;
        }
        optionY += 5;
        for (Map.Entry<String, Comparable<Boolean>> entry : SettingsManager.getSliderSettings().entrySet()) {
            boolean mouseOverSlider;
            context.method_25303(client.field_1772, entry.getKey() + ": " + ((Float)entry.getValue()).intValue(), x + 10, optionY, 0xFFFFFF);
            int sliderX = x + 10;
            int sliderY = optionY += 12;
            int sliderWidth = width - 20;
            int sliderHeight = 5;
            int sliderHandleWidth = 6;
            int sliderHandleHeight = 12;
            context.method_25294(sliderX, sliderY + sliderHeight / 2 - 1, sliderX + sliderWidth, sliderY + sliderHeight / 2 + 1, -2140772762);
            float minValue = 1.0f;
            float maxValue = 50.0f;
            float normalizedValue = (((Float)entry.getValue()).floatValue() - minValue) / (maxValue - minValue);
            int handleX = sliderX + (int)((float)(sliderWidth - sliderHandleWidth) * normalizedValue);
            context.method_25294(handleX, sliderY, handleX + sliderHandleWidth, sliderY + sliderHandleHeight, -1);
            boolean bl = mouseOverSlider = mouseX >= (double)sliderX && mouseX <= (double)(sliderX + sliderWidth) && mouseY >= (double)sliderY && mouseY <= (double)(sliderY + sliderHandleHeight);
            if (mouseOverSlider && mouseDown) {
                if (sliderDragX == -1) {
                    SettingsInputHandler.saveThresholdsIfEditing();
                }
                sliderDragX = (int)mouseX;
            }
            if (sliderDragX != -1) {
                float newValue = (float)(sliderDragX - sliderX) / (float)sliderWidth * (maxValue - minValue) + minValue;
                SettingsManager.getSliderSettings().put(entry.getKey(), Float.valueOf(Math.max(minValue, Math.min(maxValue, newValue))));
                SettingsManager.applySettings();
                if (!mouseDown) {
                    sliderDragX = -1;
                }
            }
            optionY += 20;
        }
    }

    private static void renderHudSettingsTab(class_332 context, class_310 client, int x, int y, int width, int height) {
        int optionY = y + 10;
        double mouseX = client.field_1729.method_1603() * (double)client.method_22683().method_4486() / (double)client.method_22683().method_4480();
        double mouseY = client.field_1729.method_1604() * (double)client.method_22683().method_4502() / (double)client.method_22683().method_4507();
        boolean mouseDown = GLFW.glfwGetMouseButton((long)client.method_22683().method_4490(), (int)0) == 1;
        boolean mousePressed = mouseDown && !SettingsInputHandler.getLastMouseState();
        SettingsInputHandler.setLastMouseState(mouseDown);
        context.method_25303(client.field_1772, "HUD Modules:", x + 10, optionY, 0x55FFFF);
        optionY += 12;
        LinkedHashMap<Object, Boolean> allHudSettings = new LinkedHashMap<Object, Boolean>();
        allHudSettings.put("Chest Tracker HUD", SettingsManager.getToggleSettings().getOrDefault("Chest Tracker HUD", true));
        allHudSettings.put("Curse HUD", SettingsManager.getToggleSettings().getOrDefault("Curse HUD", true));
        allHudSettings.put("Chaotic Zone HUD", SettingsManager.getToggleSettings().getOrDefault("Chaotic Zone HUD", true));
        allHudSettings.put("Combat HUD", SettingsManager.getToggleSettings().getOrDefault("Combat HUD", true));
        allHudSettings.put("Mule HUD", SettingsManager.getToggleSettings().getOrDefault("Mule HUD", true));
        allHudSettings.put("Pet Active Effects HUD", SettingsManager.getToggleSettings().getOrDefault("Pet Active Effects HUD", true));
        for (Map.Entry<String, Boolean> entry : SettingsManager.getBoosterToggleSettings().entrySet()) {
            allHudSettings.put("  " + entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Boolean> entry : allHudSettings.entrySet()) {
            boolean mouseOver;
            String module = entry.getKey();
            boolean value = entry.getValue();
            String text = module + ": " + (value ? "ON" : "OFF");
            int indent = module.startsWith("  ") ? 10 : 0;
            context.method_25303(client.field_1772, text, x + 20 + indent, optionY, 0xFFFFFF);
            boolean bl = mouseOver = mouseX >= (double)(x + 20 + indent) && mouseX <= (double)(x + width - 20) && mouseY >= (double)optionY && mouseY <= (double)(optionY + 10);
            if (mouseOver) {
                context.method_25294(x + 20 + indent, optionY, x + width - 20, optionY + 10, 0x20FFFFFF);
                if (mousePressed && !lastToggleState.getOrDefault(module, false).booleanValue()) {
                    SettingsInputHandler.saveThresholdsIfEditing();
                    if (module.startsWith("  ")) {
                        SettingsManager.getBoosterToggleSettings().put(module.trim(), !value);
                    } else {
                        SettingsManager.getToggleSettings().put(module, !value);
                    }
                    SettingsManager.applySettings();
                    SettingsManager.saveSettings();
                    lastToggleState.put(module, true);
                }
            }
            if (!mouseOver || !mouseDown) {
                lastToggleState.put(module, false);
            }
            optionY += 12;
        }
    }

    private static void renderPetsTab(class_332 context, class_310 client, int x, int y, int width, int height) {
        int optionY = y + 10;
        String[] pets = new String[]{"Battle Pig Pet", "Miner Matt Pet", "Slayer Sam Pet", "Chaos Cow Pet", "Blacksmith Brandon Pet", "Fisherman Fred Pet", "Alchemist Alex Pet", "Blood Sheep Pet", "Merchant Pet", "Dire Wolf Pet", "Void Chicken Pet", "Loot Llama Pet", "Barry Bee Pet"};
        double mouseX = client.field_1729.method_1603() * (double)client.method_22683().method_4486() / (double)client.method_22683().method_4480();
        double mouseY = client.field_1729.method_1604() * (double)client.method_22683().method_4502() / (double)client.method_22683().method_4507();
        boolean mouseDown = GLFW.glfwGetMouseButton((long)client.method_22683().method_4490(), (int)0) == 1;
        boolean mousePressed = mouseDown && !SettingsInputHandler.getLastMouseState();
        SettingsInputHandler.setLastMouseState(mouseDown);
        context.method_25303(client.field_1772, "Pet Active Effects Display:", x + 10, optionY, 0x55FFFF);
        context.method_25303(client.field_1772, "Toggle which pets show on HUD", x + 10, optionY += 12, 0xAAAAAA);
        optionY += 15;
        for (String pet : pets) {
            boolean mouseOver;
            String settingKey = "Pet " + pet;
            boolean enabled = SettingsManager.getPetToggleSettings().getOrDefault(settingKey, true);
            String displayText = pet + ": " + (enabled ? "\u00a7aON" : "\u00a7cOFF");
            context.method_25303(client.field_1772, displayText, x + 20, optionY, 0xFFFFFF);
            boolean bl = mouseOver = mouseX >= (double)(x + 20) && mouseX <= (double)(x + 200) && mouseY >= (double)optionY && mouseY <= (double)(optionY + 10);
            if (mouseOver) {
                context.method_25294(x + 20, optionY, x + 200, optionY + 10, 0x20FFFFFF);
                if (mousePressed) {
                    SettingsInputHandler.saveThresholdsIfEditing();
                    SettingsManager.getPetToggleSettings().put(settingKey, !enabled);
                    SettingsManager.saveSettings();
                }
            }
            optionY += 12;
        }
    }

    private static void renderMobsTab(class_332 context, class_310 client, int x, int y, int width, int height) {
        int optionY = y + 10;
        String[] mobTiers = new String[]{"basic", "elite", "legendary", "godly", "mythic", "heroic"};
        String[] tierNames = new String[]{"Basic", "Elite", "Legendary", "Godly", "Mythic", "Heroic"};
        double mouseX = client.field_1729.method_1603() * (double)client.method_22683().method_4486() / (double)client.method_22683().method_4480();
        double mouseY = client.field_1729.method_1604() * (double)client.method_22683().method_4502() / (double)client.method_22683().method_4507();
        boolean mouseDown = GLFW.glfwGetMouseButton((long)client.method_22683().method_4490(), (int)0) == 1;
        boolean mousePressed = mouseDown && !SettingsInputHandler.getLastMouseState();
        SettingsInputHandler.setLastMouseState(mouseDown);
        context.method_25303(client.field_1772, "Mob Settings:", x + 10, optionY, 0x55FFFF);
        optionY += 12;
        for (int i = 0; i < mobTiers.length; ++i) {
            boolean nametagMouseOver;
            String tier = mobTiers[i];
            String tierName = tierNames[i];
            String nametagKey = "Mob " + tier + " Nametag";
            String glowKey = "Mob " + tier + " Glow";
            boolean nametagVisible = SettingsManager.getToggleSettings().getOrDefault(nametagKey, true);
            boolean glowVisible = SettingsManager.getToggleSettings().getOrDefault(glowKey, true);
            context.method_25303(client.field_1772, tierName + " Marauder:", x + 20, optionY, 0xFFFFFF);
            String nametagText = "Nametag: " + (nametagVisible ? "ON" : "OFF");
            context.method_25303(client.field_1772, nametagText, x + 30, optionY += 12, 0xFFFFFF);
            boolean bl = nametagMouseOver = mouseX >= (double)(x + 30) && mouseX <= (double)(x + 130) && mouseY >= (double)optionY && mouseY <= (double)(optionY + 10);
            if (nametagMouseOver) {
                context.method_25294(x + 30, optionY, x + 130, optionY + 10, 0x20FFFFFF);
                if (mousePressed) {
                    SettingsInputHandler.saveThresholdsIfEditing();
                    SettingsManager.getToggleSettings().put(nametagKey, !nametagVisible);
                    SettingsManager.applySettings();
                    SettingsManager.saveSettings();
                }
            }
            if (!tier.equals("basic") && !tier.equals("elite")) {
                boolean glowMouseOver;
                String glowText = "Glow: " + (glowVisible ? "ON" : "OFF");
                context.method_25303(client.field_1772, glowText, x + 150, optionY, 0xFFFFFF);
                boolean bl2 = glowMouseOver = mouseX >= (double)(x + 150) && mouseX <= (double)(x + 250) && mouseY >= (double)optionY && mouseY <= (double)(optionY + 10);
                if (glowMouseOver) {
                    context.method_25294(x + 150, optionY, x + 250, optionY + 10, 0x20FFFFFF);
                    if (mousePressed) {
                        SettingsInputHandler.saveThresholdsIfEditing();
                        SettingsManager.getToggleSettings().put(glowKey, !glowVisible);
                        SettingsManager.applySettings();
                        SettingsManager.saveSettings();
                    }
                }
            }
            optionY += 12;
        }
    }

    private static void renderCommandsTab(class_332 context, class_310 client, int x, int y, int width, int height) {
        int optionY = y + 10;
        for (String command : SettingsManager.getCommandHelp()) {
            context.method_25303(client.field_1772, command, x + 10, optionY, 0xFFFFFF);
            optionY += 12;
        }
    }

    private static boolean hasKeybindConflict(class_304 keyBinding) {
        if (keyBinding.method_1415()) {
            return false;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1690 == null) {
            return false;
        }
        class_304[] allKeybinds = client.field_1690.field_1839;
        String boundKey = keyBinding.method_1428();
        int conflictCount = 0;
        for (class_304 kb : allKeybinds) {
            if (!kb.method_1428().equals(boundKey) || ++conflictCount <= 1) continue;
            return true;
        }
        return false;
    }

    public static boolean isMouseOverSettings(double mouseX, double mouseY) {
        if (!SettingsManager.isSettingsOpen()) {
            return false;
        }
        return mouseX >= (double)settingsX && mouseX <= (double)(settingsX + 350) && mouseY >= (double)settingsY && mouseY <= (double)(settingsY + 300);
    }

    @Environment(value=EnvType.CLIENT)
    public static enum Tab {
        SETTINGS("Settings", 0),
        COMMANDS("Commands", 1),
        HUD_SETTINGS("HUD Settings", 2),
        PETS("Pets", 3),
        MOBS("Mobs", 4);

        public final String name;
        public final int index;

        private Tab(String name, int index) {
            this.name = name;
            this.index = index;
        }
    }
}

