/*
 * Decompiled with CFR 0.152.
 */
package chat.cosmic.client.client;

import chat.cosmic.client.client.KeyBinds.KeyBinds;
import chat.cosmic.client.client.SettingsManager;
import chat.cosmic.client.client.UniversalGuiMover;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class TrinketMod
implements ModInitializer {
    private static final Pattern CHARGE_PATTERN = Pattern.compile(".*\\((\\d+)\\)");
    private static final String HUD_ID = "trinket_display";
    private static final Path CONFIG_PATH = Paths.get("config", "trinket_display.properties");
    private UniversalGuiMover.HudContainer hudContainer;
    private boolean hudVisible = true;
    private static boolean modEnabled = true;
    private static boolean hudEnabled = true;
    private static final List<String> ALLOWED_TRINKETS = List.of("Speed Trinket I", "Strength Trinket I", "Ender Pearl Trinket", "Healing Trink I", "Healing Trinket II", "Healing Trinket III");

    public static void setModEnabled(boolean enabled) {
        modEnabled = enabled;
    }

    public static void setHudEnabled(boolean enabled) {
        hudEnabled = enabled;
    }

    public void onInitialize() {
        this.loadConfig();
        hudEnabled = SettingsManager.getToggleSettings().getOrDefault("Trinket Display HUD", true);
        HudRenderCallback.EVENT.register(this::renderTrinkets);
        this.hudContainer = new UniversalGuiMover.HudContainer(10, 10, 150, 12, 1);
        UniversalGuiMover.trackHudContainer(HUD_ID, this.hudContainer);
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (KeyBinds.getToggleTrinketHud().method_1436()) {
                this.hudVisible = !this.hudVisible;
                SettingsManager.getToggleSettings().put("Trinket Display HUD", this.hudVisible);
                SettingsManager.saveSettings();
                this.saveConfig();
            }
        });
    }

    private void loadConfig() {
        try {
            if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                Properties props = new Properties();
                props.load(Files.newInputStream(CONFIG_PATH, new OpenOption[0]));
                this.hudVisible = Boolean.parseBoolean(props.getProperty("visible", "true"));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveConfig() {
        try {
            Properties props = new Properties();
            props.setProperty("visible", String.valueOf(this.hudVisible));
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            props.store(Files.newOutputStream(CONFIG_PATH, new OpenOption[0]), "Trinket Display Mod Configuration");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void renderTrinkets(class_332 drawContext, float tickDelta) {
        if (!(modEnabled && this.hudVisible && hudEnabled)) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        List<TrinketData> trinkets = this.getHotbarTrinkets(client.field_1724.method_31548());
        if (trinkets.isEmpty()) {
            return;
        }
        this.hudContainer.lineCount = trinkets.size();
        int x = this.hudContainer.x;
        int y = this.hudContainer.y;
        float scale = UniversalGuiMover.getGlobalTextScale();
        int maxWidth = 0;
        for (TrinketData trinket : trinkets) {
            String text = trinket.name + ": " + trinket.charges;
            int width = client.field_1772.method_1727(text);
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        this.hudContainer.baseWidth = maxWidth + 10;
        this.hudContainer.baseHeight = 12;
        drawContext.method_51448().method_22903();
        drawContext.method_51448().method_46416((float)x, (float)y, 0.0f);
        drawContext.method_51448().method_22905(scale, scale, 1.0f);
        int yOffset = 0;
        for (TrinketData trinket : trinkets) {
            drawContext.method_51439(client.field_1772, (class_2561)class_2561.method_43470((String)(trinket.name + ": " + trinket.charges)).method_27692(class_124.field_1068), 0, yOffset, 0xFFFFFF, false);
            yOffset += 10;
        }
        drawContext.method_51448().method_22909();
    }

    private List<TrinketData> getHotbarTrinkets(class_1661 inv) {
        ArrayList<TrinketData> trinkets = new ArrayList<TrinketData>();
        for (int i = 0; i < 9; ++i) {
            Matcher matcher;
            class_1799 stack = inv.method_5438(i);
            if (stack.method_7960()) continue;
            String name = stack.method_7964().getString();
            boolean isAllowed = ALLOWED_TRINKETS.stream().anyMatch(allowed -> name.startsWith((String)allowed));
            if (!isAllowed || !(matcher = CHARGE_PATTERN.matcher(name)).find()) continue;
            int charges = Integer.parseInt(matcher.group(1));
            String cleanName = name.replaceAll("\\s*\\(\\d+\\)", "").trim();
            trinkets.add(new TrinketData(cleanName, charges));
        }
        trinkets.sort(Comparator.comparingInt(t -> {
            String lowerName = t.name.toLowerCase();
            if (lowerName.contains("healing")) {
                return 1;
            }
            if (lowerName.contains("speed")) {
                return 2;
            }
            if (lowerName.contains("strength")) {
                return 3;
            }
            if (lowerName.contains("pearl")) {
                if (t.name.endsWith("III")) {
                    return 4;
                }
                if (t.name.endsWith("II")) {
                    return 5;
                }
                return 6;
            }
            return 7;
        }));
        return trinkets;
    }

    @Environment(value=EnvType.CLIENT)
    private static class TrinketData {
        final String name;
        final int charges;

        TrinketData(String name, int charges) {
            this.name = name;
            this.charges = charges;
        }
    }
}

