/*
 * Decompiled with CFR 0.152.
 */
package chat.cosmic.client.client;

import chat.cosmic.client.client.TrophyTrackerMod;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

@Environment(value=EnvType.CLIENT)
public class TrophyGuiScreen
extends class_437 {
    private static final int BACKGROUND_COLOR = -2013265920;
    private static final int PANEL_COLOR = -1441722095;
    private static final int BORDER_COLOR = -12303292;
    private static final int TEXT_COLOR = -1;
    private static final int HIGHLIGHT_COLOR = -256;
    private int panelX;
    private int panelY;
    private int panelWidth;
    private int panelHeight;
    private List<Map.Entry<String, Integer>> sortedTrophies;
    private int scrollOffset = 0;
    private final int maxVisibleEntries = 10;
    private boolean canScroll = false;

    public TrophyGuiScreen() {
        super((class_2561)class_2561.method_43470((String)"Trophy Points"));
    }

    protected void method_25426() {
        super.method_25426();
        this.panelWidth = Math.min(400, this.field_22789 - 40);
        this.panelHeight = Math.min(300, this.field_22790 - 40);
        this.panelX = (this.field_22789 - this.panelWidth) / 2;
        this.panelY = (this.field_22790 - this.panelHeight) / 2;
        Map<String, Integer> trophies = TrophyTrackerMod.getTrophies();
        this.sortedTrophies = new ArrayList<Map.Entry<String, Integer>>(trophies.entrySet());
        this.sortedTrophies.sort((a, b) -> ((Integer)b.getValue()).compareTo((Integer)a.getValue()));
        this.canScroll = this.sortedTrophies.size() > 10;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Close"), button -> this.method_25419()).method_46434(this.panelX + this.panelWidth - 60, this.panelY + this.panelHeight - 30, 50, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reset All").method_27692(class_124.field_1061), button -> {
            TrophyTrackerMod.resetAllTrophies();
            this.method_25419();
        }).method_46434(this.panelX + 10, this.panelY + this.panelHeight - 30, 70, 20).method_46431());
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        context.method_25294(0, 0, this.field_22789, this.field_22790, -2013265920);
        this.renderRoundedPanel(context);
        class_5250 title = class_2561.method_43470((String)"\ud83c\udfc6 Trophy Points").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067});
        int titleWidth = this.field_22793.method_27525((class_5348)title);
        context.method_51439(this.field_22793, (class_2561)title, this.panelX + (this.panelWidth - titleWidth) / 2, this.panelY + 10, -1, true);
        int totalPoints = TrophyTrackerMod.getTotalPoints();
        class_5250 totalText = class_2561.method_43470((String)("Total: " + totalPoints + " points")).method_27692(class_124.field_1060);
        int totalWidth = this.field_22793.method_27525((class_5348)totalText);
        context.method_51439(this.field_22793, (class_2561)totalText, this.panelX + (this.panelWidth - totalWidth) / 2, this.panelY + 25, -1, true);
        if (this.sortedTrophies.isEmpty()) {
            class_5250 noTrophies = class_2561.method_43470((String)"No trophy points yet!").method_27692(class_124.field_1080);
            int noTrophiesWidth = this.field_22793.method_27525((class_5348)noTrophies);
            context.method_51439(this.field_22793, (class_2561)noTrophies, this.panelX + (this.panelWidth - noTrophiesWidth) / 2, this.panelY + 60, -1, true);
        } else {
            this.renderTrophiesList(context);
        }
        if (this.canScroll) {
            this.renderScrollIndicator(context);
        }
        super.method_25394(context, mouseX, mouseY, delta);
    }

    private void renderRoundedPanel(class_332 context) {
        int cornerRadius = 5;
        context.method_25294(this.panelX + cornerRadius, this.panelY, this.panelX + this.panelWidth - cornerRadius, this.panelY + this.panelHeight, -1441722095);
        context.method_25294(this.panelX, this.panelY + cornerRadius, this.panelX + this.panelWidth, this.panelY + this.panelHeight - cornerRadius, -1441722095);
        context.method_25294(this.panelX, this.panelY, this.panelX + cornerRadius, this.panelY + cornerRadius, -1441722095);
        context.method_25294(this.panelX + this.panelWidth - cornerRadius, this.panelY, this.panelX + this.panelWidth, this.panelY + cornerRadius, -1441722095);
        context.method_25294(this.panelX, this.panelY + this.panelHeight - cornerRadius, this.panelX + cornerRadius, this.panelY + this.panelHeight, -1441722095);
        context.method_25294(this.panelX + this.panelWidth - cornerRadius, this.panelY + this.panelHeight - cornerRadius, this.panelX + this.panelWidth, this.panelY + this.panelHeight, -1441722095);
        context.method_49601(this.panelX, this.panelY, this.panelWidth, this.panelHeight, -12303292);
    }

    private void renderTrophiesList(class_332 context) {
        int index;
        int startY = this.panelY + 50;
        int entryHeight = 20;
        int maxEntries = Math.min(10, this.sortedTrophies.size() - this.scrollOffset);
        if (this.scrollOffset < 0) {
            this.scrollOffset = 0;
        }
        if (this.scrollOffset > this.sortedTrophies.size() - 10) {
            this.scrollOffset = Math.max(0, this.sortedTrophies.size() - 10);
        }
        context.method_25294(this.panelX + 5, startY - 2, this.panelX + this.panelWidth - 5, startY + maxEntries * entryHeight, 0x22000000);
        for (int i = 0; i < maxEntries && (index = i + this.scrollOffset) < this.sortedTrophies.size(); ++i) {
            Map.Entry<String, Integer> entry = this.sortedTrophies.get(index);
            String cropName = entry.getKey();
            int points = entry.getValue();
            int y = startY + i * entryHeight;
            if (i % 2 == 0) {
                context.method_25294(this.panelX + 5, y - 1, this.panelX + this.panelWidth - 5, y + entryHeight - 1, 0x11FFFFFF);
            }
            String icon = this.getCropIcon(cropName);
            context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)icon), this.panelX + 10, y, -1, true);
            context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)cropName).method_27692(class_124.field_1075), this.panelX + 30, y, -1, true);
            class_5250 pointsText = class_2561.method_43470((String)(points + " pts")).method_27692(class_124.field_1054);
            int pointsWidth = this.field_22793.method_27525((class_5348)pointsText);
            context.method_51439(this.field_22793, (class_2561)pointsText, this.panelX + this.panelWidth - pointsWidth - 15, y, -1, true);
        }
    }

    private void renderScrollIndicator(class_332 context) {
        int scrollBarX = this.panelX + this.panelWidth - 8;
        int scrollBarY = this.panelY + 50;
        int scrollBarHeight = 200;
        context.method_25294(scrollBarX, scrollBarY, scrollBarX + 6, scrollBarY + scrollBarHeight, -13421773);
        float scrollPercent = (float)this.scrollOffset / (float)(this.sortedTrophies.size() - 10);
        int thumbY = scrollBarY + (int)(scrollPercent * (float)(scrollBarHeight - 20));
        thumbY = Math.max(scrollBarY, Math.min(scrollBarY + scrollBarHeight - 20, thumbY));
        context.method_25294(scrollBarX + 1, thumbY, scrollBarX + 5, thumbY + 20, -7829368);
    }

    private String getCropIcon(String cropName) {
        return switch (cropName.toLowerCase()) {
            case "wheat" -> "\ud83c\udf3e";
            case "carrot", "carrots" -> "\ud83e\udd55";
            case "potato", "potatoes" -> "\ud83e\udd54";
            case "melon", "melons" -> "\ud83c\udf49";
            case "pumpkin", "pumpkins" -> "\ud83c\udf83";
            case "sugar cane" -> "\ud83c\udf8b";
            case "cocoa beans", "cocoa" -> "\ud83e\uded8";
            case "nether wart" -> "\ud83c\udf44";
            case "beetroot" -> "\ud83d\udfe5";
            default -> "\ud83c\udf31";
        };
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.canScroll) {
            int newScrollOffset = this.scrollOffset - (int)verticalAmount;
            newScrollOffset = Math.max(0, Math.min(this.sortedTrophies.size() - 10, newScrollOffset));
            if (newScrollOffset != this.scrollOffset) {
                this.scrollOffset = newScrollOffset;
                return true;
            }
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.canScroll && button == 0) {
            int scrollBarX = this.panelX + this.panelWidth - 8;
            int scrollBarY = this.panelY + 50;
            int scrollBarHeight = 200;
            if (mouseX >= (double)scrollBarX && mouseX <= (double)(scrollBarX + 6) && mouseY >= (double)scrollBarY && mouseY <= (double)(scrollBarY + scrollBarHeight)) {
                float clickPercent = (float)(mouseY - (double)scrollBarY) / (float)scrollBarHeight;
                this.scrollOffset = (int)(clickPercent * (float)(this.sortedTrophies.size() - 10));
                this.scrollOffset = Math.max(0, Math.min(this.sortedTrophies.size() - 10, this.scrollOffset));
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25421() {
        return false;
    }
}

