/*
 * Decompiled with CFR 0.152.
 */
package chat.cosmic.client.client;

import chat.cosmic.client.client.KeyBinds.KeyBinds;
import chat.cosmic.client.client.TrophyGuiScreen;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class TrophyTrackerMod
implements ClientModInitializer {
    public static final String MOD_ID = "trophytracker";
    private static final Map<String, Integer> playerTrophies = new ConcurrentHashMap<String, Integer>();
    private static int totalPoints = 0;
    private static final Pattern TROPHY_PATTERN = Pattern.compile("(\\d+) Trophy Points? \\(([^)]+\\))", 2);

    public void onInitializeClient() {
        System.out.println("TrophyTracker client mod initialized!");
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (KeyBinds.TrophyTracker_hud.method_1436()) {
                TrophyTrackerMod.openTrophyGui();
            }
        });
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> this.registerCommands((CommandDispatcher<FabricClientCommandSource>)dispatcher));
    }

    public static void openTrophyGui() {
        class_310.method_1551().method_1507((class_437)new TrophyGuiScreen());
    }

    private void registerCommands(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"trophy").then(ClientCommandManager.literal((String)"gui").executes(context -> {
            TrophyTrackerMod.openTrophyGui();
            return 1;
        }))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"check").executes(this::checkTrophies)).then(ClientCommandManager.argument((String)"type", (ArgumentType)StringArgumentType.string()).executes(this::checkSpecificTrophy)))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"reset").executes(this::resetAllTrophies)).then(ClientCommandManager.argument((String)"type", (ArgumentType)StringArgumentType.string()).executes(this::resetSpecificTrophy))));
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"trophies").executes(this::checkTrophies));
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"resetpoints").executes(this::resetAllTrophies));
    }

    public static void processTrophyMessage(String message) {
        String cleanMessage = TrophyTrackerMod.removeFormattingCodes(message);
        Matcher matcher = TROPHY_PATTERN.matcher(cleanMessage);
        if (matcher.find()) {
            int points = Integer.parseInt(matcher.group(1));
            String type = matcher.group(2);
            type = TrophyTrackerMod.removeFormattingCodes(type).trim();
            TrophyTrackerMod.addTrophyPoints(type, points);
        }
    }

    private static String removeFormattingCodes(String text) {
        return text.replaceAll("\u00a7[0-9a-fk-or]", "");
    }

    private int checkTrophies(CommandContext<FabricClientCommandSource> context) {
        if (playerTrophies.isEmpty()) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"You have no trophy points yet!").method_27692(class_124.field_1054));
            return 0;
        }
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"=== Your Trophy Points ===").method_27692(class_124.field_1065));
        for (Map.Entry<String, Integer> entry : playerTrophies.entrySet()) {
            String type = entry.getKey();
            int points = entry.getValue();
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)(type + ": " + points + " points")).method_27692(class_124.field_1075));
        }
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Total Points: " + totalPoints)).method_27692(class_124.field_1060));
        return 1;
    }

    private int checkSpecificTrophy(CommandContext<FabricClientCommandSource> context) {
        String type = StringArgumentType.getString(context, (String)"type");
        int points = playerTrophies.getOrDefault(type, 0);
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)(type + " Trophy Points: " + points)).method_27692(class_124.field_1075));
        return 1;
    }

    private int resetAllTrophies(CommandContext<FabricClientCommandSource> context) {
        TrophyTrackerMod.resetAllTrophies();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"All trophy points have been reset!").method_27692(class_124.field_1061));
        return 1;
    }

    private int resetSpecificTrophy(CommandContext<FabricClientCommandSource> context) {
        String type = StringArgumentType.getString(context, (String)"type");
        int removedPoints = playerTrophies.getOrDefault(type, 0);
        playerTrophies.remove(type);
        totalPoints = Math.max(0, totalPoints - removedPoints);
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)(type + " trophy points have been reset! (Removed " + removedPoints + " points)")).method_27692(class_124.field_1061));
        return 1;
    }

    public static void addTrophyPoints(String type, int points) {
        playerTrophies.merge(type, points, Integer::sum);
        totalPoints += points;
    }

    public static int getTotalPoints() {
        return totalPoints;
    }

    public static Map<String, Integer> getTrophies() {
        return new HashMap<String, Integer>(playerTrophies);
    }

    public static void resetAllTrophies() {
        playerTrophies.clear();
        totalPoints = 0;
    }
}

