/*
 * Decompiled with CFR 0.152.
 */
package chat.cosmic.client.client;

import chat.cosmic.client.client.KeyBinds.KeyBinds;
import chat.cosmic.client.client.SettingsInputHandler;
import chat.cosmic.client.client.SettingsManager;
import chat.cosmic.client.client.SettingsRenderer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1041;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.lwjgl.glfw.GLFW;

@Environment(value=EnvType.CLIENT)
public class UniversalGuiMover
implements ClientModInitializer {
    private static boolean isMovementMode = false;
    private static HudContainer draggedContainer = null;
    private static final Map<String, HudContainer> hudContainers = new HashMap<String, HudContainer>();
    private static final String CONFIG_FILE = "config/untitled20_mod.properties";
    private static float globalTextScale = 1.0f;
    private static boolean dragging;
    private static int lastWindowWidth;
    private static int lastWindowHeight;
    private static final HudContainer settingsButton;

    public void onInitializeClient() {
        ClientLifecycleEvents.CLIENT_STOPPING.register(client -> {
            UniversalGuiMover.saveGuiPositions();
            SettingsManager.saveSettings();
        });
        this.setupKeybinds();
        HudRenderCallback.EVENT.register(this::onHudRender);
        ClientTickEvents.END_CLIENT_TICK.register(this::onClientTick);
        ClientTickEvents.START_CLIENT_TICK.register(client -> {
            if (isMovementMode) {
                client.field_1729.method_1606();
            }
        });
        SettingsManager.initialize();
        UniversalGuiMover.trackHudContainer("settings_button", settingsButton);
        UniversalGuiMover.initializeBossBarTracking();
    }

    private static void initializeBossBarTracking() {
    }

    private void onClientTick(class_310 client) {
        if (client.field_1687 == null) {
            return;
        }
        class_1041 window = client.method_22683();
        if (window == null) {
            return;
        }
        int currentWidth = window.method_4486();
        int currentHeight = window.method_4502();
        if (!(lastWindowWidth == currentWidth && lastWindowHeight == currentHeight || isMovementMode)) {
            if (lastWindowWidth > 0 && lastWindowHeight > 0) {
                float widthRatio = (float)currentWidth / (float)lastWindowWidth;
                float heightRatio = (float)currentHeight / (float)lastWindowHeight;
                for (HudContainer container : hudContainers.values()) {
                    container.x = (int)((float)container.x * widthRatio);
                    container.y = (int)((float)container.y * heightRatio);
                    UniversalGuiMover.clampPosition(container, window);
                }
            }
            lastWindowWidth = currentWidth;
            lastWindowHeight = currentHeight;
        }
        if (isMovementMode) {
            UniversalGuiMover.settingsButton.x = window.method_4486() - settingsButton.getScaledWidth() - 5;
            UniversalGuiMover.settingsButton.y = 5;
        }
        if (KeyBinds.getScaleUp().method_1436()) {
            UniversalGuiMover.updateScale(0.1f, client);
        }
        if (KeyBinds.getScaleDown().method_1436()) {
            UniversalGuiMover.updateScale(-0.1f, client);
        }
        if (KeyBinds.getToggleGUIMovement().method_1436() && client.field_1755 == null) {
            UniversalGuiMover.toggleMovementMode(client);
        }
    }

    public static void toggleMovementMode(class_310 client) {
        class_1041 window;
        boolean bl = isMovementMode = !isMovementMode;
        if (isMovementMode) {
            client.method_1507((class_437)new DummyScreen());
            client.field_1690.field_1837 = true;
        } else {
            client.method_1507(null);
            client.field_1690.field_1837 = false;
            SettingsManager.closeSettings();
        }
        if (client.field_1724 != null) {
            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("GUI Movement: " + (isMovementMode ? "ON" : "OFF"))), true);
        }
        if ((window = client.method_22683()) != null) {
            lastWindowWidth = window.method_4486();
            lastWindowHeight = window.method_4502();
        }
    }

    public static void loadGuiPositions(Properties props) {
        if (props.containsKey("scale")) {
            globalTextScale = Float.parseFloat(props.getProperty("scale"));
        }
        props.stringPropertyNames().stream().filter(key -> key.contains(".")).forEach(key -> {
            String[] parts = key.split("\\.", 2);
            String id = parts[0];
            String prop = parts[1];
            HudContainer container = hudContainers.get(id);
            if (container != null) {
                switch (prop) {
                    case "x": {
                        container.x = Integer.parseInt(props.getProperty((String)key));
                        break;
                    }
                    case "y": {
                        container.y = Integer.parseInt(props.getProperty((String)key));
                    }
                }
            }
        });
    }

    public static void saveGuiPositions(Properties props) {
        props.setProperty("scale", String.valueOf(globalTextScale));
        hudContainers.forEach((id, container) -> {
            props.setProperty(id + ".x", String.valueOf(container.x));
            props.setProperty(id + ".y", String.valueOf(container.y));
        });
    }

    public static void saveGuiPositions() {
        Properties props = new Properties();
        UniversalGuiMover.saveGuiPositions(props);
        try {
            Files.createDirectories(Path.of(CONFIG_FILE, new String[0]).getParent(), new FileAttribute[0]);
            props.store(Files.newOutputStream(Path.of(CONFIG_FILE, new String[0]), new OpenOption[0]), "GUI Positions");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadGuiPositions() {
        Properties props = new Properties();
        try {
            if (Files.exists(Path.of(CONFIG_FILE, new String[0]), new LinkOption[0])) {
                props.load(Files.newInputStream(Path.of(CONFIG_FILE, new String[0]), new OpenOption[0]));
                UniversalGuiMover.loadGuiPositions(props);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void setupKeybinds() {
    }

    public static void handleKeyPress(int key, int scancode, int action, int modifiers) {
        SettingsInputHandler.handleKeyPress(key, scancode, action, modifiers);
    }

    public static void handleCharInput(char character) {
        SettingsInputHandler.handleCharInput(character);
    }

    private void onHudRender(class_332 context, float tickDelta) {
        class_310 client = class_310.method_1551();
        if (client == null) {
            return;
        }
        this.handleDragging(client);
        if (isMovementMode) {
            boolean mouseDown;
            context.method_25294(0, 0, client.method_22683().method_4486(), client.method_22683().method_4502(), Integer.MIN_VALUE);
            for (Map.Entry<String, HudContainer> entry : hudContainers.entrySet()) {
                HudContainer container = entry.getValue();
                if (container == settingsButton || !UniversalGuiMover.isContainerEnabled(entry.getKey())) continue;
                int x = container.x;
                int y = container.y;
                int width = container.getScaledWidth();
                int height = container.getScaledHeight();
                context.method_25294(x, y, x + width, y + height, 0x20FFFFFF);
                context.method_25294(x, y, x + width, y + 2, -1);
                context.method_25294(x, y + height - 2, x + width, y + height, -1);
                context.method_25294(x, y, x + 2, y + height, -1);
                context.method_25294(x + width - 2, y, x + width, y + height, -1);
            }
            HudContainer button = UniversalGuiMover.getHudContainer("settings_button");
            if (button != null) {
                context.method_25294(button.x, button.y, button.x + button.getScaledWidth(), button.y + button.getScaledHeight(), 0x55000000);
                context.method_27534(client.field_1772, class_2561.method_30163((String)"Settings"), button.x + button.getScaledWidth() / 2, button.y + 6, 0xFFFFFF);
            }
            double mouseX = client.field_1729.method_1603() * (double)client.method_22683().method_4486() / (double)client.method_22683().method_4480();
            double mouseY = client.field_1729.method_1604() * (double)client.method_22683().method_4502() / (double)client.method_22683().method_4507();
            boolean bl = mouseDown = GLFW.glfwGetMouseButton((long)client.method_22683().method_4490(), (int)0) == 1;
            if (!SettingsInputHandler.isWaitingForKey()) {
                SettingsInputHandler.handleClick(mouseX, mouseY, mouseDown);
                if (SettingsInputHandler.shouldToggleSettings(mouseX, mouseY, mouseDown)) {
                    SettingsManager.toggleSettings();
                }
            }
            if (SettingsManager.isSettingsOpen()) {
                SettingsRenderer.render(context, client);
            }
        }
    }

    private static boolean isContainerEnabled(String containerId) {
        Map<String, Boolean> toggleSettings = SettingsManager.getToggleSettings();
        Map<String, Boolean> boosterToggleSettings = SettingsManager.getBoosterToggleSettings();
        if ("Marauder Bar".equals(containerId) || "Island Quest Bar".equals(containerId)) {
            return boosterToggleSettings.getOrDefault(containerId, true);
        }
        if ("trinket_display".equals(containerId)) {
            return toggleSettings.getOrDefault("Trinket Display HUD", true);
        }
        if ("pet_hud".equals(containerId)) {
            return toggleSettings.getOrDefault("Pet Active Effects HUD", true);
        }
        if (toggleSettings.containsKey(containerId + " HUD")) {
            return toggleSettings.get(containerId + " HUD");
        }
        if (boosterToggleSettings.containsKey(containerId)) {
            return boosterToggleSettings.get(containerId);
        }
        return true;
    }

    private static void updateScale(float delta, class_310 client) {
        globalTextScale = Math.max(0.5f, Math.min(2.5f, globalTextScale + delta));
        if (client.field_1724 != null) {
            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("Scale: " + String.format("%.1f", Float.valueOf(globalTextScale)))), true);
        }
    }

    private void handleDragging(class_310 client) {
        boolean mouseDown;
        if (!isMovementMode || SettingsManager.isSettingsOpen() || SettingsInputHandler.isWaitingForKey()) {
            return;
        }
        class_1041 window = client.method_22683();
        double mouseX = client.field_1729.method_1603() * (double)window.method_4486() / (double)window.method_4480();
        double mouseY = client.field_1729.method_1604() * (double)window.method_4502() / (double)window.method_4507();
        boolean bl = mouseDown = GLFW.glfwGetMouseButton((long)window.method_4490(), (int)0) == 1;
        if (mouseDown) {
            if (draggedContainer == null) {
                hudContainers.values().stream().filter(container -> container != settingsButton).filter(container -> this.isMouseOver((HudContainer)container, mouseX, mouseY)).findFirst().ifPresent(container -> {
                    draggedContainer = container;
                });
            } else {
                UniversalGuiMover.draggedContainer.x = UniversalGuiMover.clampX((int)mouseX, draggedContainer, window);
                UniversalGuiMover.draggedContainer.y = UniversalGuiMover.clampY((int)mouseY, draggedContainer, window);
            }
            dragging = true;
        } else {
            draggedContainer = null;
            dragging = false;
        }
    }

    public static Map<String, HudContainer> getHudContainers() {
        return hudContainers;
    }

    private boolean isMouseOver(HudContainer container, double mouseX, double mouseY) {
        return mouseX >= (double)container.x && mouseX <= (double)(container.x + container.getScaledWidth()) && mouseY >= (double)container.y && mouseY <= (double)(container.y + container.getScaledHeight());
    }

    public static void trackHudContainer(String id, HudContainer container) {
        if (hudContainers.containsKey(id)) {
            HudContainer saved = hudContainers.get(id);
            container.x = saved.x;
            container.y = saved.y;
        }
        hudContainers.put(id, container);
        UniversalGuiMover.clampPosition(container, class_310.method_1551().method_22683());
    }

    public static void clampPosition(HudContainer container, class_1041 window) {
        if (window != null) {
            container.x = UniversalGuiMover.clampX(container.x, container, window);
            container.y = UniversalGuiMover.clampY(container.y, container, window);
        }
    }

    private static int clampX(int x, HudContainer container, class_1041 window) {
        return Math.max(5, Math.min(x, window.method_4486() - container.getScaledWidth() - 5));
    }

    private static int clampY(int y, HudContainer container, class_1041 window) {
        return Math.max(5, Math.min(y, window.method_4502() - container.getScaledHeight() - 5));
    }

    public static HudContainer getHudContainer(String id) {
        return hudContainers.get(id);
    }

    public static float getGlobalTextScale() {
        return globalTextScale;
    }

    public static boolean isDragging() {
        return dragging;
    }

    public static boolean isMovementModeActive() {
        return isMovementMode;
    }

    static {
        lastWindowWidth = 0;
        lastWindowHeight = 0;
        settingsButton = new HudContainer(0, 0, 60, 20, 1);
    }

    @Environment(value=EnvType.CLIENT)
    public static class HudContainer {
        public int x;
        public int y;
        public int baseWidth;
        public int baseHeight;
        public int lineCount;

        public HudContainer(int x, int y, int baseWidth, int baseHeight, int lineCount) {
            this.x = x;
            this.y = y;
            this.baseWidth = baseWidth;
            this.baseHeight = baseHeight;
            this.lineCount = lineCount;
        }

        public int getScaledWidth() {
            return (int)((float)this.baseWidth * globalTextScale);
        }

        public int getScaledHeight() {
            return (int)((float)(this.baseHeight * this.lineCount) * globalTextScale);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class DummyScreen
    extends class_437 {
        public DummyScreen() {
            super(class_2561.method_30163((String)""));
        }

        public boolean method_25421() {
            return true;
        }

        public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            if (keyCode == 256) {
                UniversalGuiMover.toggleMovementMode(class_310.method_1551());
                return true;
            }
            if (KeyBinds.getToggleGUIMovement().method_1417(keyCode, scanCode)) {
                UniversalGuiMover.toggleMovementMode(class_310.method_1551());
                return true;
            }
            if (KeyBinds.getScaleUp().method_1417(keyCode, scanCode)) {
                UniversalGuiMover.updateScale(0.1f, class_310.method_1551());
                return true;
            }
            if (KeyBinds.getScaleDown().method_1417(keyCode, scanCode)) {
                UniversalGuiMover.updateScale(-0.1f, class_310.method_1551());
                return true;
            }
            SettingsInputHandler.handleKeyPress(keyCode, scanCode, 0, 0);
            return super.method_25404(keyCode, scanCode, modifiers);
        }

        public boolean method_25400(char chr, int modifiers) {
            SettingsInputHandler.handleCharInput(chr);
            return super.method_25400(chr, modifiers);
        }
    }
}

