/*
 * Decompiled with CFR 0.152.
 */
package chat.cosmic.client.client;

import chat.cosmic.client.client.RankManager;
import chat.cosmic.client.client.SettingsManager;
import chat.cosmic.client.client.StatusEffectsTracker;
import chat.cosmic.client.client.UniversalGuiMover;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.message.v1.ClientSendMessageEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_1041;
import net.minecraft.class_1271;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class XPBoosterMod
implements ClientModInitializer {
    private static final Map<String, Integer> boosters = new HashMap<String, Integer>();
    private static int tickCounter = 0;
    private static boolean modEnabled = true;
    private static boolean colorAlertsEnabled = true;
    private static final class_2960 XP_BOTTLE_TEXTURE = new class_2960("xpbooster", "textures/gui/xp_bottle.png");
    private static final class_2960 ISLAND_BOOSTER_TEXTURE = new class_2960("xpbooster", "textures/gui/island_booster.png");
    private static final class_2960 FEED_COOLDOWN_TEXTURE = new class_2960("xpbooster", "textures/gui/feed_cooldown.png");
    private static final class_2960 FIX_COOLDOWN_TEXTURE = new class_2960("xpbooster", "textures/gui/fix_cooldown.png");
    private static final class_2960 NEAR_COOLDOWN_TEXTURE = new class_2960("xpbooster", "textures/gui/near_cooldown.png");
    private static final class_2960 ENDER_PEARL_TEXTURE = new class_2960("xpbooster", "textures/gui/ender.png");
    private static final class_2960 HEAL_COOLDOWN_TEXTURE = new class_2960("xpbooster", "textures/gui/heal_cooldown.png");
    private static final int ICON_SIZE = 16;
    private static final int TEXT_COLOR = 0xFFFFFF;
    private static final int Y_OFFSET = 10;
    private static final float NAME_SCALE = 0.7f;
    private static final float TIMER_SCALE = 0.7f;
    static final Map<String, UniversalGuiMover.HudContainer> boosterContainers = new HashMap<String, UniversalGuiMover.HudContainer>();
    private static final Pattern XP_BOOSTER_PATTERN = Pattern.compile("\\(!\\)\\s*(\\d+(?:\\.\\d+)?)x\\s*Island\\s*EXP\\s*Booster\\s*has\\s*been\\s*activated\\s*for\\s*(.+?)!", 2);
    private static final Pattern TREASURE_BOOSTER_PATTERN = Pattern.compile("\\(!\\)\\s*(\\d+(?:\\.\\d+)?)x\\s*Treasure\\s*Chance\\s*Booster\\s*has\\s*been\\s*activated\\s*for\\s*(.+?)!", 2);
    private static int enderPearlCooldown = 0;
    private static final String ENDER_PEARL_KEY = "Ender Pearl";
    private static final String ISLAND_BOOSTER_KEY = "Island XP Booster";
    private static final String TREASURE_BOOSTER_KEY = "Treasure Chance Booster";

    public static void setModEnabled(boolean enabled) {
        modEnabled = enabled;
    }

    public static void setColorAlertsEnabled(boolean enabled) {
        colorAlertsEnabled = enabled;
    }

    public void onInitializeClient() {
        System.out.println("XP Booster Mod Initialized!");
        RankManager.initialize();
        StatusEffectsTracker.initialize();
        boosterContainers.put(ISLAND_BOOSTER_KEY, new UniversalGuiMover.HudContainer(0, 10, 16, 16, 1));
        boosterContainers.put(TREASURE_BOOSTER_KEY, new UniversalGuiMover.HudContainer(0, 10, 16, 16, 1));
        boosterContainers.put("/feed", new UniversalGuiMover.HudContainer(0, 10, 16, 16, 1));
        boosterContainers.put("/heal", new UniversalGuiMover.HudContainer(0, 10, 16, 16, 1));
        boosterContainers.put("/fix", new UniversalGuiMover.HudContainer(0, 10, 16, 16, 1));
        boosterContainers.put("/near", new UniversalGuiMover.HudContainer(0, 10, 16, 16, 1));
        boosterContainers.put(ENDER_PEARL_KEY, new UniversalGuiMover.HudContainer(0, 10, 16, 16, 1));
        boosterContainers.forEach(UniversalGuiMover::trackHudContainer);
        HudRenderCallback.EVENT.register(this::renderHud);
        ClientReceiveMessageEvents.GAME.register(this::handleGameMessage);
        ClientSendMessageEvents.ALLOW_COMMAND.register(cmd -> {
            this.onCommandSent(cmd);
            return true;
        });
        UseItemCallback.EVENT.register((player, world, hand) -> {
            if (player.method_5998(hand).method_7909() == class_1802.field_8634 && enderPearlCooldown == 0) {
                enderPearlCooldown = 60;
            }
            return class_1271.method_22430((Object)player.method_5998(hand));
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (++tickCounter >= 20) {
                tickCounter = 0;
                boosters.replaceAll((k, v) -> v > 0 ? v - 1 : 0);
                boosters.values().removeIf(v -> v <= 0);
                if (enderPearlCooldown > 0) {
                    --enderPearlCooldown;
                }
            }
        });
    }

    private void handleGameMessage(class_2561 text, boolean overlay) {
        Matcher treasureMatcher;
        if (overlay) {
            return;
        }
        String message = text.getString();
        Matcher xpMatcher = XP_BOOSTER_PATTERN.matcher(message);
        if (xpMatcher.find()) {
            String multiplier = xpMatcher.group(1);
            String duration = xpMatcher.group(2);
            int seconds = this.parseDuration(duration);
            if (seconds > 0) {
                String displayName = multiplier + "x Island XP Booster";
                boosters.put(ISLAND_BOOSTER_KEY, seconds);
                System.out.println("Detected XP Booster: " + displayName + " for " + seconds + " seconds");
            }
        }
        if ((treasureMatcher = TREASURE_BOOSTER_PATTERN.matcher(message)).find()) {
            String multiplier = treasureMatcher.group(1);
            String duration = treasureMatcher.group(2);
            int seconds = this.parseDuration(duration);
            if (seconds > 0) {
                String displayName = multiplier + "x Treasure Chance Booster";
                boosters.put(TREASURE_BOOSTER_KEY, seconds);
                System.out.println("Detected Treasure Booster: " + displayName + " for " + seconds + " seconds");
            }
        }
        if (message.contains("Landing location failed") && enderPearlCooldown > 45) {
            enderPearlCooldown = 0;
        }
    }

    private int parseDuration(String duration) {
        duration = duration.trim().toLowerCase();
        int totalSeconds = 0;
        try {
            Pattern timePattern = Pattern.compile("(\\d+)([hms])");
            Matcher matcher = timePattern.matcher(duration);
            while (matcher.find()) {
                int value = Integer.parseInt(matcher.group(1));
                String unit = matcher.group(2);
                if (unit.equals("h")) {
                    totalSeconds += value * 3600;
                    continue;
                }
                if (unit.equals("m")) {
                    totalSeconds += value * 60;
                    continue;
                }
                if (!unit.equals("s")) continue;
                totalSeconds += value;
            }
            if (totalSeconds == 0 && duration.matches("\\d+")) {
                totalSeconds = Integer.parseInt(duration) * 60;
            }
        }
        catch (NumberFormatException e) {
            System.err.println("Failed to parse duration: " + duration);
        }
        return totalSeconds;
    }

    private void onCommandSent(String command) {
        int cd;
        String[] parts = command.toLowerCase().split(" ");
        String base = parts[0];
        if (base.equals("eat")) {
            base = "feed";
        } else if (base.equals("heal")) {
            base = "heal";
        }
        if (base.equals("fix") && parts.length > 1 && parts[1].equals("all")) {
            base = "fix";
        }
        if ((cd = RankManager.getCooldown(base)) <= 0) {
            return;
        }
        String key = "/" + base;
        if (!boosters.containsKey(key)) {
            boosters.put(key, cd);
        }
    }

    private void renderHud(class_332 ctx, float tickDelta) {
        boolean needsCenter;
        if (!modEnabled) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null) {
            return;
        }
        class_1041 w = mc.method_22683();
        float scale = UniversalGuiMover.getGlobalTextScale();
        int iconSz = (int)(16.0f * scale);
        int sw = w.method_4486();
        int sh = w.method_4502();
        boolean force = UniversalGuiMover.isMovementModeActive();
        HashMap<String, Integer> vis = new HashMap<String, Integer>(boosters);
        if (force) {
            boosterContainers.keySet().forEach(k -> vis.putIfAbsent((String)k, 0));
        }
        if (force || enderPearlCooldown > 0) {
            vis.put(ENDER_PEARL_KEY, enderPearlCooldown);
        }
        if (vis.isEmpty()) {
            return;
        }
        boolean bl = needsCenter = !force && boosterContainers.values().stream().anyMatch(c -> c.x == 0);
        if (needsCenter) {
            int startX;
            int total = vis.size();
            int width = total * (iconSz + 20);
            int xPos = startX = sw / 2 - width / 2;
            for (UniversalGuiMover.HudContainer c2 : boosterContainers.values()) {
                if (c2.x != 0) continue;
                c2.x = xPos;
                c2.y = 10;
                xPos += iconSz + 20;
            }
        }
        int maxX = sw - iconSz - 5;
        int minY = 5;
        int maxY = sh - iconSz * 2 - 5;
        for (Map.Entry e : vis.entrySet()) {
            UniversalGuiMover.HudContainer c3;
            String key = (String)e.getKey();
            if (!SettingsManager.getBoosterToggleSettings().getOrDefault(key, true).booleanValue() || (c3 = boosterContainers.get(key)) == null) continue;
            if (!force) {
                c3.x = Math.max(5, Math.min(c3.x, maxX));
                c3.y = Math.max(minY, Math.min(c3.y, maxY));
            }
            int time = (Integer)e.getValue();
            class_2960 tex = this.getBoosterTexture(key);
            String txt = time > 0 ? this.formatCountdown(time) : "Cooldown";
            ctx.method_51448().method_22903();
            ctx.method_51448().method_46416((float)c3.x, (float)c3.y, 0.0f);
            ctx.method_51448().method_22905(scale, scale, 1.0f);
            if (force && time <= 0) {
                ctx.method_51422(1.0f, 1.0f, 1.0f, 0.4f);
            }
            ctx.method_25290(tex, 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
            ctx.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
            if (time > 0 || force) {
                float yOff = 18.0f;
                ctx.method_51448().method_22903();
                ctx.method_51448().method_46416(8.0f, yOff, 0.0f);
                ctx.method_51448().method_22905(0.7f, 0.7f, 1.0f);
                int wName = mc.field_1772.method_1727(key);
                ctx.method_51433(mc.field_1772, key, -wName / 2, 0, 0xFFFFFF, true);
                ctx.method_51448().method_22909();
                ctx.method_51448().method_22903();
                ctx.method_51448().method_46416(8.0f, yOff + 10.0f, 0.0f);
                ctx.method_51448().method_22905(0.7f, 0.7f, 1.0f);
                int wTime = mc.field_1772.method_1727(txt);
                ctx.method_51433(mc.field_1772, txt, -wTime / 2, 0, 0xFFFFFF, true);
                ctx.method_51448().method_22909();
            }
            ctx.method_51448().method_22909();
        }
    }

    private class_2960 getBoosterTexture(String key) {
        return switch (key) {
            case ISLAND_BOOSTER_KEY -> ISLAND_BOOSTER_TEXTURE;
            case TREASURE_BOOSTER_KEY -> ISLAND_BOOSTER_TEXTURE;
            case "/feed" -> FEED_COOLDOWN_TEXTURE;
            case "/heal" -> HEAL_COOLDOWN_TEXTURE;
            case "/fix" -> FIX_COOLDOWN_TEXTURE;
            case "/near" -> NEAR_COOLDOWN_TEXTURE;
            case ENDER_PEARL_KEY -> ENDER_PEARL_TEXTURE;
            default -> XP_BOTTLE_TEXTURE;
        };
    }

    private String formatCountdown(int s) {
        if (s > 60) {
            return s / 60 + "m " + s % 60 + "s";
        }
        return s + "s";
    }
}

