/*
 * Decompiled with CFR 0.152.
 */
package chat.cosmic.client.client.playerheadcooldown;

import chat.cosmic.client.client.SettingsManager;
import chat.cosmic.client.client.UniversalGuiMover;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;

@Environment(value=EnvType.CLIENT)
public class ActivePetEffectsHud {
    private static final class_310 client = class_310.method_1551();
    private static final float TEXT_SCALE = 0.75f;
    private static UniversalGuiMover.HudContainer petHudContainer = null;
    private static final Map<String, ActiveEffect> activeEffects = new HashMap<String, ActiveEffect>();
    private static final Map<String, Map<Integer, Long>> effectDurations = new HashMap<String, Map<Integer, Long>>();
    private static final Map<String, String> petEffects = new HashMap<String, String>();

    private static void initializeEffectDurations() {
        HashMap<Integer, Long> battlePigDurations = new HashMap<Integer, Long>();
        for (int i = 1; i <= 10; ++i) {
            battlePigDurations.put(i, (10L + (long)(i - 1)) * 60L * 1000L);
        }
        effectDurations.put("Battle Pig Pet", battlePigDurations);
        HashMap<Integer, Long> minerMattDurations = new HashMap<Integer, Long>();
        for (int i = 1; i <= 10; ++i) {
            minerMattDurations.put(i, (25L + (long)((i - 1) * 5)) * 1000L);
        }
        effectDurations.put("Miner Matt Pet", minerMattDurations);
        HashMap<Integer, Long> slayerSamDurations = new HashMap<Integer, Long>();
        for (int i = 1; i <= 10; ++i) {
            slayerSamDurations.put(i, (50L + (long)((i - 1) * 10)) * 1000L);
        }
        effectDurations.put("Slayer Sam Pet", slayerSamDurations);
        effectDurations.put("Chaos Cow Pet", battlePigDurations);
        HashMap<Integer, Long> blacksmithDurations = new HashMap<Integer, Long>();
        for (int i = 1; i <= 10; ++i) {
            blacksmithDurations.put(i, 1200000L);
        }
        effectDurations.put("Blacksmith Brandon Pet", blacksmithDurations);
        HashMap<Integer, Long> fishermanDurations = new HashMap<Integer, Long>();
        fishermanDurations.put(1, 160000L);
        fishermanDurations.put(2, 260000L);
        fishermanDurations.put(3, 360000L);
        fishermanDurations.put(4, 460000L);
        fishermanDurations.put(5, 560000L);
        fishermanDurations.put(6, 660000L);
        fishermanDurations.put(7, 760000L);
        fishermanDurations.put(8, 860000L);
        fishermanDurations.put(9, 960000L);
        fishermanDurations.put(10, 1060000L);
        effectDurations.put("Fisherman Fred Pet", fishermanDurations);
        HashMap<Integer, Long> alchemistDurations = new HashMap<Integer, Long>();
        for (int i = 1; i <= 10; ++i) {
            alchemistDurations.put(i, 120000L);
        }
        effectDurations.put("Alchemist Alex Pet", alchemistDurations);
        effectDurations.put("Blood Sheep Pet", battlePigDurations);
        HashMap<Integer, Long> merchantDurations = new HashMap<Integer, Long>();
        for (int i = 1; i <= 10; ++i) {
            merchantDurations.put(i, 900000L);
        }
        effectDurations.put("Merchant Pet", merchantDurations);
        HashMap<Integer, Long> direWolfDurations = new HashMap<Integer, Long>();
        for (int i = 1; i <= 10; ++i) {
            direWolfDurations.put(i, (25L + (long)((i - 1) * 5)) * 1000L);
        }
        effectDurations.put("Dire Wolf Pet", direWolfDurations);
        effectDurations.put("Void Chicken Pet", battlePigDurations);
        HashMap<Integer, Long> lootLlamaDurations = new HashMap<Integer, Long>();
        for (int i = 1; i <= 10; ++i) {
            lootLlamaDurations.put(i, 86400000L);
        }
        effectDurations.put("Loot Llama Pet", lootLlamaDurations);
        HashMap<Integer, Long> barrybeeDurations = new HashMap<Integer, Long>();
        for (int i = 1; i <= 10; ++i) {
            barrybeeDurations.put(i, (10L + (long)i) * 60L * 1000L);
        }
        effectDurations.put("Barry Bee Pet", barrybeeDurations);
        HashMap<Integer, Long> farmerBobDurations = new HashMap<Integer, Long>();
        for (int i = 1; i <= 10; ++i) {
            farmerBobDurations.put(i, (25L + (long)((i - 1) * 5)) * 1000L);
        }
        effectDurations.put("Farmer Bob Pet", farmerBobDurations);
    }

    public static void activatePetEffect(String petName, int level, class_1799 petStack) {
        long duration = ActivePetEffectsHud.getEffectDuration(petName, level);
        if (duration > 0L) {
            activeEffects.put(petName, new ActiveEffect(petName, level, System.currentTimeMillis() + duration, petStack.method_7972()));
        }
    }

    public static boolean isPetTypeActive(String petName) {
        long currentTime = System.currentTimeMillis();
        ActiveEffect effect = activeEffects.get(petName);
        return effect != null && currentTime < effect.endTime;
    }

    public static void initializePetHud() {
        if (petHudContainer == null && client != null && client.method_22683() != null) {
            class_1041 window = client.method_22683();
            int defaultX = window.method_4486() - 140;
            int defaultY = 30;
            petHudContainer = new UniversalGuiMover.HudContainer(defaultX, defaultY, 130, 40, 5);
            UniversalGuiMover.trackHudContainer("pet_hud", petHudContainer);
        }
    }

    public static void render(class_332 context, float tickDelta) {
        if (ActivePetEffectsHud.client.field_1724 == null || ActivePetEffectsHud.client.field_1690.field_1842) {
            return;
        }
        ActivePetEffectsHud.initializePetHud();
        if (petHudContainer == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        activeEffects.entrySet().removeIf(entry -> currentTime >= ((ActiveEffect)entry.getValue()).endTime);
        if (activeEffects.isEmpty()) {
            return;
        }
        int startX = ActivePetEffectsHud.petHudContainer.x;
        int startY = ActivePetEffectsHud.petHudContainer.y;
        int entryHeight = 40;
        ArrayList<ActiveEffect> effects = new ArrayList<ActiveEffect>(activeEffects.values());
        effects.removeIf(effect -> !ActivePetEffectsHud.isPetEnabled(effect.petName));
        if (effects.isEmpty()) {
            return;
        }
        effects.sort(Comparator.comparingLong(e -> e.endTime));
        for (int i = 0; i < effects.size(); ++i) {
            ActiveEffect effect2 = (ActiveEffect)effects.get(i);
            ActivePetEffectsHud.renderEffectEntry(context, effect2, startX, startY + i * entryHeight, currentTime);
        }
    }

    private static boolean isPetEnabled(String petName) {
        String settingKey = "Pet " + petName;
        return SettingsManager.getPetToggleSettings().getOrDefault(settingKey, true);
    }

    private static void renderEffectEntry(class_332 context, ActiveEffect effect, int x, int y, long currentTime) {
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        ActivePetEffectsHud.renderPetIcon(context, effect.petStack, x + 2, y + 2);
        matrices.method_22903();
        matrices.method_22905(0.75f, 0.75f, 1.0f);
        context.method_51439(ActivePetEffectsHud.client.field_1772, (class_2561)class_2561.method_43470((String)(effect.petName + " [Lvl " + effect.level + "]")), (int)((float)(x + 25) / 0.75f), (int)((float)(y + 3) / 0.75f), 0xFFFFFF, true);
        matrices.method_22909();
        String effectDesc = petEffects.getOrDefault(effect.petName, "Active");
        matrices.method_22903();
        matrices.method_22905(0.6f, 0.6f, 1.0f);
        context.method_51439(ActivePetEffectsHud.client.field_1772, (class_2561)class_2561.method_43470((String)effectDesc), (int)((float)(x + 25) / 0.6f), (int)((float)(y + 15) / 0.6f), 0xCCCCCC, true);
        matrices.method_22909();
        long remaining = effect.endTime - currentTime;
        String timeText = ActivePetEffectsHud.formatTime(remaining);
        matrices.method_22903();
        matrices.method_22905(0.75f, 0.75f, 1.0f);
        int timeColor = ActivePetEffectsHud.getTimeColor(remaining);
        context.method_51439(ActivePetEffectsHud.client.field_1772, (class_2561)class_2561.method_43470((String)timeText), (int)((float)(x + 25) / 0.75f), (int)((float)(y + 25) / 0.75f), timeColor, true);
        matrices.method_22909();
        matrices.method_22909();
    }

    private static void renderPetIcon(class_332 context, class_1799 petStack, int x, int y) {
        if (petStack != null && !petStack.method_7960()) {
            context.method_51427(petStack, x, y);
        } else {
            context.method_51439(ActivePetEffectsHud.client.field_1772, (class_2561)class_2561.method_43470((String)"P"), x + 6, y + 6, 0xFFFFFF, true);
        }
    }

    private static long getEffectDuration(String petName, int level) {
        Map<Integer, Long> durations = effectDurations.get(petName);
        if (durations != null) {
            return durations.getOrDefault(level, 0L);
        }
        return 0L;
    }

    private static int getTimeColor(long remainingMs) {
        if (remainingMs < 30000L) {
            return 0xFF5555;
        }
        if (remainingMs < 120000L) {
            return 0xFFFF55;
        }
        return 0x55FF55;
    }

    private static String formatTime(long milliseconds) {
        long seconds = milliseconds / 1000L;
        long minutes = seconds / 60L;
        seconds %= 60L;
        long hours = minutes / 60L;
        minutes %= 60L;
        if (hours > 0L) {
            return String.format("%dh %02dm", hours, minutes);
        }
        if (minutes > 0L) {
            return String.format("%dm %02ds", minutes, seconds);
        }
        return String.format("%ds", seconds);
    }

    public static int getPetLevel(class_1799 stack) {
        class_2487 nbt;
        if (stack.method_7938()) {
            String name = stack.method_7964().getString();
            Pattern pattern = Pattern.compile("\\[LVL (\\d+)\\]");
            Matcher matcher = pattern.matcher(name);
            if (matcher.find()) {
                return Integer.parseInt(matcher.group(1));
            }
        }
        if (stack.method_7985() && (nbt = stack.method_7969()).method_10545("level")) {
            return nbt.method_10550("level");
        }
        return 1;
    }

    static {
        petEffects.put("Battle Pig Pet", "Damage Boost");
        petEffects.put("Miner Matt Pet", "Multiply Mining Island Quest progress by 2x");
        petEffects.put("Slayer Sam Pet", "Increase Mob drops");
        petEffects.put("Chaos Cow Pet", "Damage Boost");
        petEffects.put("Blacksmith Brandon Pet", "Better Gear Repairs");
        petEffects.put("Fisherman Fred Pet", "Increase artifact find chance");
        petEffects.put("Alchemist Alex Pet", "Potion Enhancements");
        petEffects.put("Blood Sheep Pet", "Damage Boost");
        petEffects.put("Merchant Pet", "Better Trading Prices");
        petEffects.put("Dire Wolf Pet", "kill mob faster");
        petEffects.put("Void Chicken Pet", "Damage Boost");
        petEffects.put("Loot Llama Pet", "Extra Loot Drops");
        petEffects.put("Barry Bee Pet", "Bee hives in a 15 area will gain high chance for workers to gather an empty honeycomb");
        petEffects.put("Farmer Bob Pet", "Multiply Farming Island Quest progress by 2x");
        ActivePetEffectsHud.initializeEffectDurations();
    }

    @Environment(value=EnvType.CLIENT)
    private static class ActiveEffect {
        public final String petName;
        public final int level;
        public final long endTime;
        public final class_1799 petStack;

        public ActiveEffect(String petName, int level, long endTime, class_1799 petStack) {
            this.petName = petName;
            this.level = level;
            this.endTime = endTime;
            this.petStack = petStack;
        }
    }
}

