/*
 * Decompiled with CFR 0.152.
 */
package chat.cosmic.client.client.playerheadcooldown;

import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2561;

@Environment(value=EnvType.CLIENT)
public class PetManager {
    private static final Map<String, Long> petCooldowns = new HashMap<String, Long>();

    public static boolean isPet(class_1799 stack) {
        if (stack.method_7909() != class_1802.field_8575) {
            return false;
        }
        String petName = PetManager.getPetName(stack);
        return petName != null && petCooldowns.containsKey(petName);
    }

    public static String getPetName(class_1799 stack) {
        class_2487 display;
        Object nbt;
        if (!stack.method_7938() && !stack.method_7985()) {
            return null;
        }
        String displayName = null;
        if (stack.method_7938()) {
            class_2561 displayNameText = stack.method_7964();
            displayName = displayNameText.getString();
        } else if (stack.method_7985() && (nbt = stack.method_7969()) != null && nbt.method_10545("display") && (display = nbt.method_10562("display")).method_10545("Name")) {
            String nameJson = display.method_10558("Name");
            displayName = PetManager.extractTextFromJson(nameJson);
        }
        if (displayName != null) {
            nbt = petCooldowns.keySet().iterator();
            while (nbt.hasNext()) {
                String petName = (String)nbt.next();
                if (!displayName.contains(petName)) continue;
                return petName;
            }
        }
        if (stack.method_7985() && (nbt = stack.method_7969()).method_10545("petType")) {
            String petType = nbt.method_10558("petType");
            return PetManager.getPetNameFromType(petType);
        }
        return null;
    }

    private static String extractTextFromJson(String json) {
        if (json.contains("\"text\"")) {
            try {
                int start = json.indexOf("\"text\":\"") + 8;
                int end = json.indexOf("\"", start);
                if (start >= 8 && end > start) {
                    return json.substring(start, end);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return json;
    }

    private static String getPetNameFromType(String petType) {
        switch (petType) {
            case "LOOT_LLAMA": {
                return "Loot Llama Pet";
            }
            case "BATTLE_PIG": {
                return "Battle Pig Pet";
            }
            case "MINER_MATT": {
                return "Miner Matt Pet";
            }
            case "SLAYER_SAM": {
                return "Slayer Sam Pet";
            }
            case "CHAOS_COW": {
                return "Chaos Cow Pet";
            }
            case "BLACKSMITH_BRANDON": {
                return "Blacksmith Brandon Pet";
            }
            case "FISHERMAN_FRED": {
                return "Fisherman Fred Pet";
            }
            case "ALCHEMIST_ALEX": {
                return "Alchemist Alex Pet";
            }
            case "BLOOD_SHEEP": {
                return "Blood Sheep Pet";
            }
            case "MERCHANT": {
                return "Merchant Pet";
            }
            case "DIRE_WOLF": {
                return "Dire Wolf Pet";
            }
            case "VOID_CHICKEN": {
                return "Void Chicken Pet";
            }
            case "BARRY_BEE": {
                return "Barry Bee Pet";
            }
            case "FARMER": {
                return "Farmer Bob Pet";
            }
        }
        return null;
    }

    public static long getCooldownDuration(String petName) {
        return petCooldowns.getOrDefault(petName, 0L);
    }

    public static long getCooldownDuration(class_1799 stack) {
        String petName = PetManager.getPetName(stack);
        return petName != null ? petCooldowns.getOrDefault(petName, 0L) : 0L;
    }

    static {
        petCooldowns.put("Loot Llama Pet", 86400000L);
        petCooldowns.put("Battle Pig Pet", 3600000L);
        petCooldowns.put("Miner Matt Pet", 900000L);
        petCooldowns.put("Slayer Sam Pet", 900000L);
        petCooldowns.put("Chaos Cow Pet", 3600000L);
        petCooldowns.put("Blacksmith Brandon Pet", 1200000L);
        petCooldowns.put("Fisherman Fred Pet", 600000L);
        petCooldowns.put("Alchemist Alex Pet", 480000L);
        petCooldowns.put("Blood Sheep Pet", 3600000L);
        petCooldowns.put("Merchant Pet", 900000L);
        petCooldowns.put("Dire Wolf Pet", 900000L);
        petCooldowns.put("Void Chicken Pet", 3600000L);
        petCooldowns.put("Barry Bee Pet", 10800000L);
        petCooldowns.put("Farmer Bob Pet", 900000L);
    }
}

