/*
 * Decompiled with CFR 0.152.
 */
package chat.cosmic.client.client.playerheadcooldown;

import chat.cosmic.client.client.playerheadcooldown.ActivePetEffectsHud;
import chat.cosmic.client.client.playerheadcooldown.PetManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class PlayerHeadCooldownMod
implements ClientModInitializer {
    private static final float TEXT_SCALE = 0.6f;
    private static final class_310 client = class_310.method_1551();
    private static final Pattern COOLDOWN_PATTERN = Pattern.compile("PET: Ability on cooldown: (\\d+)m (\\d+)s");
    private static final Map<String, Long> itemCooldowns = new HashMap<String, Long>();
    private static String lastActivatedPet = null;
    private static long lastActivationTime = 0L;

    public void onInitializeClient() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> this.updateCooldowns());
        HudRenderCallback.EVENT.register((context, tickDelta) -> this.renderCooldownOverlay(context, tickDelta));
        HudRenderCallback.EVENT.register((context, tickDelta) -> ActivePetEffectsHud.render(context, tickDelta));
    }

    public static void handlePetActivationMessage(String petName) {
        String stackPetName;
        class_1799 stack;
        int i;
        if (PlayerHeadCooldownMod.client.field_1724 == null) {
            return;
        }
        System.out.println("Detected pet activation: " + petName);
        class_1799 foundPet = null;
        int foundSlot = -1;
        for (i = 0; i < PlayerHeadCooldownMod.client.field_1724.method_31548().method_5439(); ++i) {
            stack = PlayerHeadCooldownMod.client.field_1724.method_31548().method_5438(i);
            if (!PlayerHeadCooldownMod.isPet(stack) || (stackPetName = PlayerHeadCooldownMod.getPetName(stack)) == null || !stackPetName.equals(petName)) continue;
            foundPet = stack;
            foundSlot = i;
            break;
        }
        if (foundPet == null) {
            for (i = 0; i < PlayerHeadCooldownMod.client.field_1724.method_31548().method_5439(); ++i) {
                stack = PlayerHeadCooldownMod.client.field_1724.method_31548().method_5438(i);
                if (!PlayerHeadCooldownMod.isPet(stack) || (stackPetName = PlayerHeadCooldownMod.getPetName(stack)) == null || !stackPetName.contains(petName.replace(" Pet", ""))) continue;
                foundPet = stack;
                foundSlot = i;
                break;
            }
        }
        if (foundPet != null) {
            int petLevel = ActivePetEffectsHud.getPetLevel(foundPet);
            ActivePetEffectsHud.activatePetEffect(petName, petLevel, foundPet);
            ActivePetEffectsHud.initializePetHud();
            PlayerHeadCooldownMod.startCooldown(foundPet, foundSlot);
            System.out.println("Activated HUD for: " + petName + " Level: " + petLevel);
        } else {
            System.out.println("Could not find pet in inventory: " + petName);
        }
    }

    public static void startCooldown(class_1799 pet, int slotIndex) {
        String persistentId;
        if (PetManager.isPet(pet) && (persistentId = PlayerHeadCooldownMod.getPersistentItemId(pet)) != null) {
            long cooldownDuration = PetManager.getCooldownDuration(pet);
            itemCooldowns.put(persistentId, System.currentTimeMillis() + cooldownDuration);
            if (!pet.method_7985()) {
                pet.method_7980(new class_2487());
            }
            pet.method_7969().method_10544("lastUsed", System.currentTimeMillis());
            lastActivatedPet = PlayerHeadCooldownMod.getPetName(pet);
            lastActivationTime = System.currentTimeMillis();
        }
    }

    public static boolean isOnCooldown(class_1799 stack) {
        if (PetManager.isPet(stack)) {
            Long endTime;
            String persistentId = PlayerHeadCooldownMod.getPersistentItemId(stack);
            if (persistentId != null && (endTime = itemCooldowns.get(persistentId)) != null && System.currentTimeMillis() < endTime) {
                return true;
            }
            long lastUsed = PlayerHeadCooldownMod.getLastUsedTime(stack);
            if (lastUsed > 0L) {
                long cooldownDuration = PetManager.getCooldownDuration(stack);
                return System.currentTimeMillis() < lastUsed + cooldownDuration;
            }
        }
        return false;
    }

    public static long getRemainingCooldown(class_1799 stack) {
        if (PetManager.isPet(stack)) {
            Long endTime;
            String persistentId = PlayerHeadCooldownMod.getPersistentItemId(stack);
            if (persistentId != null && (endTime = itemCooldowns.get(persistentId)) != null) {
                long remaining = endTime - System.currentTimeMillis();
                return Math.max(0L, remaining);
            }
            long lastUsed = PlayerHeadCooldownMod.getLastUsedTime(stack);
            if (lastUsed > 0L) {
                long cooldownDuration = PetManager.getCooldownDuration(stack);
                long remaining = lastUsed + cooldownDuration - System.currentTimeMillis();
                return Math.max(0L, remaining);
            }
        }
        return 0L;
    }

    public static boolean isPet(class_1799 stack) {
        return PetManager.isPet(stack);
    }

    public static String getPetName(class_1799 stack) {
        return PetManager.getPetName(stack);
    }

    private static String getPersistentItemId(class_1799 stack) {
        if (!stack.method_7985()) {
            return null;
        }
        class_2487 nbt = stack.method_7969();
        if (nbt.method_10545("c_iid")) {
            return "c_iid_" + nbt.method_10537("c_iid");
        }
        if (nbt.method_10545("petType")) {
            String petType = nbt.method_10558("petType");
            String skullId = "unknown";
            if (nbt.method_10545("SkullOwner")) {
                class_2487 skullOwner = nbt.method_10562("SkullOwner");
                if (skullOwner.method_10545("Id")) {
                    skullId = skullOwner.method_25926("Id").toString();
                } else if (skullOwner.method_10545("Name")) {
                    skullId = skullOwner.method_10558("Name");
                }
            }
            return skullId + "_" + petType;
        }
        String petName = PetManager.getPetName(stack);
        if (petName != null) {
            return "name_" + petName + "_" + System.identityHashCode(stack);
        }
        return null;
    }

    public static long getLastUsedTime(class_1799 stack) {
        class_2487 nbt;
        if (stack.method_7985() && (nbt = stack.method_7969()).method_10545("lastUsed")) {
            return nbt.method_10537("lastUsed");
        }
        return 0L;
    }

    public static void handleServerCooldownMessage(long remainingCooldownMs) {
        class_1799 stack;
        int i;
        if (PlayerHeadCooldownMod.client.field_1724 == null) {
            return;
        }
        if (lastActivatedPet != null && System.currentTimeMillis() - lastActivationTime < 5000L) {
            for (i = 0; i < PlayerHeadCooldownMod.client.field_1724.method_31548().method_5439(); ++i) {
                stack = PlayerHeadCooldownMod.client.field_1724.method_31548().method_5438(i);
                if (!PlayerHeadCooldownMod.isPet(stack) || !lastActivatedPet.equals(PlayerHeadCooldownMod.getPetName(stack))) continue;
                PlayerHeadCooldownMod.setCooldownFromServer(stack, remainingCooldownMs);
                return;
            }
        }
        for (i = 0; i < PlayerHeadCooldownMod.client.field_1724.method_31548().method_5439(); ++i) {
            stack = PlayerHeadCooldownMod.client.field_1724.method_31548().method_5438(i);
            if (!PetManager.isPet(stack) || !PlayerHeadCooldownMod.isOnCooldown(stack)) continue;
            PlayerHeadCooldownMod.setCooldownFromServer(stack, remainingCooldownMs);
            break;
        }
    }

    private static void setCooldownFromServer(class_1799 stack, long remainingCooldownMs) {
        String persistentId = PlayerHeadCooldownMod.getPersistentItemId(stack);
        if (persistentId != null) {
            long endTime = System.currentTimeMillis() + remainingCooldownMs;
            itemCooldowns.put(persistentId, endTime);
            if (!stack.method_7985()) {
                stack.method_7980(new class_2487());
            }
            stack.method_7969().method_10544("lastUsed", System.currentTimeMillis());
        }
    }

    public static void renderInventoryCooldown(class_332 context, class_1799 stack, int x, int y) {
        if (PlayerHeadCooldownMod.isOnCooldown(stack)) {
            long remaining = PlayerHeadCooldownMod.getRemainingCooldown(stack);
            String timeText = PlayerHeadCooldownMod.formatTime(remaining);
            int centerX = x + 8;
            int centerY = y + 8;
            context.method_51448().method_22903();
            context.method_51448().method_46416((float)centerX, (float)centerY, 300.0f);
            context.method_51448().method_22905(0.6f, 0.6f, 1.0f);
            class_327 textRenderer = PlayerHeadCooldownMod.client.field_1772;
            int textWidth = textRenderer.method_1727(timeText);
            Objects.requireNonNull(textRenderer);
            int textHeight = 9;
            int drawX = -textWidth / 2;
            int drawY = -textHeight / 2;
            for (int ox = -1; ox <= 1; ++ox) {
                for (int oy = -1; oy <= 1; ++oy) {
                    if (ox == 0 && oy == 0) continue;
                    context.method_51433(textRenderer, timeText, drawX + ox, drawY + oy, 0, false);
                }
            }
            context.method_51433(textRenderer, timeText, drawX, drawY, -43691, false);
            context.method_51448().method_22909();
        }
    }

    private void updateCooldowns() {
        long currentTime = System.currentTimeMillis();
        Iterator<Map.Entry<String, Long>> iterator = itemCooldowns.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Long> entry = iterator.next();
            if (currentTime < entry.getValue()) continue;
            iterator.remove();
        }
    }

    private void renderCooldownOverlay(class_332 context, float tickDelta) {
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        if (player == null) {
            return;
        }
        if (!(client.field_1755 instanceof class_465)) {
            for (int i = 0; i < 9; ++i) {
                class_1799 stack = player.method_31548().method_5438(i);
                if (!PlayerHeadCooldownMod.isOnCooldown(stack)) continue;
                long remaining = PlayerHeadCooldownMod.getRemainingCooldown(stack);
                String timeText = PlayerHeadCooldownMod.formatTime(remaining);
                int screenWidth = client.method_22683().method_4486();
                int screenHeight = client.method_22683().method_4502();
                int hotbarStartX = screenWidth / 2 - 91;
                int hotbarY = screenHeight - 20;
                int slotX = hotbarStartX + i * 20;
                int slotY = hotbarY;
                this.drawCooldownText(context, timeText, slotX, slotY, 20);
            }
        }
    }

    private void drawCooldownText(class_332 context, String timeText, int x, int y, int slotSize) {
        int centerX = x + slotSize / 2;
        int centerY = y + slotSize / 2;
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)centerX, (float)centerY, 500.0f);
        context.method_51448().method_22905(0.6f, 0.6f, 1.0f);
        class_327 textRenderer = PlayerHeadCooldownMod.client.field_1772;
        int textWidth = textRenderer.method_1727(timeText);
        Objects.requireNonNull(textRenderer);
        int textHeight = 9;
        int drawX = -textWidth / 2;
        int drawY = -textHeight / 2;
        for (int ox = -1; ox <= 1; ++ox) {
            for (int oy = -1; oy <= 1; ++oy) {
                if (ox == 0 && oy == 0) continue;
                context.method_51433(textRenderer, timeText, drawX + ox, drawY + oy, 0, false);
            }
        }
        context.method_51433(textRenderer, timeText, drawX, drawY, -43691, false);
        context.method_51448().method_22909();
    }

    public static String formatTime(long milliseconds) {
        long seconds = milliseconds / 1000L;
        long minutes = seconds / 60L;
        seconds %= 60L;
        if (minutes > 0L) {
            return String.format("%d:%02d", minutes, seconds);
        }
        if (seconds > 0L) {
            return String.format("%ds", seconds);
        }
        return "Ready!";
    }

    public static Pattern getCooldownPattern() {
        return COOLDOWN_PATTERN;
    }
}

