/*
 * Decompiled with CFR 0.152.
 */
package chat.cosmic.client.client.playerheadcooldown.mixin;

import chat.cosmic.client.client.playerheadcooldown.PlayerHeadCooldownMod;
import java.util.regex.Matcher;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_338;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_338.class})
public class ChatMessageMixin {
    @Inject(method={"addMessage(Lnet/minecraft/text/Text;)V"}, at={@At(value="HEAD")})
    private void onChatMessage(class_2561 message, CallbackInfo ci) {
        Matcher matcher;
        String petName;
        String messageText = message.getString();
        if (messageText.startsWith("PET:") && (petName = this.extractPetNameFromMessage(messageText)) != null) {
            PlayerHeadCooldownMod.handlePetActivationMessage(petName);
        }
        if ((matcher = PlayerHeadCooldownMod.getCooldownPattern().matcher(messageText)).find()) {
            int minutes = Integer.parseInt(matcher.group(1));
            int seconds = Integer.parseInt(matcher.group(2));
            long totalCooldownMs = ((long)minutes * 60L + (long)seconds) * 1000L;
            PlayerHeadCooldownMod.handleServerCooldownMessage(totalCooldownMs);
        }
    }

    private String extractPetNameFromMessage(String message) {
        try {
            String content = message.substring(5).trim();
            int bracketIndex = content.indexOf(91);
            if (bracketIndex > 0) {
                String petNamePart = content.substring(0, bracketIndex).trim();
                return this.mapToInternalPetName(petNamePart);
            }
        }
        catch (Exception e) {
            return this.extractPetNameFallback(message);
        }
        return null;
    }

    private String mapToInternalPetName(String petNameFromMessage) {
        if (petNameFromMessage.contains("Dire Wolf")) {
            return "Dire Wolf Pet";
        }
        if (petNameFromMessage.contains("Miner Matt")) {
            return "Miner Matt Pet";
        }
        if (petNameFromMessage.contains("Farmer Bob")) {
            return "Farmer Bob Pet";
        }
        if (petNameFromMessage.contains("Battle Pig")) {
            return "Battle Pig Pet";
        }
        if (petNameFromMessage.contains("Slayer Sam")) {
            return "Slayer Sam Pet";
        }
        if (petNameFromMessage.contains("Chaos Cow")) {
            return "Chaos Cow Pet";
        }
        if (petNameFromMessage.contains("Blacksmith Brandon")) {
            return "Blacksmith Brandon Pet";
        }
        if (petNameFromMessage.contains("Fisherman Fred")) {
            return "Fisherman Fred Pet";
        }
        if (petNameFromMessage.contains("Alchemist Alex")) {
            return "Alchemist Alex Pet";
        }
        if (petNameFromMessage.contains("Blood Sheep")) {
            return "Blood Sheep Pet";
        }
        if (petNameFromMessage.contains("Merchant")) {
            return "Merchant Pet";
        }
        if (petNameFromMessage.contains("Void Chicken")) {
            return "Void Chicken Pet";
        }
        if (petNameFromMessage.contains("Loot Llama")) {
            return "Loot Llama Pet";
        }
        if (petNameFromMessage.contains("Barry Bee")) {
            return "Barry Bee Pet";
        }
        return petNameFromMessage + " Pet";
    }

    private String extractPetNameFallback(String message) {
        String[] knownPets;
        for (String pet : knownPets = new String[]{"Dire Wolf", "Miner Matt", "Farmer Bob", "Battle Pig", "Slayer Sam", "Chaos Cow", "Blacksmith Brandon", "Fisherman Fred", "Alchemist Alex", "Blood Sheep", "Merchant", "Void Chicken", "Loot Llama", "Barry Bee"}) {
            if (!message.contains(pet)) continue;
            return pet + " Pet";
        }
        return null;
    }
}

