/*
 * Decompiled with CFR 0.152.
 */
package chat.cosmic.client.client;

import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class xpwithdraw
implements ClientModInitializer {
    private static final Map<Character, Long> MULTIPLIERS = new HashMap<Character, Long>();

    public void onInitializeClient() {
        System.out.println("[CosmicV2] XPWithdraw mod initialized!");
        class_310 client = class_310.method_1551();
        if (client != null && client.field_1724 != null) {
            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7a[XPWithdraw] Client mod loaded."), false);
        }
    }

    public static boolean handleOutgoingCommand(String command) {
        if (command == null || command.isEmpty()) {
            return false;
        }
        String trimmed = command.trim();
        if (trimmed.startsWith("xpbottle ") || trimmed.startsWith("xpb ")) {
            try {
                String[] parts = trimmed.split(" ", 2);
                if (parts.length < 2) {
                    return false;
                }
                String base = parts[0];
                String amountStr = parts[1].trim();
                xpwithdraw instance = new xpwithdraw();
                long amount = instance.parseShorthandNumber(amountStr);
                String newCommand = (String)(base.equals("xpb") ? "xpbottle " : base + " ") + amount;
                class_310 client = class_310.method_1551();
                if (client.field_1724 != null && client.method_1562() != null) {
                    client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a7a[XPWithdraw] Converted " + amountStr + " \u2192 " + amount)), false);
                    client.method_1562().method_45730(newCommand);
                    System.out.println("[XPWithdraw] Rewrote " + command + " \u2192 " + newCommand);
                }
                return true;
            }
            catch (Exception e) {
                class_310 client = class_310.method_1551();
                if (client.field_1724 != null) {
                    client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7c[XPWithdraw] Invalid number format."), false);
                }
                System.err.println("[XPWithdraw] Invalid command: " + command);
                return true;
            }
        }
        return false;
    }

    private long parseShorthandNumber(String input) {
        if (input == null || input.trim().isEmpty()) {
            throw new NumberFormatException("Empty input");
        }
        String cleaned = input.trim().toLowerCase().replace(",", "").replace(" ", "");
        try {
            if (cleaned.matches(".*[kmbt]$")) {
                char suffix = cleaned.charAt(cleaned.length() - 1);
                double number = Double.parseDouble(cleaned.substring(0, cleaned.length() - 1));
                Long multiplier = MULTIPLIERS.get(Character.valueOf(suffix));
                if (multiplier == null) {
                    throw new NumberFormatException("Unknown suffix: " + suffix);
                }
                long result = (long)(number * (double)multiplier.longValue());
                if (result <= 0L || result > 100000000000L) {
                    throw new NumberFormatException("Amount out of range");
                }
                return result;
            }
            long result = Long.parseLong(cleaned);
            if (result <= 0L) {
                throw new NumberFormatException("Amount must be positive");
            }
            return result;
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Invalid number: " + input);
        }
    }

    static {
        MULTIPLIERS.put(Character.valueOf('k'), 1000L);
        MULTIPLIERS.put(Character.valueOf('m'), 1000000L);
        MULTIPLIERS.put(Character.valueOf('b'), 1000000000L);
        MULTIPLIERS.put(Character.valueOf('t'), 1000000000000L);
    }
}

