/*
 * Decompiled with CFR 0.152.
 */
package chat.cosmic.client;

import chat.cosmic.client.client.KeyBinds.KeyBinds;
import chat.cosmic.client.client.SettingsManager;
import chat.cosmic.client.client.UniversalGuiMover;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_640;

@Environment(value=EnvType.CLIENT)
public class join
implements ClientModInitializer {
    public static boolean NOTIFICATIONS_ENABLED = false;
    public static boolean GUI_VISIBLE = false;
    public static Set<String> onlinePlayers = new HashSet<String>();
    public static Set<String> ignoredPlayers = new HashSet<String>();
    public static Map<String, String> playerColors = new HashMap<String, String>();
    public static int MAX_PLAYERS_PER_COLUMN = 15;
    private static final UniversalGuiMover.HudContainer hudContainer = new UniversalGuiMover.HudContainer(10, 10, 100, 40, 1);
    private static final File configFile = new File("config/untitled20_mod.properties");
    private static boolean isChangingDimension = false;
    private static long dimensionChangeTime = 0L;
    private static final long DIMENSION_CHANGE_COOLDOWN = 5000L;
    private static String currentDimension = "";
    private static boolean hasShownInitialList = false;

    public void onInitializeClient() {
        SettingsManager.initialize();
        KeyBinds.registerKeyBinds();
        UniversalGuiMover.trackHudContainer("playerListHud", hudContainer);
        this.loadConfig();
        ClientLifecycleEvents.CLIENT_STOPPING.register(client -> join.saveConfig());
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"player").then(ClientCommandManager.literal((String)"list").then(ClientCommandManager.literal((String)"ignore").then(ClientCommandManager.argument((String)"username", (ArgumentType)StringArgumentType.string()).executes(context -> {
                String username = StringArgumentType.getString((CommandContext)context, (String)"username").toLowerCase();
                this.toggleIgnoredPlayer(username);
                ((FabricClientCommandSource)context.getSource()).sendFeedback(class_2561.method_30163((String)(username + " is now " + (this.isIgnored(username) ? "ignored" : "unignored"))));
                return 1;
            })))));
            String[] colors = new String[]{"pr", "pg", "pdb"};
            String[] colorNames = new String[]{"red", "green", "aqua"};
            int i = 0;
            while (i < colors.length) {
                int index = i++;
                dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)colors[index]).then(ClientCommandManager.argument((String)"username", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
                    this.getOnlinePlayerNames().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
                    return builder.buildFuture();
                }).executes(context -> {
                    String username = StringArgumentType.getString((CommandContext)context, (String)"username").toLowerCase();
                    this.setPlayerColor(username, colorNames[index]);
                    ((FabricClientCommandSource)context.getSource()).sendFeedback(class_2561.method_30163((String)(username + "'s name color set to " + colorNames[index])));
                    return 1;
                })));
            }
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"prr").executes(context -> {
                this.resetPlayerColors();
                ((FabricClientCommandSource)context.getSource()).sendFeedback(class_2561.method_30163((String)"Reset all player colors"));
                return 1;
            }));
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"pw").then(ClientCommandManager.argument((String)"username", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
                this.getOnlinePlayerNames().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
                return builder.buildFuture();
            }).executes(context -> {
                String username = StringArgumentType.getString((CommandContext)context, (String)"username").toLowerCase();
                this.resetPlayerColor(username);
                ((FabricClientCommandSource)context.getSource()).sendFeedback(class_2561.method_30163((String)(username + "'s color reset")));
                return 1;
            })));
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"setmaxplayers").then(ClientCommandManager.argument((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1, (int)50)).executes(context -> {
                int newCount;
                MAX_PLAYERS_PER_COLUMN = newCount = IntegerArgumentType.getInteger((CommandContext)context, (String)"count");
                ((FabricClientCommandSource)context.getSource()).sendFeedback(class_2561.method_30163((String)("Max players per column set to " + newCount)));
                join.saveConfig();
                return 1;
            })));
        });
        ClientTickEvents.END_CLIENT_TICK.register(this::onClientTick);
        HudRenderCallback.EVENT.register(this::onHudRender);
    }

    private boolean isRestrictedDimension() {
        return currentDimension.equals("minecraft:overworld") || currentDimension.equals("your_spawn_dimension_id");
    }

    private List<String> getOnlinePlayerNames() {
        if (this.isRestrictedDimension()) {
            return Collections.emptyList();
        }
        ArrayList<String> playerNames = new ArrayList<String>();
        if (class_310.method_1551().method_1562() != null) {
            for (class_640 entry : class_310.method_1551().method_1562().method_2880()) {
                String username = entry.method_2966().getName();
                if (this.isIgnored(username)) continue;
                playerNames.add(username);
            }
        }
        return playerNames;
    }

    private void onClientTick(class_310 client) {
        if (client.field_1724 == null) {
            return;
        }
        if (KeyBinds.getToggleNotifications().method_1436()) {
            NOTIFICATIONS_ENABLED = !NOTIFICATIONS_ENABLED;
            SettingsManager.getToggleSettings().put("Show Notifications", NOTIFICATIONS_ENABLED);
            SettingsManager.saveSettings();
            client.field_1724.method_7353(class_2561.method_30163((String)("Notifications " + (NOTIFICATIONS_ENABLED ? "enabled" : "disabled"))), false);
        }
        if (KeyBinds.getTogglePlayerList().method_1436()) {
            GUI_VISIBLE = !GUI_VISIBLE;
            SettingsManager.getToggleSettings().put("Show Player List", GUI_VISIBLE);
            SettingsManager.saveSettings();
            client.field_1724.method_7353(class_2561.method_30163((String)("GUI " + (GUI_VISIBLE ? "enabled" : "disabled"))), false);
        }
        if (client.method_1562() == null) {
            return;
        }
        String newDimension = "";
        if (client.field_1687 != null && client.field_1687.method_27983() != null) {
            newDimension = client.field_1687.method_27983().method_29177().toString();
        }
        if (!newDimension.equals(currentDimension) && !currentDimension.isEmpty()) {
            isChangingDimension = true;
            dimensionChangeTime = System.currentTimeMillis();
            onlinePlayers.clear();
            hasShownInitialList = false;
        }
        currentDimension = newDimension;
        if (isChangingDimension && System.currentTimeMillis() - dimensionChangeTime > 5000L) {
            isChangingDimension = false;
        }
        if (isChangingDimension || this.isRestrictedDimension()) {
            return;
        }
        HashSet<String> currentPlayers = new HashSet<String>();
        boolean isFirstConnect = onlinePlayers.isEmpty();
        for (class_640 entry : client.method_1562().method_2880()) {
            String username = entry.method_2966().getName().toLowerCase();
            if (this.isIgnored(username) || !this.isValidPlayer(username) || username.equalsIgnoreCase(client.field_1724.method_5477().getString())) continue;
            currentPlayers.add(username);
        }
        if (NOTIFICATIONS_ENABLED && !hasShownInitialList && !currentPlayers.isEmpty()) {
            this.showInitialPlayerList(client, currentPlayers);
            hasShownInitialList = true;
        }
        if (NOTIFICATIONS_ENABLED && !isFirstConnect) {
            for (String player : currentPlayers) {
                if (onlinePlayers.contains(player)) continue;
                client.field_1724.method_7353(class_2561.method_30163((String)"------------------------------------------"), false);
                client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a76\u00a7l" + player + " has joined your world")), false);
                client.field_1724.method_7353(class_2561.method_30163((String)"------------------------------------------"), false);
            }
            for (String player : onlinePlayers) {
                if (currentPlayers.contains(player)) continue;
                client.field_1724.method_7353(class_2561.method_30163((String)"------------------------------------------"), false);
                client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a7c\u00a7l" + player + " has left your world")), false);
                client.field_1724.method_7353(class_2561.method_30163((String)"------------------------------------------"), false);
            }
        }
        onlinePlayers = currentPlayers;
    }

    private void showInitialPlayerList(class_310 client, Set<String> players) {
        if (players.isEmpty()) {
            return;
        }
        ArrayList<String> playerList = new ArrayList<String>(players);
        Collections.sort(playerList);
        StringBuilder playerNames = new StringBuilder();
        for (int i = 0; i < playerList.size(); ++i) {
            String player = (String)playerList.get(i);
            String color = playerColors.get(player.toLowerCase());
            if (color != null) {
                switch (color) {
                    case "red": {
                        playerNames.append("\u00a7c");
                        break;
                    }
                    case "green": {
                        playerNames.append("\u00a7a");
                        break;
                    }
                    case "aqua": {
                        playerNames.append("\u00a7b");
                        break;
                    }
                    default: {
                        playerNames.append("\u00a7f");
                        break;
                    }
                }
            } else {
                playerNames.append("\u00a7f");
            }
            playerNames.append(player);
            if (i >= playerList.size() - 1) continue;
            playerNames.append("\u00a77, ");
        }
        client.field_1724.method_7353(class_2561.method_30163((String)"\u00a7e\u00a7lPlayers in your world are: "), false);
        client.field_1724.method_7353((class_2561)class_2561.method_43470((String)playerNames.toString()), false);
        client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a7e\u00a7lTotal: " + players.size() + " player(s)")), false);
    }

    private void onHudRender(class_332 context, float tickDelta) {
        if (GUI_VISIBLE && !this.isRestrictedDimension() && class_310.method_1551().field_1724 != null) {
            int textColor;
            String player;
            int index;
            int row;
            int columnX;
            int col;
            class_310 client = class_310.method_1551();
            UniversalGuiMover.HudContainer container = UniversalGuiMover.getHudContainer("playerListHud");
            if (container == null) {
                return;
            }
            UniversalGuiMover.clampPosition(container, client.method_22683());
            float scale = UniversalGuiMover.getGlobalTextScale();
            int lineHeight = 12;
            int maxPlayersPerColumn = MAX_PLAYERS_PER_COLUMN;
            int columnWidth = 120;
            HashSet<String> displayPlayers = new HashSet<String>();
            if (client.method_1562() != null) {
                for (class_640 entry : client.method_1562().method_2880()) {
                    String username = entry.method_2966().getName().toLowerCase();
                    if (this.isIgnored(username) || !this.isValidPlayer(username)) continue;
                    displayPlayers.add(username);
                }
            }
            context.method_51448().method_22903();
            context.method_51448().method_46416((float)(container.x + 3), (float)(container.y + 3), 0.0f);
            context.method_51448().method_22905(scale, scale, 1.0f);
            context.method_51439(client.field_1772, (class_2561)class_2561.method_43470((String)("Players Online: " + displayPlayers.size())).method_27694(s -> s.method_10982(Boolean.valueOf(true))), 0, -lineHeight, 0xFFFFFF, true);
            ArrayList sortedPlayers = new ArrayList(displayPlayers);
            sortedPlayers.sort((a, b) -> {
                int priorityB;
                String colorA = playerColors.getOrDefault(a.toLowerCase(), "default");
                String colorB = playerColors.getOrDefault(b.toLowerCase(), "default");
                int priorityA = this.getColorPriority(colorA);
                return priorityA != (priorityB = this.getColorPriority(colorB)) ? Integer.compare(priorityB, priorityA) : a.compareToIgnoreCase((String)b);
            });
            ArrayList<String> commandPlayers = new ArrayList<String>();
            ArrayList<String> otherPlayers = new ArrayList<String>();
            for (String player2 : sortedPlayers) {
                String color = playerColors.get(player2.toLowerCase());
                if (color != null && !color.equals("default")) {
                    commandPlayers.add(player2);
                    continue;
                }
                otherPlayers.add(player2);
            }
            int commandColumns = (int)Math.ceil((double)commandPlayers.size() / (double)maxPlayersPerColumn);
            int otherColumns = (int)Math.ceil((double)otherPlayers.size() / (double)maxPlayersPerColumn);
            for (col = 0; col < commandColumns; ++col) {
                columnX = col * columnWidth;
                for (row = 0; row < maxPlayersPerColumn && (index = col * maxPlayersPerColumn + row) < commandPlayers.size(); ++row) {
                    player = (String)commandPlayers.get(index);
                    String color = playerColors.get(player.toLowerCase());
                    textColor = this.getCommandColor(color);
                    context.method_51439(client.field_1772, (class_2561)class_2561.method_43470((String)player).method_27694(s -> s.method_10982(Boolean.valueOf(true))), columnX, row * lineHeight, textColor, true);
                }
            }
            for (col = 0; col < otherColumns; ++col) {
                columnX = (commandColumns + col) * columnWidth;
                for (row = 0; row < maxPlayersPerColumn && (index = col * maxPlayersPerColumn + row) < otherPlayers.size(); ++row) {
                    player = (String)otherPlayers.get(index);
                    int slotPosition = col * maxPlayersPerColumn + row;
                    textColor = this.getSlotBasedGradientColor(slotPosition);
                    context.method_51439(client.field_1772, (class_2561)class_2561.method_43470((String)player).method_27694(s -> s.method_10982(Boolean.valueOf(true))), columnX, row * lineHeight, textColor, true);
                }
            }
            context.method_51448().method_22909();
        }
    }

    private int getColorPriority(String color) {
        return switch (color) {
            case "red" -> 3;
            case "green" -> 2;
            case "aqua" -> 1;
            default -> 0;
        };
    }

    private int getCommandColor(String color) {
        return switch (color) {
            case "red" -> -65536;
            case "green" -> -16711936;
            case "aqua" -> -16711681;
            default -> -1;
        };
    }

    private int getSlotBasedGradientColor(int slotPosition) {
        int b;
        int g;
        int r;
        float cyclePosition = (float)(slotPosition % 24) / 24.0f;
        if (cyclePosition < 0.2f) {
            float progress = cyclePosition / 0.2f;
            r = (int)(0.0f + 0.0f * progress);
            g = (int)(255.0f + -127.0f * progress);
            b = (int)(255.0f + 0.0f * progress);
        } else if (cyclePosition < 0.4f) {
            float progress = (cyclePosition - 0.2f) / 0.2f;
            r = (int)(0.0f + 128.0f * progress);
            g = (int)(128.0f + -128.0f * progress);
            b = 255;
        } else if (cyclePosition < 0.6f) {
            float progress = (cyclePosition - 0.4f) / 0.2f;
            r = (int)(128.0f + 127.0f * progress);
            g = 0;
            b = (int)(255.0f + -255.0f * progress);
        } else if (cyclePosition < 0.8f) {
            float progress = (cyclePosition - 0.6f) / 0.2f;
            r = 255;
            g = (int)(0.0f + 128.0f * progress);
            b = 0;
        } else {
            float progress = (cyclePosition - 0.8f) / 0.2f;
            r = (int)(255.0f + -127.0f * progress);
            g = (int)(128.0f + 127.0f * progress);
            b = (int)(0.0f + 64.0f * progress);
        }
        r = Math.max(0, Math.min(255, r));
        g = Math.max(0, Math.min(255, g));
        b = Math.max(0, Math.min(255, b));
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    private boolean isIgnored(String username) {
        return ignoredPlayers.contains(username.toLowerCase());
    }

    private boolean isValidPlayer(String username) {
        if (username.matches("slot_[1-9]|slot_[1-9][0-9]|slot_100")) {
            return false;
        }
        return !username.startsWith("minecraft:") && username.matches("[a-zA-Z0-9_]+");
    }

    private void toggleIgnoredPlayer(String username) {
        if (ignoredPlayers.contains(username = username.toLowerCase())) {
            ignoredPlayers.remove(username);
        } else {
            ignoredPlayers.add(username);
        }
        this.saveIgnoredPlayers();
        join.saveConfig();
    }

    private void saveIgnoredPlayers() {
        try (FileWriter writer = new FileWriter(new File("config/ignore.txt"));){
            for (String player : ignoredPlayers) {
                writer.write(player + System.lineSeparator());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadConfig() {
        Properties props = new Properties();
        if (configFile.exists()) {
            try (FileInputStream input = new FileInputStream(configFile);){
                props.load(input);
                NOTIFICATIONS_ENABLED = Boolean.parseBoolean(props.getProperty("notifications_enabled", "false"));
                GUI_VISIBLE = Boolean.parseBoolean(props.getProperty("gui_visible", "true"));
                MAX_PLAYERS_PER_COLUMN = Integer.parseInt(props.getProperty("max_players_per_column", "15"));
                UniversalGuiMover.loadGuiPositions(props);
                String ignored = props.getProperty("ignored_players", "");
                if (!ignored.isEmpty()) {
                    ignoredPlayers.addAll(Arrays.asList(ignored.split(",")));
                }
                String colors = props.getProperty("player_colors", "");
                for (String entry : colors.split(",")) {
                    String color;
                    String[] parts;
                    if (entry.isEmpty() || (parts = entry.split(":")).length != 2 || !(color = parts[1]).equals("red") && !color.equals("green") && !color.equals("aqua")) continue;
                    playerColors.put(parts[0].toLowerCase(), color);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void saveConfig() {
        Properties props = new Properties();
        props.setProperty("notifications_enabled", String.valueOf(NOTIFICATIONS_ENABLED));
        props.setProperty("gui_visible", String.valueOf(GUI_VISIBLE));
        props.setProperty("max_players_per_column", String.valueOf(MAX_PLAYERS_PER_COLUMN));
        props.setProperty("ignored_players", String.join((CharSequence)",", ignoredPlayers));
        StringBuilder colors = new StringBuilder();
        playerColors.forEach((k, v) -> {
            if (v.equals("red") || v.equals("green") || v.equals("aqua")) {
                colors.append((String)k).append(":").append((String)v).append(",");
            }
        });
        if (colors.length() > 0) {
            colors.setLength(colors.length() - 1);
        }
        props.setProperty("player_colors", colors.toString());
        UniversalGuiMover.saveGuiPositions(props);
        try (FileOutputStream output = new FileOutputStream(configFile);){
            props.store(output, "Player List Settings");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setPlayerColor(String username, String color) {
        playerColors.put(username.toLowerCase(), color);
        join.saveConfig();
    }

    private void resetPlayerColors() {
        playerColors.clear();
        join.saveConfig();
    }

    private void resetPlayerColor(String username) {
        playerColors.remove(username.toLowerCase());
        join.saveConfig();
    }
}

