/*
 * Decompiled with CFR 0.152.
 */
package chat.cosmic.client.mixin;

import chat.cosmic.client.client.UniversalGuiMover;
import chat.cosmic.client.client.globe_booster.ProgressBarToggleMod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_337;
import net.minecraft.class_345;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_337.class})
public class BossBarHudMixin {
    @Shadow
    @Final
    private Map<UUID, class_345> field_2060;
    private static final class_2960 MARAUDER_TEXTURE = new class_2960("xpbooster", "textures/gui/custom_bar.png");
    private static final class_2960 ISLAND_QUEST_TEXTURE = new class_2960("xpbooster", "textures/gui/custom_bar.png");
    private static final class_2960 MARAUDER_HITLIST_TEXTURE = new class_2960("xpbooster", "textures/gui/custom_bar.png");
    private static final class_2960 ISLAND_EXP_TEXTURE = new class_2960("xpbooster", "textures/gui/custom_bar.png");
    private static final int ICON_SIZE = 32;
    private static final int TEXT_COLOR = 0xFFFFFF;
    private static final int Y_OFFSET = 10;
    private static final float NAME_SCALE = 0.75f;
    private static final float TIMER_SCALE = 0.75f;
    private static final int SPACING = 50;
    private static final Map<String, UniversalGuiMover.HudContainer> bossBarContainers = new HashMap<String, UniversalGuiMover.HudContainer>();
    private static final String MARAUDER_KEY = "2x Marauder Bar Progress";
    private static final String ISLAND_QUEST_KEY = "1.5x Island Quest Progress";
    private static final String MARAUDER_HITLIST_KEY = "2x Marauder Hitlist Progress";
    private static final String ISLAND_EXP_KEY = "2x Island EXP Multiplier";
    @Unique
    private final Map<String, String[]> detectedCustomBars = new HashMap<String, String[]>();
    @Unique
    private final Map<UUID, class_345> removedBars = new HashMap<UUID, class_345>();
    @Unique
    private static boolean wasToggled = false;

    private static void initializeContainersIfNeeded() {
        if (bossBarContainers.isEmpty()) {
            bossBarContainers.put(MARAUDER_KEY, new UniversalGuiMover.HudContainer(0, 10, 32, 32, 1));
            bossBarContainers.put(ISLAND_QUEST_KEY, new UniversalGuiMover.HudContainer(0, 10, 32, 32, 1));
            bossBarContainers.put(MARAUDER_HITLIST_KEY, new UniversalGuiMover.HudContainer(0, 10, 32, 32, 1));
            bossBarContainers.put(ISLAND_EXP_KEY, new UniversalGuiMover.HudContainer(0, 10, 32, 32, 1));
        }
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void onRenderStart(class_332 context, CallbackInfo ci) {
        boolean isToggled = ProgressBarToggleMod.shouldHideBossBars();
        if (wasToggled != isToggled) {
            wasToggled = isToggled;
        }
        if (!isToggled) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1724 == null) {
            return;
        }
        BossBarHudMixin.initializeContainersIfNeeded();
        this.detectedCustomBars.clear();
        this.removedBars.clear();
        ArrayList<UUID> toRemove = new ArrayList<UUID>();
        for (Map.Entry<UUID, class_345> entry : this.field_2060.entrySet()) {
            String multiplier;
            String time;
            class_345 bar = entry.getValue();
            class_2561 name = bar.method_5414();
            if (name == null) continue;
            String text = name.getString();
            if (text.contains("Marauder Bar Progress")) {
                time = this.extractTime(text);
                multiplier = this.extractMultiplier(text);
                this.detectedCustomBars.put(MARAUDER_KEY, new String[]{time, multiplier});
                toRemove.add(entry.getKey());
                this.removedBars.put(entry.getKey(), bar);
                continue;
            }
            if (text.contains("Island Quest Progress")) {
                time = this.extractTime(text);
                multiplier = this.extractMultiplier(text);
                this.detectedCustomBars.put(ISLAND_QUEST_KEY, new String[]{time, multiplier});
                toRemove.add(entry.getKey());
                this.removedBars.put(entry.getKey(), bar);
                continue;
            }
            if (text.contains("Marauder Hitlist Progress")) {
                time = this.extractTime(text);
                multiplier = this.extractMultiplier(text);
                this.detectedCustomBars.put(MARAUDER_HITLIST_KEY, new String[]{time, multiplier});
                toRemove.add(entry.getKey());
                this.removedBars.put(entry.getKey(), bar);
                continue;
            }
            if (!text.contains("Island EXP Multiplier")) continue;
            time = this.extractTime(text);
            multiplier = this.extractMultiplier(text);
            this.detectedCustomBars.put(ISLAND_EXP_KEY, new String[]{time, multiplier});
            toRemove.add(entry.getKey());
            this.removedBars.put(entry.getKey(), bar);
        }
        for (UUID uuid : toRemove) {
            this.field_2060.remove(uuid);
        }
    }

    @Inject(method={"render"}, at={@At(value="RETURN")})
    private void onRenderEnd(class_332 context, CallbackInfo ci) {
        class_310 client = class_310.method_1551();
        if (client == null) {
            return;
        }
        if (!this.removedBars.isEmpty()) {
            this.field_2060.putAll(this.removedBars);
            this.removedBars.clear();
        }
        if (!ProgressBarToggleMod.shouldHideBossBars() || this.detectedCustomBars.isEmpty()) {
            return;
        }
        this.renderCustomBars(context, client, this.detectedCustomBars);
    }

    private void renderCustomBars(class_332 ctx, class_310 client, Map<String, String[]> customBars) {
        float scale = UniversalGuiMover.getGlobalTextScale();
        int iconSz = (int)(32.0f * scale);
        int sw = client.method_22683().method_4486();
        int sh = client.method_22683().method_4502();
        boolean force = UniversalGuiMover.isMovementModeActive();
        Map<String, UniversalGuiMover.HudContainer> hudContainers = UniversalGuiMover.getHudContainers();
        for (Map.Entry<String, UniversalGuiMover.HudContainer> entry : bossBarContainers.entrySet()) {
            if (hudContainers.containsKey(entry.getKey())) continue;
            UniversalGuiMover.trackHudContainer(entry.getKey(), entry.getValue());
        }
        if (!force) {
            block1: for (Map.Entry<String, UniversalGuiMover.HudContainer> entry : bossBarContainers.entrySet()) {
                UniversalGuiMover.HudContainer container = entry.getValue();
                if (container.x != 0 || !customBars.containsKey(entry.getKey())) continue;
                int total = customBars.size();
                int width = total * (iconSz + 50);
                int startX = sw / 2 - width / 2;
                int index = 0;
                for (String key : customBars.keySet()) {
                    if (key.equals(entry.getKey())) {
                        container.x = startX + index * (iconSz + 50);
                        container.y = 10;
                        continue block1;
                    }
                    ++index;
                }
            }
        }
        for (Map.Entry<String, UniversalGuiMover.HudContainer> entry : customBars.entrySet()) {
            String key = entry.getKey();
            String[] barData = (String[])entry.getValue();
            String timeText = barData[0];
            String multiplierText = barData[1];
            UniversalGuiMover.HudContainer container = bossBarContainers.get(key);
            if (container == null) continue;
            class_2960 texture = this.getTextureForKey(key);
            String displayName = this.getDisplayNameForKey(key);
            ctx.method_51448().method_22903();
            ctx.method_51448().method_46416((float)container.x, (float)container.y, 0.0f);
            ctx.method_51448().method_22905(scale, scale, 1.0f);
            ctx.method_25290(texture, 0, 0, 0.0f, 0.0f, 32, 32, 32, 32);
            float yOffset = 34.0f;
            ctx.method_51448().method_22903();
            ctx.method_51448().method_46416(16.0f, yOffset, 0.0f);
            ctx.method_51448().method_22905(0.75f, 0.75f, 1.0f);
            int nameWidth = client.field_1772.method_1727(displayName);
            ctx.method_51433(client.field_1772, displayName, -nameWidth / 2, 0, 0xFFFFFF, true);
            ctx.method_51448().method_22909();
            ctx.method_51448().method_22903();
            ctx.method_51448().method_46416(16.0f, yOffset + 10.0f, 0.0f);
            ctx.method_51448().method_22905(0.75f, 0.75f, 1.0f);
            int multiplierWidth = client.field_1772.method_1727(multiplierText);
            ctx.method_51433(client.field_1772, multiplierText, -multiplierWidth / 2, 0, 0xFFFFFF, true);
            ctx.method_51448().method_22909();
            ctx.method_51448().method_22903();
            ctx.method_51448().method_46416(16.0f, yOffset + 20.0f, 0.0f);
            ctx.method_51448().method_22905(0.75f, 0.75f, 1.0f);
            int timeWidth = client.field_1772.method_1727(timeText);
            ctx.method_51433(client.field_1772, timeText, -timeWidth / 2, 0, 0xFFFFFF, true);
            ctx.method_51448().method_22909();
            ctx.method_51448().method_22909();
        }
    }

    private class_2960 getTextureForKey(String key) {
        return switch (key) {
            case MARAUDER_KEY -> MARAUDER_TEXTURE;
            case ISLAND_QUEST_KEY -> ISLAND_QUEST_TEXTURE;
            case MARAUDER_HITLIST_KEY -> MARAUDER_HITLIST_TEXTURE;
            case ISLAND_EXP_KEY -> ISLAND_EXP_TEXTURE;
            default -> MARAUDER_TEXTURE;
        };
    }

    private String getDisplayNameForKey(String key) {
        return switch (key) {
            case MARAUDER_KEY -> "Marauder Bar Progress";
            case ISLAND_QUEST_KEY -> "Island Quest Progress";
            case MARAUDER_HITLIST_KEY -> "Marauder Hitlist Progress";
            case ISLAND_EXP_KEY -> "Island EXP Multiplier";
            default -> "Progress";
        };
    }

    private String extractTime(String text) {
        int start = text.indexOf(91) + 1;
        int end = text.indexOf(93);
        if (start > 0 && end > start) {
            return text.substring(start, end);
        }
        return "0s";
    }

    private String extractMultiplier(String text) {
        int xIndex = text.indexOf(120);
        if (xIndex > 0) {
            int start;
            for (start = xIndex - 1; start >= 0 && (Character.isDigit(text.charAt(start)) || text.charAt(start) == '.'); --start) {
            }
            return text.substring(++start, xIndex + 1);
        }
        return "1x";
    }
}

