/*
 * Decompiled with CFR 0.152.
 */
package chat.cosmic.client;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Random;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_2561;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class angle
implements ClientModInitializer {
    private static Float targetYaw = null;
    private static Float targetPitch = null;
    private static float currentSpeedYaw = 0.0f;
    private static float currentSpeedPitch = 0.0f;
    private static final float MAX_SPEED = 3.0f;
    private static final float MIN_SPEED = 0.2f;
    private static final Random random = new Random();

    public void onInitializeClient() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1724 != null && targetYaw != null && targetPitch != null) {
                this.gradualRotatePlayerHead(client);
            }
        });
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> this.registerCommands((CommandDispatcher<FabricClientCommandSource>)dispatcher));
    }

    private void gradualRotatePlayerHead(class_310 client) {
        if (client.field_1724 != null) {
            float currentYaw = client.field_1724.method_36454();
            float currentPitch = client.field_1724.method_36455();
            float yawDiff = this.calculateShortestYawDiff(currentYaw, targetYaw.floatValue());
            float pitchDiff = targetPitch.floatValue() - currentPitch;
            float distanceYaw = Math.abs(yawDiff);
            float distancePitch = Math.abs(pitchDiff);
            currentSpeedYaw = Math.max(0.2f, Math.min(3.0f, distanceYaw * 0.1f));
            currentSpeedPitch = Math.max(0.2f, Math.min(3.0f, distancePitch * 0.1f));
            currentYaw = Math.abs(yawDiff) > currentSpeedYaw ? (currentYaw += Math.signum(yawDiff) * currentSpeedYaw) : targetYaw.floatValue();
            currentPitch = Math.abs(pitchDiff) > currentSpeedPitch ? (currentPitch += Math.signum(pitchDiff) * currentSpeedPitch) : targetPitch.floatValue();
            currentYaw = this.normalizeAngle(currentYaw);
            client.field_1724.method_36456(currentYaw);
            client.field_1724.method_36457(currentPitch);
            client.field_1724.method_5847(currentYaw);
            client.field_1724.field_6283 = currentYaw;
            if (Math.abs(yawDiff) <= 0.2f && Math.abs(pitchDiff) <= 0.2f) {
                targetYaw = null;
                targetPitch = null;
                client.field_1724.method_7353(class_2561.method_30163((String)"Rotation complete."), false);
            }
        }
    }

    private float calculateShortestYawDiff(float currentYaw, float targetYaw) {
        float diff;
        for (diff = targetYaw - currentYaw; diff < -180.0f; diff += 360.0f) {
        }
        while (diff >= 180.0f) {
            diff -= 360.0f;
        }
        return diff;
    }

    private float normalizeAngle(float angle2) {
        while (angle2 < 0.0f) {
            angle2 += 360.0f;
        }
        while (angle2 >= 360.0f) {
            angle2 -= 360.0f;
        }
        return angle2;
    }

    public static void setTargetDirection(float yaw, float pitch) {
        targetYaw = Float.valueOf(yaw);
        targetPitch = Float.valueOf(pitch);
        currentSpeedYaw = 3.0f;
        currentSpeedPitch = 3.0f;
    }

    private void registerCommands(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"setangle").then(ClientCommandManager.argument((String)"yaw", (ArgumentType)FloatArgumentType.floatArg()).then(ClientCommandManager.argument((String)"pitch", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> {
            float yaw = FloatArgumentType.getFloat((CommandContext)context, (String)"yaw");
            float pitch = FloatArgumentType.getFloat((CommandContext)context, (String)"pitch");
            angle.setTargetDirection(yaw, pitch);
            class_310.method_1551().field_1724.method_7353(class_2561.method_30163((String)("Rotating to Yaw: " + yaw + ", Pitch: " + pitch)), false);
            return 1;
        }))));
    }
}

