/*
 * Decompiled with CFR 0.152.
 */
package chat.cosmic.client.client;

import chat.cosmic.client.client.UniversalGuiMover;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_1041;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_465;

@Environment(value=EnvType.CLIENT)
public class ChestTrackerMod
implements ClientModInitializer {
    private static final Map<String, Integer> chestCounts = new HashMap<String, Integer>();
    private static final Map<String, Integer> tierColors = Map.of("Basic", 0xFFFFFF, "Elite", 5569788, "Legendary", 16753920, "Godly", 0xFF0000, "Heroic", 16738740, "Mythic", 0x800080);
    private static final String[] TIERS = new String[]{"Basic", "Elite", "Legendary", "Godly", "Heroic", "Mythic"};
    private static class_304 resetKey;
    private static class_304 toggleHudKey;
    private static class_304 startPauseTimerKey;
    private static boolean hudVisible;
    private static final Path CONFIG_PATH;
    private static final Set<String> countedChests;
    private static long startTime;
    private static long pausedTime;
    private static boolean isTimerRunning;
    private static boolean needsBoundaryCheck;
    private static final UniversalGuiMover.HudContainer hudContainer;

    public void onInitializeClient() {
        this.initializeCounts();
        this.setupKeybinds();
        this.loadHudPosition();
        UniversalGuiMover.trackHudContainer("chestTrackerHud", hudContainer);
        ScreenEvents.AFTER_INIT.register(this::handleScreenInit);
        ClientTickEvents.END_CLIENT_TICK.register(this::handleClientTick);
        ClientTickEvents.START_CLIENT_TICK.register(this::handleBoundaryCheck);
        HudRenderCallback.EVENT.register(this::renderHud);
    }

    private void initializeCounts() {
        for (String tier : TIERS) {
            chestCounts.put(tier, 0);
        }
    }

    private void setupKeybinds() {
        resetKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("chest tracker reset", class_3675.class_307.field_1668, 82, "chest tracker"));
        toggleHudKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("chest tracker togglehud", class_3675.class_307.field_1668, 72, "chest tracker"));
        startPauseTimerKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("chest tracker start pause timer", class_3675.class_307.field_1668, 84, "chest tracker"));
    }

    private void handleBoundaryCheck(class_310 client) {
        if (needsBoundaryCheck && client.method_22683() != null) {
            class_1041 window = client.method_22683();
            ChestTrackerMod.hudContainer.x = this.clampHudX(ChestTrackerMod.hudContainer.x, window);
            ChestTrackerMod.hudContainer.y = this.clampHudY(ChestTrackerMod.hudContainer.y, window);
            needsBoundaryCheck = false;
            this.saveHudPosition();
        }
    }

    private int clampHudX(int x, class_1041 window) {
        return Math.max(5, Math.min(x, window.method_4486() - hudContainer.getScaledWidth() - 5));
    }

    private int clampHudY(int y, class_1041 window) {
        return Math.max(5, Math.min(y, window.method_4502() - hudContainer.getScaledHeight() - 5));
    }

    private void handleScreenInit(class_310 client, Object screen, int width, int height) {
        if (screen instanceof class_465) {
            class_465 handledScreen = (class_465)screen;
            countedChests.clear();
            ScreenEvents.beforeRender((class_437)((class_437)screen)).register((s, ctx, mx, my, delta) -> this.handleChestOpen(handledScreen.method_25440().getString()));
        }
    }

    private void handleClientTick(class_310 client) {
        if (resetKey.method_1436()) {
            this.handleReset();
        }
        if (startPauseTimerKey.method_1436()) {
            this.handleTimerToggle();
        }
        if (toggleHudKey.method_1436()) {
            this.toggleHudVisibility();
        }
    }

    private void handleReset() {
        this.resetCounts();
        this.resetTimer();
        this.sendClientMessage("Reset all chest counts and timer!");
    }

    private void handleTimerToggle() {
        this.toggleTimer();
        this.sendClientMessage("Timer " + (isTimerRunning ? "started" : "paused"));
    }

    private void toggleHudVisibility() {
        hudVisible = !hudVisible;
        this.sendClientMessage("HUD " + (hudVisible ? "enabled" : "disabled"));
    }

    private void sendClientMessage(String message) {
        if (class_310.method_1551().field_1724 != null) {
            class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)message), false);
        }
    }

    private boolean isInAdventureDimension() {
        class_310 client = class_310.method_1551();
        return client.field_1687 != null && client.field_1687.method_27983().method_29177().toString().contains("minecraft:adventure");
    }

    private void handleChestOpen(String title) {
        if (!this.isInAdventureDimension()) {
            return;
        }
        String cleanedTitle = title.replaceAll("\u00a7[0-9a-fk-or]", "").trim();
        if (countedChests.add(cleanedTitle)) {
            Arrays.stream(TIERS).filter(cleanedTitle::contains).findFirst().ifPresent(tier -> chestCounts.put((String)tier, chestCounts.get(tier) + 1));
        }
    }

    private void resetCounts() {
        chestCounts.replaceAll((k, v) -> 0);
        countedChests.clear();
    }

    private void resetTimer() {
        startTime = 0L;
        pausedTime = 0L;
        isTimerRunning = false;
    }

    private void toggleTimer() {
        if (isTimerRunning) {
            pausedTime = System.currentTimeMillis() - startTime;
            isTimerRunning = false;
        } else {
            startTime = System.currentTimeMillis() - pausedTime;
            isTimerRunning = true;
        }
    }

    private String getElapsedTime() {
        long elapsedMillis = isTimerRunning ? System.currentTimeMillis() - startTime : pausedTime;
        long seconds = elapsedMillis / 1000L;
        return String.format("%02d:%02d:%02d", seconds / 3600L % 24L, seconds / 60L % 60L, seconds % 60L);
    }

    private void renderHud(class_332 context, float tickDelta) {
        if (!hudVisible) {
            return;
        }
        class_310 client = class_310.method_1551();
        class_1041 window = client.method_22683();
        UniversalGuiMover.HudContainer container = UniversalGuiMover.getHudContainer("chestTrackerHud");
        if (client == null || window == null || container == null) {
            return;
        }
        ChestTrackerMod.hudContainer.x = container.x;
        ChestTrackerMod.hudContainer.y = container.y;
        if (UniversalGuiMover.isDragging()) {
            needsBoundaryCheck = true;
        } else if (needsBoundaryCheck) {
            ChestTrackerMod.hudContainer.x = this.clampHudX(ChestTrackerMod.hudContainer.x, window);
            ChestTrackerMod.hudContainer.y = this.clampHudY(ChestTrackerMod.hudContainer.y, window);
            this.saveHudPosition();
            needsBoundaryCheck = false;
        }
        float scale = UniversalGuiMover.getGlobalTextScale();
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)ChestTrackerMod.hudContainer.x, (float)ChestTrackerMod.hudContainer.y, 0.0f);
        context.method_51448().method_22905(scale, scale, 1.0f);
        class_327 renderer = client.field_1772;
        int yPos = 2;
        int padding = 2;
        context.method_25303(renderer, "Time: " + this.getElapsedTime(), 2, yPos, 0xFFFFFF);
        Objects.requireNonNull(renderer);
        yPos += 9 + (int)(2.0f / scale);
        if (this.isInAdventureDimension()) {
            for (String tier : TIERS) {
                context.method_25303(renderer, tier + ": " + String.valueOf(chestCounts.get(tier)), 2, yPos, tierColors.getOrDefault(tier, 0xFFFFFF).intValue());
                Objects.requireNonNull(renderer);
                yPos += 9 + (int)(2.0f / scale);
            }
        }
        context.method_51448().method_22909();
    }

    private void saveHudPosition() {
        try {
            class_2487 nbt = new class_2487();
            nbt.method_10569("hudX", ChestTrackerMod.hudContainer.x);
            nbt.method_10569("hudY", ChestTrackerMod.hudContainer.y);
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            class_2507.method_10630((class_2487)nbt, (Path)CONFIG_PATH);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void loadHudPosition() {
        try {
            if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                class_2487 nbt = class_2507.method_10633((Path)CONFIG_PATH);
                ChestTrackerMod.hudContainer.x = nbt.method_10550("hudX");
                ChestTrackerMod.hudContainer.y = nbt.method_10550("hudY");
                needsBoundaryCheck = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        hudVisible = true;
        CONFIG_PATH = Path.of("config/chesttracker_hud.dat", new String[0]);
        countedChests = new HashSet<String>();
        startTime = 0L;
        pausedTime = 0L;
        isTimerRunning = false;
        needsBoundaryCheck = true;
        hudContainer = new UniversalGuiMover.HudContainer(10, 100, 120, 9, 7);
    }
}

