/*
 * Decompiled with CFR 0.152.
 */
package chat.cosmic.client.client;

import chat.cosmic.client.client.UniversalGuiMover;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3675;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class MythicTrackerMod
implements ClientModInitializer {
    private static int mythicCount = 0;
    private static int godlyCount = 0;
    private static int heroicCount = 0;
    private static boolean isHudVisible = true;
    private static class_304 toggleHudKey;
    private static boolean wasToggleKeyPressed;
    private static final String CONFIG_FILE = "config/mythictracker.properties";
    public static final class_2960 MYTHIC_SOUND_ID;
    public static final class_2960 GODLY_SOUND_ID;
    public static final class_2960 HEROIC_SOUND_ID;
    public static class_3414 MYTHIC_SOUND;
    public static class_3414 GODLY_SOUND;
    public static class_3414 HEROIC_SOUND;

    public void onInitializeClient() {
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)MYTHIC_SOUND_ID, (Object)MYTHIC_SOUND);
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)GODLY_SOUND_ID, (Object)GODLY_SOUND);
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)HEROIC_SOUND_ID, (Object)HEROIC_SOUND);
        UniversalGuiMover.HudContainer hudContainer = new UniversalGuiMover.HudContainer(10, 10, 50, 12, 3);
        UniversalGuiMover.trackHudContainer("mythicTrackerHud", hudContainer);
        toggleHudKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("Toggle HUD", class_3675.class_307.field_1668, 82, "Fish Tracker"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            boolean isTogglePressed = toggleHudKey.method_1434();
            if (isTogglePressed && !wasToggleKeyPressed) {
                isHudVisible = !isHudVisible;
            }
            wasToggleKeyPressed = isTogglePressed;
        });
        ClientReceiveMessageEvents.GAME.register((message, overlay) -> {
            String msg = message.getString();
            class_310 client = class_310.method_1551();
            if (msg.contains("Mythic Treasure")) {
                ++mythicCount;
                this.playSound(client, MYTHIC_SOUND);
            } else if (msg.contains("Godly Treasure")) {
                ++godlyCount;
                this.playSound(client, GODLY_SOUND);
            } else if (msg.contains("Heroic Treasure")) {
                ++heroicCount;
                this.playSound(client, HEROIC_SOUND);
            }
        });
        HudRenderCallback.EVENT.register((context, delta) -> {
            if (isHudVisible) {
                this.drawHud(context);
            }
        });
    }

    private void drawHud(class_332 context) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        UniversalGuiMover.HudContainer container = UniversalGuiMover.getHudContainer("mythicTrackerHud");
        if (container == null) {
            return;
        }
        float scale = UniversalGuiMover.getGlobalTextScale();
        int scaledX = container.x;
        int scaledY = container.y;
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)scaledX, (float)scaledY, 0.0f);
        context.method_51448().method_22905(scale, scale, 1.0f);
        context.method_51439(client.field_1772, (class_2561)class_2561.method_43470((String)"\u00a7bFishing Tracker"), 2, 2, 0xFFFFFF, true);
        context.method_51439(client.field_1772, (class_2561)class_2561.method_43470((String)("\u00a7cGodly: " + godlyCount)), 2, 14, 0xFFFFFF, true);
        context.method_51439(client.field_1772, (class_2561)class_2561.method_43470((String)("\u00a7dHeroic: " + heroicCount)), 2, 26, 0xFFFFFF, true);
        context.method_51439(client.field_1772, (class_2561)class_2561.method_43470((String)("\u00a75Mythic: " + mythicCount)), 2, 38, 0xFFFFFF, true);
        context.method_51448().method_22909();
    }

    private void playSound(class_310 client, class_3414 sound) {
        if (client.field_1724 != null) {
            client.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)sound, (float)1.0f, (float)1.0f));
        }
    }

    static {
        wasToggleKeyPressed = false;
        MYTHIC_SOUND_ID = new class_2960("mythictracker", "mythic_sound");
        GODLY_SOUND_ID = new class_2960("mythictracker", "godly_sound");
        HEROIC_SOUND_ID = new class_2960("mythictracker", "heroic_sound");
        MYTHIC_SOUND = class_3414.method_47908((class_2960)MYTHIC_SOUND_ID);
        GODLY_SOUND = class_3414.method_47908((class_2960)GODLY_SOUND_ID);
        HEROIC_SOUND = class_3414.method_47908((class_2960)HEROIC_SOUND_ID);
    }
}

