/*
 * Decompiled with CFR 0.152.
 */
package chat.cosmic.client.client;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_465;

@Environment(value=EnvType.CLIENT)
public class NumberOverlayMod
implements ClientModInitializer {
    private static final Pattern MONEY_PATTERN = Pattern.compile("\\$?(\\d{1,3}(?:,\\d{3})*|\\d+)", 2);
    private static final Pattern XP_PATTERN = Pattern.compile("(\\d{1,3}(?:,\\d{3})*|\\d+)\\s+xp", 2);
    private static final class_310 client = class_310.method_1551();
    private static final float TEXT_SCALE = 0.6f;
    private static final int HOTBAR_SLOT_SIZE = 20;
    private static final int INVENTORY_SLOT_SIZE = 16;

    public void onInitializeClient() {
        HudRenderCallback.EVENT.register((context, tickDelta) -> {
            if (this.shouldRenderHotbar()) {
                this.renderHotbarValues(context);
            }
        });
    }

    private boolean shouldRenderHotbar() {
        return NumberOverlayMod.client.field_1755 == null && NumberOverlayMod.client.field_1724 != null;
    }

    private void renderHotbarValues(class_332 context) {
        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();
        int baseX = screenWidth / 2 - 91;
        int baseY = screenHeight - 23;
        for (int i = 0; i < 9; ++i) {
            class_1799 stack = NumberOverlayMod.client.field_1724.method_31548().method_5438(i);
            if (!NumberOverlayMod.isTargetItem(stack)) continue;
            int slotCenterX = baseX + i * 20 + 10;
            int slotCenterY = baseY + 10;
            NumberOverlayMod.renderItemValue(context, stack, slotCenterX, slotCenterY);
        }
    }

    public static void renderInventoryItemValue(class_332 context, class_1799 stack, int x, int y) {
        if (!NumberOverlayMod.isTargetItem(stack)) {
            return;
        }
        if (!(NumberOverlayMod.client.field_1755 instanceof class_465)) {
            return;
        }
        int centerX = x + 8;
        int centerY = y + 8;
        NumberOverlayMod.renderItemValue(context, stack, centerX, centerY);
    }

    public static void renderItemValue(class_332 context, class_1799 stack, int x, int y) {
        String value = NumberOverlayMod.getItemValue(stack);
        if (value.isEmpty()) {
            return;
        }
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)x, (float)y, 300.0f);
        context.method_51448().method_22905(0.6f, 0.6f, 1.0f);
        int textWidth = NumberOverlayMod.client.field_1772.method_1727(value);
        Objects.requireNonNull(NumberOverlayMod.client.field_1772);
        int textHeight = 9;
        int drawX = -textWidth / 2;
        int drawY = -textHeight / 2;
        for (int ox = -1; ox <= 1; ++ox) {
            for (int oy = -1; oy <= 1; ++oy) {
                if (ox == 0 && oy == 0) continue;
                context.method_51433(NumberOverlayMod.client.field_1772, value, drawX + ox, drawY + oy, 0, false);
            }
        }
        context.method_51433(NumberOverlayMod.client.field_1772, value, drawX, drawY, 0xFFFFFF, false);
        context.method_51448().method_22909();
    }

    private static boolean isTargetItem(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        if (stack.method_7909() == class_1802.field_8287) {
            return true;
        }
        if (stack.method_7909() == class_1802.field_8407) {
            class_2561 name = stack.method_7964();
            return name != null && name.getString().toLowerCase().contains("money note");
        }
        return false;
    }

    private static String getItemValue(class_1799 stack) {
        if (stack.method_7909() == class_1802.field_8407 && NumberOverlayMod.isTargetItem(stack)) {
            return NumberOverlayMod.parseMoneyValue(stack);
        }
        if (stack.method_7909() == class_1802.field_8287) {
            return NumberOverlayMod.parseXPValue(stack);
        }
        return "";
    }

    private static String parseMoneyValue(class_1799 stack) {
        if (!stack.method_7985() || !stack.method_7969().method_10545("display")) {
            return "";
        }
        class_2487 displayTag = stack.method_7969().method_10562("display");
        if (!displayTag.method_10545("Lore")) {
            return "";
        }
        class_2499 lore = displayTag.method_10554("Lore", 8);
        for (int i = 0; i < lore.size(); ++i) {
            String loreText = lore.method_10608(i).replaceAll("\u00a7[0-9a-fk-or]", "").trim();
            Matcher matcher = MONEY_PATTERN.matcher(loreText);
            if (!matcher.find()) continue;
            String numberStr = matcher.group(1).replace(",", "");
            try {
                long value = Long.parseLong(numberStr);
                return "$" + NumberOverlayMod.abbreviateNumber(value);
            }
            catch (NumberFormatException e) {
                return "";
            }
        }
        return "";
    }

    private static String parseXPValue(class_1799 stack) {
        if (!stack.method_7985() || !stack.method_7969().method_10545("display")) {
            return "";
        }
        class_2487 displayTag = stack.method_7969().method_10562("display");
        if (!displayTag.method_10545("Lore")) {
            return "";
        }
        class_2499 lore = displayTag.method_10554("Lore", 8);
        for (int i = 0; i < lore.size(); ++i) {
            String loreText = lore.method_10608(i).replaceAll("\u00a7[0-9a-fk-or]", "").trim();
            Matcher matcher = XP_PATTERN.matcher(loreText);
            if (!matcher.find()) continue;
            String numberStr = matcher.group(1).replace(",", "");
            try {
                long value = Long.parseLong(numberStr);
                return NumberOverlayMod.abbreviateNumber(value) + " XP";
            }
            catch (NumberFormatException e) {
                return "";
            }
        }
        return "";
    }

    private static String abbreviateNumber(long value) {
        if (value < 1000L) {
            return String.valueOf(value);
        }
        String[] units = new String[]{"", "k", "m", "b", "t", "q"};
        int exp = (int)(Math.log(value) / Math.log(1000.0));
        double abbreviated = (double)value / Math.pow(1000.0, exp = Math.min(exp, units.length - 1));
        return String.format(abbreviated % 1.0 == 0.0 ? "%.0f%s" : "%.1f%s", abbreviated, units[exp]);
    }
}

