/*
 * Decompiled with CFR 0.152.
 */
package chat.cosmic.client.client;

import chat.cosmic.client.client.UniversalGuiMover;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1041;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;

@Environment(value=EnvType.CLIENT)
public class StatusEffectsTracker {
    private static final Map<String, Integer> curseTimers = new HashMap<String, Integer>();
    private static final Pattern CURSE_PATTERN = Pattern.compile("You have been cursed! You will be siphoned to 1 HP in (\\d+)s!");
    private static final class_2960 CURSE_TEXTURE = new class_2960("xpbooster", "textures/gui/curse.png");
    private static final List<ChaoticMessage> chaoticZoneMessages = new ArrayList<ChaoticMessage>();
    private static final Pattern CHAOTIC_ZONE_PATTERN = Pattern.compile("(\\w+) has (entered|left) the Chaotic Zone!");
    private static final int CHAOTIC_MESSAGE_DURATION = 120;
    private static final float SOUND_VOLUME = 20.0f;
    private static final float SOUND_PITCH = 2.0f;
    private static final int ICON_SIZE = 16;
    private static final int CURSE_COLOR = 0xFF5555;
    private static final float NAME_SCALE = 0.7f;
    private static final float TIMER_SCALE = 0.7f;
    private static final UniversalGuiMover.HudContainer curseContainer = new UniversalGuiMover.HudContainer(0, 60, 16, 16, 1);
    private static final UniversalGuiMover.HudContainer chaoticZoneContainer = new UniversalGuiMover.HudContainer(0, 30, 100, 60, 2);

    public static void initialize() {
        UniversalGuiMover.trackHudContainer("Curse", curseContainer);
        UniversalGuiMover.trackHudContainer("ChaoticZone", chaoticZoneContainer);
        ClientReceiveMessageEvents.GAME.register(StatusEffectsTracker::handleGameMessage);
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            curseTimers.replaceAll((k, v) -> Math.max(v - 1, 0));
            chaoticZoneMessages.removeIf(message -> --message.timer <= 0);
        });
        HudRenderCallback.EVENT.register(StatusEffectsTracker::renderHud);
    }

    private static void handleGameMessage(class_2561 text, boolean overlay) {
        Matcher matcher;
        if (overlay) {
            return;
        }
        String message = text.getString();
        String lowerMessage = message.toLowerCase();
        if (lowerMessage.contains("you have been cursed") && lowerMessage.contains("siphoned to 1 hp") && (matcher = CURSE_PATTERN.matcher(message)).find()) {
            try {
                int seconds = Integer.parseInt(matcher.group(1));
                if (seconds > 0) {
                    curseTimers.put("Curse", seconds);
                }
            }
            catch (NumberFormatException e) {
                System.err.println("Failed to parse curse duration: " + message);
            }
        }
        if ((matcher = CHAOTIC_ZONE_PATTERN.matcher(message)).find()) {
            String playerName = matcher.group(1);
            String action = matcher.group(2).equalsIgnoreCase("entered") ? "entered" : "left";
            String formattedMessage = playerName + " has " + action + " the Chaotic Zone!";
            chaoticZoneMessages.add(new ChaoticMessage(formattedMessage, 120));
            StatusEffectsTracker.playChaoticSound();
        }
    }

    private static void playChaoticSound() {
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null) {
            client.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_14671, (float)2.0f, (float)20.0f));
        }
    }

    private static void renderHud(class_332 context, float tickDelta) {
        class_310 client = class_310.method_1551();
        class_1041 window = client.method_22683();
        if (client.field_1724 == null || window == null) {
            return;
        }
        StatusEffectsTracker.renderChaoticZoneMessages(context, client, window);
        StatusEffectsTracker.renderCurseIcon(context, client, window);
    }

    private static void renderChaoticZoneMessages(class_332 context, class_310 client, class_1041 window) {
        boolean forceShow = UniversalGuiMover.isMovementModeActive();
        float globalScale = UniversalGuiMover.getGlobalTextScale();
        int maxWidth = forceShow ? 100 : 0;
        int lineHeight = (int)(12.0f * globalScale);
        int totalHeight = 0;
        if (!chaoticZoneMessages.isEmpty() || forceShow) {
            for (ChaoticMessage message : chaoticZoneMessages) {
                int messageWidth = (int)((float)client.field_1772.method_1727(message.message) * globalScale);
                if (messageWidth <= maxWidth) continue;
                maxWidth = messageWidth;
            }
            totalHeight = (chaoticZoneMessages.size() + (forceShow ? 1 : 0)) * lineHeight;
            StatusEffectsTracker.chaoticZoneContainer.baseWidth = (int)((float)maxWidth + 4.0f * globalScale);
            StatusEffectsTracker.chaoticZoneContainer.baseHeight = (int)((float)totalHeight + 4.0f * globalScale);
            if (!UniversalGuiMover.isMovementModeActive()) {
                StatusEffectsTracker.chaoticZoneContainer.x = Math.max(5, Math.min(StatusEffectsTracker.chaoticZoneContainer.x, window.method_4486() - (int)((float)StatusEffectsTracker.chaoticZoneContainer.baseWidth * globalScale) - 5));
                StatusEffectsTracker.chaoticZoneContainer.y = Math.max(5, Math.min(StatusEffectsTracker.chaoticZoneContainer.y, window.method_4502() - (int)((float)StatusEffectsTracker.chaoticZoneContainer.baseHeight * globalScale) - 5));
            }
            long time = System.currentTimeMillis();
            int yOffset = (int)(2.0f * globalScale);
            context.method_51448().method_22903();
            context.method_51448().method_46416((float)StatusEffectsTracker.chaoticZoneContainer.x, (float)StatusEffectsTracker.chaoticZoneContainer.y, 0.0f);
            context.method_51448().method_22905(globalScale, globalScale, 1.0f);
            if (UniversalGuiMover.isMovementModeActive()) {
                context.method_25294(0, 0, (int)((float)StatusEffectsTracker.chaoticZoneContainer.baseWidth / globalScale), (int)((float)StatusEffectsTracker.chaoticZoneContainer.baseHeight / globalScale), Integer.MIN_VALUE);
            }
            for (ChaoticMessage entry : chaoticZoneMessages) {
                String message = entry.message;
                float alpha = (float)(0.5 + 0.5 * Math.cos((double)time * 0.002));
                int textColor = 0xFF000000 | (int)(255.0f * alpha) << 16;
                context.method_51433(client.field_1772, message, (int)(2.0f / globalScale), (int)((float)yOffset / globalScale), textColor, false);
                yOffset += lineHeight;
            }
            if (forceShow && chaoticZoneMessages.isEmpty()) {
                context.method_51433(client.field_1772, "Chaotic Zone", (int)(2.0f / globalScale), (int)(2.0f / globalScale), -2130771968, false);
            }
            context.method_51448().method_22909();
        }
    }

    private static void renderCurseIcon(class_332 context, class_310 client, class_1041 window) {
        float globalScale = UniversalGuiMover.getGlobalTextScale();
        int scaledIconSize = (int)(16.0f * globalScale);
        boolean forceShow = UniversalGuiMover.isMovementModeActive();
        if (curseTimers.containsKey("Curse") || forceShow) {
            Object curseText;
            int curseTime = curseTimers.getOrDefault("Curse", 0);
            Object object = curseText = curseTime > 0 ? "Curse: " + curseTime + "s" : "Curse";
            if (!UniversalGuiMover.isMovementModeActive()) {
                StatusEffectsTracker.curseContainer.x = Math.max(5, Math.min(StatusEffectsTracker.curseContainer.x, window.method_4486() - scaledIconSize - 5));
                StatusEffectsTracker.curseContainer.y = Math.max(5, Math.min(StatusEffectsTracker.curseContainer.y, window.method_4502() - scaledIconSize * 2 - 5));
            }
            context.method_51448().method_22903();
            context.method_51448().method_46416((float)StatusEffectsTracker.curseContainer.x, (float)StatusEffectsTracker.curseContainer.y, 0.0f);
            context.method_51448().method_22905(globalScale, globalScale, 1.0f);
            if (forceShow && curseTime <= 0) {
                context.method_51422(1.0f, 1.0f, 1.0f, 0.4f);
            }
            context.method_25290(CURSE_TEXTURE, 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
            context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
            if (curseTime > 0 || forceShow) {
                float textYOffset = 18.0f;
                context.method_51448().method_22903();
                context.method_51448().method_46416(8.0f, textYOffset, 0.0f);
                context.method_51448().method_22905(0.7f, 0.7f, 1.0f);
                int nameWidth = client.field_1772.method_1727("Curse");
                context.method_51433(client.field_1772, "Curse", -nameWidth / 2, 0, 0xFF5555, true);
                context.method_51448().method_22909();
                if (curseTime > 0) {
                    context.method_51448().method_22903();
                    context.method_51448().method_46416(8.0f, textYOffset + 10.0f, 0.0f);
                    context.method_51448().method_22905(0.7f, 0.7f, 1.0f);
                    int timeWidth = client.field_1772.method_1727((String)curseText);
                    context.method_51433(client.field_1772, (String)curseText, -timeWidth / 2, 0, 0xFF5555, true);
                    context.method_51448().method_22909();
                }
            }
            context.method_51448().method_22909();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class ChaoticMessage {
        final String message;
        int timer;
        final UUID uuid;

        ChaoticMessage(String message, int duration) {
            this.message = message;
            this.timer = duration;
            this.uuid = UUID.randomUUID();
        }
    }
}

