/*
 * Decompiled with CFR 0.152.
 */
package chat.cosmic.client.client;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1041;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import org.lwjgl.glfw.GLFW;

@Environment(value=EnvType.CLIENT)
public class UniversalGuiMover
implements ClientModInitializer {
    private static class_304 moveGuisKey;
    private static boolean isMovementMode;
    private static HudContainer draggedContainer;
    private static final Map<String, HudContainer> hudContainers;
    private static final String CONFIG_FILE = "config/untitled20_mod.properties";
    private static float globalTextScale;
    private static class_304 scaleUpKey;
    private static class_304 scaleDownKey;
    private static boolean dragging;

    public void onInitializeClient() {
        ClientLifecycleEvents.CLIENT_STOPPING.register(client -> UniversalGuiMover.saveGuiPositions());
        this.setupKeybinds();
        HudRenderCallback.EVENT.register(this::onHudRender);
    }

    public static void loadGuiPositions(Properties props) {
        if (props.containsKey("scale")) {
            globalTextScale = Float.parseFloat(props.getProperty("scale"));
        }
        props.stringPropertyNames().stream().filter(key -> key.contains(".")).forEach(key -> {
            String[] parts = key.split("\\.", 2);
            String id = parts[0];
            String prop = parts[1];
            HudContainer container = hudContainers.get(id);
            if (container != null) {
                switch (prop) {
                    case "x": {
                        container.x = Integer.parseInt(props.getProperty((String)key));
                        break;
                    }
                    case "y": {
                        container.y = Integer.parseInt(props.getProperty((String)key));
                    }
                }
            }
        });
    }

    public static void saveGuiPositions(Properties props) {
        props.setProperty("scale", String.valueOf(globalTextScale));
        hudContainers.forEach((id, container) -> {
            props.setProperty(id + ".x", String.valueOf(container.x));
            props.setProperty(id + ".y", String.valueOf(container.y));
        });
    }

    public static void saveGuiPositions() {
    }

    public static void loadGuiPositions() {
    }

    private void setupKeybinds() {
        moveGuisKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("Move GUIs", class_3675.class_307.field_1668, 80, "Universal GUI Mover"));
        scaleUpKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("Scale Up", class_3675.class_307.field_1668, 61, "Universal GUI Mover"));
        scaleDownKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("Scale Down", class_3675.class_307.field_1668, 45, "Universal GUI Mover"));
    }

    private void onHudRender(class_332 context, float tickDelta) {
        class_310 client = class_310.method_1551();
        if (client == null) {
            return;
        }
        this.handleMovementMode(client);
        this.handleScaling(client);
        this.handleDragging(client);
        if (isMovementMode) {
            for (HudContainer container : hudContainers.values()) {
                int x = container.x;
                int y = container.y;
                int width = container.getScaledWidth();
                int height = container.getScaledHeight();
                context.method_25294(x, y, x + width, y + height, 0x20FFFFFF);
                context.method_25294(x, y, x + width, y + 2, -1);
                context.method_25294(x, y + height - 2, x + width, y + height, -1);
                context.method_25294(x, y, x + 2, y + height, -1);
                context.method_25294(x + width - 2, y, x + width, y + height, -1);
            }
        }
    }

    private void handleMovementMode(class_310 client) {
        if (moveGuisKey.method_1436()) {
            boolean bl = isMovementMode = !isMovementMode;
            if (client.field_1724 != null) {
                client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("GUI Movement: " + (isMovementMode ? "ON" : "OFF"))), true);
            }
        }
    }

    private void handleScaling(class_310 client) {
        if (scaleUpKey.method_1436()) {
            this.updateScale(0.1f, client);
        }
        if (scaleDownKey.method_1436()) {
            this.updateScale(-0.1f, client);
        }
    }

    private void updateScale(float delta, class_310 client) {
        globalTextScale = Math.max(0.5f, Math.min(2.5f, globalTextScale + delta));
        if (client.field_1724 != null) {
            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("Scale: " + String.format("%.1f", Float.valueOf(globalTextScale)))), true);
        }
    }

    private void handleDragging(class_310 client) {
        boolean mouseDown;
        if (!isMovementMode) {
            return;
        }
        class_1041 window = client.method_22683();
        double mouseX = client.field_1729.method_1603() * (double)window.method_4486() / (double)window.method_4480();
        double mouseY = client.field_1729.method_1604() * (double)window.method_4502() / (double)window.method_4507();
        boolean bl = mouseDown = GLFW.glfwGetMouseButton((long)window.method_4490(), (int)0) == 1;
        if (mouseDown) {
            if (draggedContainer == null) {
                hudContainers.values().stream().filter(container -> this.isMouseOver((HudContainer)container, mouseX, mouseY)).findFirst().ifPresent(container -> {
                    draggedContainer = container;
                });
            } else {
                UniversalGuiMover.draggedContainer.x = UniversalGuiMover.clampX((int)mouseX, draggedContainer, window);
                UniversalGuiMover.draggedContainer.y = UniversalGuiMover.clampY((int)mouseY, draggedContainer, window);
            }
            dragging = true;
        } else {
            draggedContainer = null;
            dragging = false;
        }
    }

    private boolean isMouseOver(HudContainer container, double mouseX, double mouseY) {
        return mouseX >= (double)container.x && mouseX <= (double)(container.x + container.getScaledWidth()) && mouseY >= (double)container.y && mouseY <= (double)(container.y + container.getScaledHeight());
    }

    public static void trackHudContainer(String id, HudContainer container) {
        if (hudContainers.containsKey(id)) {
            HudContainer saved = hudContainers.get(id);
            container.x = saved.x;
            container.y = saved.y;
        }
        hudContainers.put(id, container);
        UniversalGuiMover.clampPosition(container, class_310.method_1551().method_22683());
    }

    public static void clampPosition(HudContainer container, class_1041 window) {
        if (window != null) {
            container.x = UniversalGuiMover.clampX(container.x, container, window);
            container.y = UniversalGuiMover.clampY(container.y, container, window);
        }
    }

    private static int clampX(int x, HudContainer container, class_1041 window) {
        return Math.max(5, Math.min(x, window.method_4486() - container.getScaledWidth() - 5));
    }

    private static int clampY(int y, HudContainer container, class_1041 window) {
        return Math.max(5, Math.min(y, window.method_4502() - container.getScaledHeight() - 5));
    }

    public static HudContainer getHudContainer(String id) {
        return hudContainers.get(id);
    }

    public static float getGlobalTextScale() {
        return globalTextScale;
    }

    public static boolean isDragging() {
        return dragging;
    }

    public static boolean isMovementModeActive() {
        return isMovementMode;
    }

    static {
        isMovementMode = false;
        draggedContainer = null;
        hudContainers = new HashMap<String, HudContainer>();
        globalTextScale = 1.0f;
    }

    @Environment(value=EnvType.CLIENT)
    public static class HudContainer {
        public int x;
        public int y;
        public int baseWidth;
        public int baseHeight;
        public final int lineCount;

        public HudContainer(int x, int y, int baseWidth, int baseHeight, int lineCount) {
            this.x = x;
            this.y = y;
            this.baseWidth = baseWidth;
            this.baseHeight = baseHeight;
            this.lineCount = lineCount;
        }

        public int getScaledWidth() {
            return (int)((float)this.baseWidth * globalTextScale);
        }

        public int getScaledHeight() {
            return (int)((float)(this.baseHeight * this.lineCount) * globalTextScale);
        }
    }
}

