/*
 * Decompiled with CFR 0.152.
 */
package chat.cosmic.client.client;

import chat.cosmic.client.client.UniversalGuiMover;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.message.v1.ClientSendMessageEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1041;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class XPBoosterMod
implements ClientModInitializer {
    private static final Map<String, Integer> boosters = new HashMap<String, Integer>();
    private static final Map<String, Integer> chatTriggers = new HashMap<String, Integer>();
    private static int tickCounter = 0;
    private static final class_2960 XP_BOTTLE_TEXTURE = new class_2960("xpbooster", "textures/gui/xp_bottle.png");
    private static final class_2960 ISLAND_BOOSTER_TEXTURE = new class_2960("xpbooster", "textures/gui/island_booster.png");
    private static final class_2960 HEAL_COOLDOWN_TEXTURE = new class_2960("xpbooster", "textures/gui/heal_cooldown.png");
    private static final class_2960 FEED_COOLDOWN_TEXTURE = new class_2960("xpbooster", "textures/gui/feed_cooldown.png");
    private static final class_2960 FIX_COOLDOWN_TEXTURE = new class_2960("xpbooster", "textures/gui/fix_cooldown.png");
    private static final class_2960 NEAR_COOLDOWN_TEXTURE = new class_2960("xpbooster", "textures/gui/near_cooldown.png");
    private static final class_2960 CURSE_TEXTURE = new class_2960("xpbooster", "textures/gui/curse.png");
    private static final int ICON_SIZE = 16;
    private static final int TEXT_COLOR = 0xFFFFFF;
    private static final int CURSE_COLOR = 0xFF5555;
    private static final int Y_OFFSET = 10;
    private static final float NAME_SCALE = 0.7f;
    private static final float TIMER_SCALE = 0.7f;
    private static final Map<String, UniversalGuiMover.HudContainer> boosterContainers = new HashMap<String, UniversalGuiMover.HudContainer>();
    private static final UniversalGuiMover.HudContainer curseContainer = new UniversalGuiMover.HudContainer(0, 60, 16, 16, 1);
    private static final Pattern CURSE_PATTERN = Pattern.compile("You have been cursed! You will be siphoned to 1 HP in (\\d+)s!");

    public void onInitializeClient() {
        System.out.println("XP Booster Mod Initialized!");
        boosterContainers.put("2x Island XP Booster", new UniversalGuiMover.HudContainer(0, 10, 16, 16, 1));
        boosterContainers.put("/heal", new UniversalGuiMover.HudContainer(0, 10, 16, 16, 1));
        boosterContainers.put("/feed", new UniversalGuiMover.HudContainer(0, 10, 16, 16, 1));
        boosterContainers.put("/fix", new UniversalGuiMover.HudContainer(0, 10, 16, 16, 1));
        boosterContainers.put("/near", new UniversalGuiMover.HudContainer(0, 10, 16, 16, 1));
        boosterContainers.forEach(UniversalGuiMover::trackHudContainer);
        UniversalGuiMover.trackHudContainer("Curse", curseContainer);
        HudRenderCallback.EVENT.register(this::renderHud);
        ClientReceiveMessageEvents.GAME.register(this::handleGameMessage);
        ClientSendMessageEvents.ALLOW_COMMAND.register(command -> {
            this.onCommandSent(command);
            return true;
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (++tickCounter >= 20) {
                tickCounter = 0;
                boosters.replaceAll((k, v) -> v > 0 ? v - 1 : 0);
                boosters.values().removeIf(v -> v <= 0);
                chatTriggers.replaceAll((k, v) -> v > 0 ? v - 1 : 0);
                chatTriggers.values().removeIf(v -> v <= 0);
            }
        });
    }

    private void handleGameMessage(class_2561 text, boolean overlay) {
        Matcher matcher;
        if (overlay) {
            return;
        }
        String message = text.getString();
        String lowerMessage = message.toLowerCase();
        if (lowerMessage.contains("2x island xp booster") && lowerMessage.contains("activated for")) {
            String[] parts = message.split("activated for ");
            if (parts.length < 2) {
                return;
            }
            String durationPart = parts[1].split("[^0-9hHmM]")[0];
            int seconds = this.parseDuration(durationPart);
            if (seconds > 0) {
                boosters.put("2x Island XP Booster", seconds);
            }
        } else if (lowerMessage.contains("you have been cursed") && lowerMessage.contains("siphoned to 1 hp") && (matcher = CURSE_PATTERN.matcher(message)).find()) {
            try {
                int seconds = Integer.parseInt(matcher.group(1));
                if (seconds > 0) {
                    chatTriggers.put("Curse", seconds);
                }
            }
            catch (NumberFormatException e) {
                System.err.println("Failed to parse curse duration: " + message);
            }
        }
    }

    private int parseDuration(String durationStr) {
        durationStr = durationStr.replaceAll("[^0-9hHmM]", "").toLowerCase();
        int totalSeconds = 0;
        try {
            String[] minutesParts;
            if (durationStr.contains("h")) {
                String[] hoursParts = durationStr.split("h");
                if (hoursParts[0].length() > 0) {
                    totalSeconds += Integer.parseInt(hoursParts[0]) * 3600;
                }
                String string = durationStr = hoursParts.length > 1 ? hoursParts[1] : "";
            }
            if (durationStr.contains("m") && (minutesParts = durationStr.split("m"))[0].length() > 0) {
                totalSeconds += Integer.parseInt(minutesParts[0]) * 60;
            }
        }
        catch (NumberFormatException e) {
            System.err.println("Failed to parse booster duration: " + durationStr);
        }
        return totalSeconds;
    }

    private void onCommandSent(String command) {
        String lowerCommand = command.toLowerCase();
        if (lowerCommand.equals("fix") && !boosters.containsKey("/fix")) {
            boosters.put("/fix", 120);
        } else if (lowerCommand.equals("heal") && !boosters.containsKey("/heal")) {
            boosters.put("/heal", 300);
        } else if ((lowerCommand.equals("feed") || lowerCommand.equals("eat")) && !boosters.containsKey("/feed")) {
            boosters.put("/feed", 300);
        } else if (lowerCommand.equals("fix all") && !boosters.containsKey("/fix")) {
            boosters.put("/fix", 120);
        } else if (lowerCommand.equals("near") && !boosters.containsKey("/near")) {
            boosters.put("/near", 30);
        }
    }

    private void renderHud(class_332 context, float tickDelta) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        class_1041 window = client.method_22683();
        if (window == null) {
            return;
        }
        float globalScale = UniversalGuiMover.getGlobalTextScale();
        int scaledIconSize = (int)(16.0f * globalScale);
        int screenWidth = window.method_4486();
        int screenHeight = window.method_4502();
        boolean forceShow = UniversalGuiMover.isMovementModeActive();
        HashMap<String, Integer> visibleBoosters = new HashMap<String, Integer>(boosters);
        if (forceShow) {
            boosterContainers.keySet().forEach(key -> visibleBoosters.putIfAbsent((String)key, 0));
        }
        if (!visibleBoosters.isEmpty()) {
            boolean needsCentering;
            int maxX = screenWidth - scaledIconSize - 5;
            int minY = 5;
            int maxY = screenHeight - scaledIconSize * 2 - 5;
            boolean bl = needsCentering = !UniversalGuiMover.isMovementModeActive() && boosterContainers.values().stream().anyMatch(container -> container.x == 0);
            if (needsCentering) {
                int startX;
                int totalBoosters = visibleBoosters.size();
                int totalWidth = totalBoosters * (scaledIconSize + 20);
                int xPos = startX = screenWidth / 2 - totalWidth / 2;
                for (UniversalGuiMover.HudContainer container2 : boosterContainers.values()) {
                    if (container2.x != 0) continue;
                    container2.x = xPos;
                    container2.y = 10;
                    xPos += scaledIconSize + 20;
                }
            }
            for (Map.Entry entry : visibleBoosters.entrySet()) {
                String boosterType = (String)entry.getKey();
                UniversalGuiMover.HudContainer container3 = boosterContainers.get(boosterType);
                if (container3 == null) continue;
                if (!UniversalGuiMover.isMovementModeActive()) {
                    container3.x = Math.max(5, Math.min(container3.x, maxX));
                    container3.y = Math.max(minY, Math.min(container3.y, maxY));
                }
                int timeLeft = (Integer)entry.getValue();
                class_2960 texture = this.getBoosterTexture(boosterType);
                String timeText = timeLeft > 0 ? this.formatCountdown(timeLeft) : "Cooldown";
                context.method_51448().method_22903();
                context.method_51448().method_46416((float)container3.x, (float)container3.y, 0.0f);
                context.method_51448().method_22905(globalScale, globalScale, 1.0f);
                if (forceShow && timeLeft <= 0) {
                    context.method_51422(1.0f, 1.0f, 1.0f, 0.4f);
                }
                context.method_25290(texture, 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
                context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
                if (timeLeft > 0 || forceShow) {
                    float textYOffset = 18.0f;
                    context.method_51448().method_22903();
                    context.method_51448().method_46416(8.0f, textYOffset, 0.0f);
                    context.method_51448().method_22905(0.7f, 0.7f, 1.0f);
                    int nameWidth = client.field_1772.method_1727(boosterType);
                    context.method_51433(client.field_1772, boosterType, -nameWidth / 2, 0, 0xFFFFFF, true);
                    context.method_51448().method_22909();
                    context.method_51448().method_22903();
                    context.method_51448().method_46416(8.0f, textYOffset + 10.0f, 0.0f);
                    context.method_51448().method_22905(0.7f, 0.7f, 1.0f);
                    int timeWidth = client.field_1772.method_1727(timeText);
                    context.method_51433(client.field_1772, timeText, -timeWidth / 2, 0, 0xFFFFFF, true);
                    context.method_51448().method_22909();
                }
                context.method_51448().method_22909();
            }
        }
        if (chatTriggers.containsKey("Curse") || forceShow) {
            Object curseText;
            int curseTime = chatTriggers.getOrDefault("Curse", 0);
            Object object = curseText = curseTime > 0 ? "Curse: " + curseTime + "s" : "Curse";
            if (!UniversalGuiMover.isMovementModeActive()) {
                XPBoosterMod.curseContainer.x = Math.max(5, Math.min(XPBoosterMod.curseContainer.x, screenWidth - scaledIconSize - 5));
                XPBoosterMod.curseContainer.y = Math.max(5, Math.min(XPBoosterMod.curseContainer.y, screenHeight - scaledIconSize * 2 - 5));
            }
            context.method_51448().method_22903();
            context.method_51448().method_46416((float)XPBoosterMod.curseContainer.x, (float)XPBoosterMod.curseContainer.y, 0.0f);
            context.method_51448().method_22905(globalScale, globalScale, 1.0f);
            if (forceShow && curseTime <= 0) {
                context.method_51422(1.0f, 1.0f, 1.0f, 0.4f);
            }
            context.method_25290(CURSE_TEXTURE, 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
            context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
            if (curseTime > 0 || forceShow) {
                float textYOffset = 18.0f;
                context.method_51448().method_22903();
                context.method_51448().method_46416(8.0f, textYOffset, 0.0f);
                context.method_51448().method_22905(0.7f, 0.7f, 1.0f);
                int nameWidth = client.field_1772.method_1727("Curse");
                context.method_51433(client.field_1772, "Curse", -nameWidth / 2, 0, 0xFF5555, true);
                context.method_51448().method_22909();
                if (curseTime > 0) {
                    context.method_51448().method_22903();
                    context.method_51448().method_46416(8.0f, textYOffset + 10.0f, 0.0f);
                    context.method_51448().method_22905(0.7f, 0.7f, 1.0f);
                    int timeWidth = client.field_1772.method_1727((String)curseText);
                    context.method_51433(client.field_1772, (String)curseText, -timeWidth / 2, 0, 0xFF5555, true);
                    context.method_51448().method_22909();
                }
            }
            context.method_51448().method_22909();
        }
    }

    private class_2960 getBoosterTexture(String boosterType) {
        switch (boosterType) {
            case "2x Island XP Booster": {
                return ISLAND_BOOSTER_TEXTURE;
            }
            case "/heal": {
                return HEAL_COOLDOWN_TEXTURE;
            }
            case "/feed": {
                return FEED_COOLDOWN_TEXTURE;
            }
            case "/fix": {
                return FIX_COOLDOWN_TEXTURE;
            }
            case "/near": {
                return NEAR_COOLDOWN_TEXTURE;
            }
        }
        return XP_BOTTLE_TEXTURE;
    }

    private String formatCountdown(int seconds) {
        if (seconds > 60) {
            return seconds / 60 + "m " + seconds % 60 + "s";
        }
        return seconds + "s";
    }
}

