/*
 * Decompiled with CFR 0.152.
 */
package chat.cosmic.client;

import chat.cosmic.client.client.UniversalGuiMover;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_640;

@Environment(value=EnvType.CLIENT)
public class join
implements ClientModInitializer {
    public static boolean NOTIFICATIONS_ENABLED = false;
    public static boolean GUI_VISIBLE = false;
    public static Set<String> onlinePlayers = new HashSet<String>();
    public static Set<String> ignoredPlayers = new HashSet<String>();
    public static Map<String, String> playerColors = new HashMap<String, String>();
    private static class_304 toggleNotificationsKey;
    private static class_304 toggleGuiKey;
    private static final UniversalGuiMover.HudContainer hudContainer;
    private static final File configFile;

    public void onInitializeClient() {
        UniversalGuiMover.trackHudContainer("playerListHud", hudContainer);
        this.loadConfig();
        ClientLifecycleEvents.CLIENT_STOPPING.register(client -> this.saveConfig());
        toggleNotificationsKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("toggle notifications", class_3675.class_307.field_1668, 78, "join"));
        toggleGuiKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("toggle gui", class_3675.class_307.field_1668, 71, "join"));
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"ignore").then(ClientCommandManager.argument((String)"username", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String username = StringArgumentType.getString((CommandContext)context, (String)"username").toLowerCase();
            this.toggleIgnoredPlayer(username);
            ((FabricClientCommandSource)context.getSource()).sendFeedback(class_2561.method_30163((String)(username + " is now " + (this.isIgnored(username) ? "ignored" : "unignored"))));
            return 1;
        }))));
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"setguipos").then(ClientCommandManager.argument((String)"x", (ArgumentType)IntegerArgumentType.integer()).then(ClientCommandManager.argument((String)"y", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            int x = IntegerArgumentType.getInteger((CommandContext)context, (String)"x");
            int y = IntegerArgumentType.getInteger((CommandContext)context, (String)"y");
            join.hudContainer.x = x;
            join.hudContainer.y = y;
            UniversalGuiMover.clampPosition(hudContainer, class_310.method_1551().method_22683());
            this.saveConfig();
            ((FabricClientCommandSource)context.getSource()).sendFeedback(class_2561.method_30163((String)("GUI position set to (" + x + ", " + y + ")")));
            return 1;
        })))));
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"pr").then(ClientCommandManager.argument((String)"username", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            this.getOnlinePlayerNames().forEach(player -> builder.suggest(player));
            return builder.buildFuture();
        }).executes(context -> {
            String username = StringArgumentType.getString((CommandContext)context, (String)"username").toLowerCase();
            this.setPlayerColor(username, "red");
            ((FabricClientCommandSource)context.getSource()).sendFeedback(class_2561.method_30163((String)(username + "'s name color set to red.")));
            return 1;
        }))));
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"pg").then(ClientCommandManager.argument((String)"username", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            this.getOnlinePlayerNames().forEach(player -> builder.suggest(player));
            return builder.buildFuture();
        }).executes(context -> {
            String username = StringArgumentType.getString((CommandContext)context, (String)"username").toLowerCase();
            this.setPlayerColor(username, "green");
            ((FabricClientCommandSource)context.getSource()).sendFeedback(class_2561.method_30163((String)(username + "'s name color set to green.")));
            return 1;
        }))));
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"pdb").then(ClientCommandManager.argument((String)"username", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            this.getOnlinePlayerNames().forEach(player -> builder.suggest(player));
            return builder.buildFuture();
        }).executes(context -> {
            String username = StringArgumentType.getString((CommandContext)context, (String)"username").toLowerCase();
            this.setPlayerColor(username, "dark_blue");
            ((FabricClientCommandSource)context.getSource()).sendFeedback(class_2561.method_30163((String)(username + "'s name color set to dark blue.")));
            return 1;
        }))));
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"prr").executes(context -> {
            this.resetPlayerColors();
            ((FabricClientCommandSource)context.getSource()).sendFeedback(class_2561.method_30163((String)"Reset all player colors to default."));
            return 1;
        })));
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"pw").then(ClientCommandManager.argument((String)"username", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            this.getOnlinePlayerNames().forEach(player -> builder.suggest(player));
            return builder.buildFuture();
        }).executes(context -> {
            String username = StringArgumentType.getString((CommandContext)context, (String)"username").toLowerCase();
            this.resetPlayerColor(username);
            ((FabricClientCommandSource)context.getSource()).sendFeedback(class_2561.method_30163((String)(username + "'s name color reset to default.")));
            return 1;
        }))));
        ClientTickEvents.END_CLIENT_TICK.register(this::onClientTick);
        HudRenderCallback.EVENT.register(this::onHudRender);
    }

    private List<String> getOnlinePlayerNames() {
        ArrayList<String> playerNames = new ArrayList<String>();
        if (class_310.method_1551().method_1562() != null) {
            for (class_640 entry : class_310.method_1551().method_1562().method_2880()) {
                String username = entry.method_2966().getName();
                if (this.isIgnored(username)) continue;
                playerNames.add(username);
            }
        }
        return playerNames;
    }

    private void onClientTick(class_310 client) {
        if (client.field_1724 == null) {
            return;
        }
        if (toggleNotificationsKey.method_1436()) {
            NOTIFICATIONS_ENABLED = !NOTIFICATIONS_ENABLED;
            client.field_1724.method_7353(class_2561.method_30163((String)("Notifications " + (NOTIFICATIONS_ENABLED ? "enabled" : "disabled"))), false);
            this.saveConfig();
        }
        if (toggleGuiKey.method_1436()) {
            GUI_VISIBLE = !GUI_VISIBLE;
            client.field_1724.method_7353(class_2561.method_30163((String)("GUI " + (GUI_VISIBLE ? "enabled" : "disabled"))), false);
            this.saveConfig();
        }
        if (client.method_1562() != null) {
            HashSet<String> currentPlayers = new HashSet<String>();
            for (class_640 entry : client.method_1562().method_2880()) {
                String username = entry.method_2966().getName().toLowerCase();
                if (this.isIgnored(username) || !this.isValidPlayer(username)) continue;
                currentPlayers.add(username);
            }
            for (String player : currentPlayers) {
                if (onlinePlayers.contains(player) || !NOTIFICATIONS_ENABLED) continue;
                client.field_1724.method_7353(class_2561.method_30163((String)(player + " has joined the server!")), false);
            }
            for (String player : onlinePlayers) {
                if (currentPlayers.contains(player) || !NOTIFICATIONS_ENABLED) continue;
                client.field_1724.method_7353(class_2561.method_30163((String)(player + " has left the server!")), false);
            }
            onlinePlayers = currentPlayers;
        }
    }

    private void onHudRender(class_332 context, float tickDelta) {
        if (GUI_VISIBLE && class_310.method_1551().field_1724 != null) {
            UniversalGuiMover.HudContainer container = UniversalGuiMover.getHudContainer("playerListHud");
            if (container == null) {
                return;
            }
            UniversalGuiMover.clampPosition(container, class_310.method_1551().method_22683());
            float scale = UniversalGuiMover.getGlobalTextScale();
            int lineHeight = 12;
            int maxPlayersPerColumn = 15;
            int columnWidth = 90;
            int totalPlayers = onlinePlayers.size();
            int columns = (int)Math.ceil((double)totalPlayers / (double)maxPlayersPerColumn);
            context.method_51448().method_22903();
            context.method_51448().method_46416((float)container.x, (float)container.y, 0.0f);
            context.method_51448().method_22905(scale, scale, 1.0f);
            int playerIndex = 0;
            for (int col = 0; col < columns; ++col) {
                int columnX = col * columnWidth;
                for (int row = 0; row < maxPlayersPerColumn && playerIndex < totalPlayers; ++playerIndex, ++row) {
                    String color;
                    String player = onlinePlayers.toArray(new String[0])[playerIndex];
                    if (this.isIgnored(player) || !this.isValidPlayer(player)) continue;
                    int textColor = switch (color = playerColors.getOrDefault(player.toLowerCase(), "default")) {
                        case "red" -> 0xFF0000;
                        case "green" -> 65280;
                        case "dark_blue" -> 0x336699;
                        default -> 0xFFFFFF;
                    };
                    context.method_51433(class_310.method_1551().field_1772, player, columnX, row * lineHeight, textColor, true);
                }
            }
            context.method_51448().method_22909();
        }
    }

    private boolean isIgnored(String username) {
        return ignoredPlayers.contains(username.toLowerCase());
    }

    private boolean isValidPlayer(String username) {
        return !username.startsWith("slot_") && !username.startsWith("minecraft:") && username.length() >= 3 && username.length() <= 16 && username.matches("[a-zA-Z0-9_]+");
    }

    private void toggleIgnoredPlayer(String username) {
        if (ignoredPlayers.contains(username = username.toLowerCase())) {
            ignoredPlayers.remove(username);
        } else {
            ignoredPlayers.add(username);
        }
        this.saveIgnoredPlayers();
        this.saveConfig();
    }

    private void saveIgnoredPlayers() {
        File ignoreFile = new File("config/ignore.txt");
        try (FileWriter writer = new FileWriter(ignoreFile);){
            for (String player : ignoredPlayers) {
                writer.write(player + System.lineSeparator());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadConfig() {
        Properties props = new Properties();
        if (configFile.exists()) {
            try (FileInputStream input = new FileInputStream(configFile);){
                String playerColorsString;
                props.load(input);
                NOTIFICATIONS_ENABLED = Boolean.parseBoolean(props.getProperty("notifications_enabled", "false"));
                GUI_VISIBLE = Boolean.parseBoolean(props.getProperty("gui_visible", "true"));
                UniversalGuiMover.loadGuiPositions(props);
                String ignoredPlayersString = props.getProperty("ignored_players", "");
                if (!ignoredPlayersString.isEmpty()) {
                    ignoredPlayers.addAll(Set.of(ignoredPlayersString.split(",")));
                }
                if (!(playerColorsString = props.getProperty("player_colors", "")).isEmpty()) {
                    for (String entry : playerColorsString.split(",")) {
                        String[] parts = entry.split(":");
                        if (parts.length != 2) continue;
                        playerColors.put(parts[0].toLowerCase(), parts[1]);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void saveConfig() {
        Properties props = new Properties();
        props.setProperty("notifications_enabled", Boolean.toString(NOTIFICATIONS_ENABLED));
        props.setProperty("gui_visible", Boolean.toString(GUI_VISIBLE));
        props.setProperty("ignored_players", String.join((CharSequence)",", ignoredPlayers));
        UniversalGuiMover.saveGuiPositions(props);
        StringBuilder playerColorsString = new StringBuilder();
        playerColors.forEach((k, v) -> playerColorsString.append((String)k).append(":").append((String)v).append(","));
        if (playerColorsString.length() > 0) {
            playerColorsString.setLength(playerColorsString.length() - 1);
        }
        props.setProperty("player_colors", playerColorsString.toString());
        try (FileOutputStream output = new FileOutputStream(configFile);){
            props.store(output, "Untitled20 Mod Configuration");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void setPlayerColor(String username, String color) {
        playerColors.put(username.toLowerCase(), color);
        this.saveConfig();
    }

    private void resetPlayerColors() {
        playerColors.clear();
        this.saveConfig();
    }

    private void resetPlayerColor(String username) {
        playerColors.remove(username.toLowerCase());
        this.saveConfig();
    }

    static {
        hudContainer = new UniversalGuiMover.HudContainer(10, 10, 100, 40, 1);
        configFile = new File("config/untitled20_mod.properties");
    }
}

