/*
 * Decompiled with CFR 0.152.
 */
package chat.cosmic.client.mixin;

import chat.cosmic.client.client.HighlightSearchMod;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_465;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_465.class})
public abstract class HandledScreenMixin
extends class_437 {
    @Shadow
    protected int field_2776;
    @Shadow
    protected int field_2800;
    @Unique
    private class_342 searchField;
    @Unique
    private static String persistentLastSearch = "";
    @Unique
    private static int searchBarX = -1;
    @Unique
    private static int searchBarY = -1;
    @Unique
    private boolean isDragging = false;
    @Unique
    private int dragOffsetX;
    @Unique
    private int dragOffsetY;
    @Unique
    private long lastClickTime = 0L;
    @Unique
    private boolean isGrayedOut = false;

    protected HandledScreenMixin(class_2561 title) {
        super(title);
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void addSearchBox(CallbackInfo ci) {
        if (!HighlightSearchMod.isSearchVisible) {
            return;
        }
        class_465 screen = (class_465)this;
        if (searchBarX == -1 || searchBarY == -1) {
            searchBarX = screen.field_22789 / 2 - 85;
            searchBarY = screen.field_22790 / 2 + 120;
        }
        this.searchField = new class_342(this.field_22793, searchBarX, searchBarY, 170, 20, (class_2561)class_2561.method_43471((String)"item.search"));
        this.method_25429((class_364)this.searchField);
        this.searchField.method_1880(50);
        this.searchField.method_1852(persistentLastSearch);
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void onRender(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (!HighlightSearchMod.isSearchVisible || this.searchField == null) {
            return;
        }
        class_465 screen = (class_465)this;
        this.searchField.method_46421(searchBarX);
        this.searchField.method_46419(searchBarY);
        this.searchField.method_25394(context, mouseX, mouseY, delta);
        String currentSearch = this.searchField.method_1882().toLowerCase();
        if (!currentSearch.equals(persistentLastSearch)) {
            persistentLastSearch = currentSearch;
        }
        for (class_1735 slot : screen.method_17577().field_7761) {
            int xPos = slot.field_7873 + this.field_2776;
            int yPos = slot.field_7872 + this.field_2800;
            if (slot.method_7681()) {
                class_1799 stack = slot.method_7677();
                boolean matches = this.itemMatchesSearch(stack, currentSearch);
                if (matches && !currentSearch.isEmpty()) {
                    context.method_25294(xPos, yPos, xPos + 16, yPos + 16, 0x60FFFF00);
                }
                if (matches || currentSearch.isEmpty() || !this.isGrayedOut) continue;
                context.method_25294(xPos, yPos, xPos + 16, yPos + 16, -2143009724);
                continue;
            }
            if (!this.isGrayedOut) continue;
            context.method_25294(xPos, yPos, xPos + 16, yPos + 16, -2143009724);
        }
    }

    @Unique
    private boolean itemMatchesSearch(class_1799 stack, String searchTerm) {
        if (searchTerm.isEmpty()) {
            return false;
        }
        if (stack.method_7964().getString().toLowerCase().contains(searchTerm)) {
            return true;
        }
        List tooltip = stack.method_7950(null, (class_1836)class_1836.class_1837.field_41071);
        for (int i = 1; i < tooltip.size(); ++i) {
            String line = ((class_2561)tooltip.get(i)).getString().toLowerCase();
            if (line.contains("durability") || line.matches(".*\\d+\\s*/\\s*\\d+.*") || !line.contains(searchTerm)) continue;
            return true;
        }
        return false;
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void onMouseClicked(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        if (this.searchField == null) {
            return;
        }
        if (button == 0) {
            class_465 screen = (class_465)this;
            if (this.searchField.method_25405(mouseX, mouseY)) {
                long currentTime = System.currentTimeMillis();
                if (currentTime - this.lastClickTime < 250L) {
                    this.isGrayedOut = !this.isGrayedOut;
                }
                this.lastClickTime = currentTime;
                this.isDragging = true;
                this.dragOffsetX = (int)mouseX - searchBarX;
                this.dragOffsetY = (int)mouseY - searchBarY;
                return;
            }
            for (class_1735 slot : screen.method_17577().field_7761) {
                int xPos = slot.field_7873 + this.field_2776;
                int yPos = slot.field_7872 + this.field_2800;
                if (!(mouseX >= (double)xPos) || !(mouseX <= (double)(xPos + 16)) || !(mouseY >= (double)yPos) || !(mouseY <= (double)(yPos + 16))) continue;
                this.searchField.method_25365(false);
                return;
            }
        }
    }

    @Inject(method={"mouseReleased"}, at={@At(value="HEAD")}, cancellable=true)
    private void onMouseReleased(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        if (button == 0) {
            this.isDragging = false;
        }
    }

    @Inject(method={"mouseDragged"}, at={@At(value="HEAD")}, cancellable=true)
    private void onMouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY, CallbackInfoReturnable<Boolean> cir) {
        if (this.isDragging && button == 0 && this.searchField != null) {
            searchBarX = (int)mouseX - this.dragOffsetX;
            searchBarY = (int)mouseY - this.dragOffsetY;
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    private void onKeyPressed(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (!HighlightSearchMod.isSearchVisible || this.searchField == null) {
            return;
        }
        if (this.searchField.method_25370()) {
            if (keyCode == 256) {
                this.field_22787.method_1507(null);
                cir.setReturnValue((Object)true);
            }
            if (keyCode == 69) {
                cir.setReturnValue((Object)true);
            }
            return;
        }
        if (keyCode == 82) {
            HighlightSearchMod.isSearchVisible = !HighlightSearchMod.isSearchVisible;
            cir.setReturnValue((Object)true);
        }
    }
}

