/*
 * Decompiled with CFR 0.152.
 */
package me.drex.vanillapermissions.util;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.RootCommandNode;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.stream.Stream;
import me.drex.vanillapermissions.VanillaPermissionsMod;
import me.drex.vanillapermissions.mixin.CommandSourceStackAccessor;
import me.drex.vanillapermissions.util.Permission;
import me.lucko.fabric.api.permissions.v0.Options;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_3222;

public class ArgumentPermission {
    public static void validate(CommandContext<class_2168> context, String selector, Collection<?> selected) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_2165 commandSource = ((CommandSourceStackAccessor)source).getSource();
        class_3222 attachedPlayer = source.method_44023();
        if (attachedPlayer == null) {
            return;
        }
        if (attachedPlayer.method_64401() != commandSource) {
            return;
        }
        String[] parts = context.getRootNode() instanceof RootCommandNode ? (String[])context.getNodes().stream().map(node -> node.getNode().getName()).toArray(String[]::new) : (String[])source.method_9211().method_3734().method_9235().getPath(((ParsedCommandNode)Iterables.getLast((Iterable)context.getNodes())).getNode()).toArray(String[]::new);
        String name = Permission.build(parts[0], selector, Permission.build(1, parts.length, parts));
        Optional limit = Options.get((class_2172)source, (String)Permission.SELECTOR_LIMIT.formatted(name), Integer::parseInt);
        if (limit.isPresent() && (Integer)limit.get() < selected.size()) {
            throw class_2186.field_9862.create();
        }
        boolean entity = Permissions.check((class_2172)source, (String)Permission.SELECTOR_ENTITY.formatted(name), (boolean)true);
        boolean player = Permissions.check((class_2172)source, (String)Permission.SELECTOR_PLAYER.formatted(name), (boolean)true);
        boolean self = Permissions.check((class_2172)source, (String)Permission.SELECTOR_SELF.formatted(name), (boolean)true);
        String weight = Permission.SELECTOR_WEIGHT.formatted(name);
        Optional sourceWeight = Options.get((class_2172)source, (String)weight, Integer::parseInt);
        boolean sourceWeightPresent = sourceWeight.isPresent();
        if (entity && player && self && !sourceWeightPresent) {
            return;
        }
        Integer sourceWeightValue = sourceWeight.orElse(0);
        GameProfile sourcePlayer = attachedPlayer.method_7334();
        try {
            CompletableFuture.allOf((CompletableFuture[])((Stream)selected.stream().mapMulti((object, consumer) -> {
                class_1657 selectedPlayer;
                Object selectedEntity = object;
                if (selectedEntity instanceof class_1657) {
                    selectedPlayer = (class_1657)selectedEntity;
                    selectedEntity = selectedPlayer.method_7334();
                }
                if (selectedEntity instanceof class_1297) {
                    if (!entity) {
                        ArgumentPermission.throwSelectorError();
                    }
                } else if (selectedEntity instanceof GameProfile) {
                    selectedPlayer = (GameProfile)selectedEntity;
                    if (selectedPlayer.equals((Object)sourcePlayer)) {
                        if (!self) {
                            ArgumentPermission.throwSelectorError();
                        }
                    } else {
                        if (!player) {
                            ArgumentPermission.throwSelectorError();
                        }
                        if (!sourceWeightPresent) {
                            return;
                        }
                        consumer.accept(Options.get((GameProfile)selectedPlayer, (String)weight, Integer::parseInt).thenAcceptAsync(selectedWeight -> {
                            if (selectedWeight.isPresent() && (Integer)selectedWeight.get() > sourceWeightValue) {
                                throw new CompletionException((Throwable)class_2186.field_9862.create());
                            }
                        }));
                    }
                } else {
                    ArgumentPermission.throwSelectorError();
                }
            }).unordered()).toArray(CompletableFuture[]::new)).get();
        }
        catch (Exception e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof CommandSyntaxException) {
                CommandSyntaxException exception = (CommandSyntaxException)throwable;
                throw exception;
            }
            VanillaPermissionsMod.LOGGER.warn("Bad selector in command {}", (Object)name, (Object)e);
            throw class_2186.field_9862.create();
        }
    }

    private static void throwSelectorError() throws RuntimeException {
        throw new RuntimeException((Throwable)class_2186.field_9862.create());
    }
}

