/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.impatient;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import net.biorfn.impatient.ImpatientImpl;
import net.biorfn.impatient.ImpatientMod;
import net.biorfn.impatient.api.ImpatientAPI;
import net.biorfn.impatient.platform.PlatformUtils;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.MarkerManager;

public class Config {
    public static Config INSTANCE;
    public final boolean log_placement = PlatformUtils.getInstance().isDedicatedServer();
    private final Tier[] tiers = new Tier[]{new Tier("normal", 4, 4, 1), new Tier("compressed", 36, 4, 1), new Tier("double_compressed", 324, 4, 1)};

    public static void initialize() {
        Gson gson = new GsonBuilder().disableInnerClassSerialization().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).setPrettyPrinting().create();
        Path configDir = PlatformUtils.getInstance().getConfigPath();
        MarkerManager.Log4jMarker marker = new MarkerManager.Log4jMarker("impatient");
        Config config = null;
        try {
            Path parentDir = configDir.getParent();
            if (parentDir != null) {
                Files.createDirectories(parentDir, new FileAttribute[0]);
            } else {
                ImpatientMod.LOGGER.warn("The config directory has no parent: " + String.valueOf(configDir));
            }
        }
        catch (IOException e) {
            ImpatientMod.LOGGER.warn(marker.getName() + ":Failed to create directory: " + e.getMessage(), (Throwable)e);
            config = new Config();
        }
        if (config == null) {
            if (Files.exists(configDir, new LinkOption[0])) {
                try (BufferedReader reader = Files.newBufferedReader(configDir);){
                    config = (Config)gson.fromJson((Reader)reader, Config.class);
                }
                catch (IOException e) {
                    ImpatientMod.LOGGER.warn(marker.getName() + "Failed to read Impatient config file, using default config.");
                    config = new Config();
                }
            } else {
                config = new Config();
                try (BufferedWriter writer = Files.newBufferedWriter(configDir, StandardOpenOption.CREATE_NEW);){
                    gson.toJson((Object)config, (Appendable)writer);
                }
                catch (IOException e) {
                    ImpatientMod.LOGGER.warn(marker.getName() + "Failed to save default Impatient config file: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        if ((INSTANCE = config) != null) {
            INSTANCE.onLoaded();
        } else {
            ImpatientMod.LOGGER.warn("Configuration instance is null. Skipping onLoaded().");
        }
    }

    private void onLoaded() {
        for (Tier tier : this.tiers) {
            ((ImpatientImpl)ImpatientAPI.INSTANCE).registerTier(ResourceLocation.fromNamespaceAndPath((String)"impatient", (String)tier.name), tier.max_speed, tier.xz_range, tier.y_range);
        }
    }

    static class Tier {
        final String name;
        final int max_speed;
        final int xz_range;
        final int y_range;

        Tier(String name, int max_speed, int xz_range, int y_range) {
            this.name = name;
            this.max_speed = max_speed;
            this.xz_range = xz_range;
            this.y_range = y_range;
        }
    }
}

