/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.impatient;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.biorfn.impatient.ImpatientMod;
import net.biorfn.impatient.api.ImpatientAPI;
import net.biorfn.impatient.api.Tier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class ImpatientImpl
implements ImpatientAPI {
    private final Map<ResourceLocation, Tier> localTiers = new HashMap<ResourceLocation, Tier>();
    private final Set<Block> blacklistedBlocks = new HashSet<Block>();
    private final Set<BlockEntityType<?>> blacklistedTiles = new HashSet();
    private Map<ResourceLocation, Tier> remoteTiers = new HashMap<ResourceLocation, Tier>();

    public void registerTier(ResourceLocation name, int maxSpeed, int xzRange, int yRange) {
        if (this.localTiers.containsKey(name)) {
            ImpatientMod.LOGGER.warn("Tier with id {} has already been registered.", (Object)name);
            return;
        }
        Tier tier = new Tier(maxSpeed, xzRange, yRange);
        this.localTiers.put(name, tier);
    }

    @Override
    public boolean blacklistBlock(ResourceLocation blockId) {
        Optional block = BuiltInRegistries.BLOCK.getOptional(blockId);
        if (block.isPresent()) {
            if (this.blacklistedBlocks.contains(block.get())) {
                ImpatientMod.LOGGER.warn("Block with id {} has already been blacklisted.", (Object)block);
                return false;
            }
            this.blacklistedBlocks.add((Block)block.get());
            return true;
        }
        ImpatientMod.LOGGER.warn("Block with id {} does not exist.", (Object)block);
        return false;
    }

    @Override
    public boolean blacklistBlock(Block block) {
        if (this.blacklistedBlocks.contains(block)) {
            ImpatientMod.LOGGER.warn("Block with id {} has already been blacklisted.", (Object)BuiltInRegistries.BLOCK.getKey((Object)block));
            return false;
        }
        this.blacklistedBlocks.add(block);
        return true;
    }

    @Override
    public boolean isBlockBlacklisted(Block block) {
        return this.blacklistedBlocks.contains(block);
    }

    @Override
    public boolean blacklistBlockEntity(ResourceLocation blockEntityTypeId) {
        Optional blockEntityType = BuiltInRegistries.BLOCK_ENTITY_TYPE.getOptional(blockEntityTypeId);
        if (blockEntityType.isPresent()) {
            if (this.blacklistedTiles.contains(blockEntityType.get())) {
                ImpatientMod.LOGGER.warn("Block with id {} has already been blacklisted.", (Object)blockEntityType);
                return false;
            }
            this.blacklistedTiles.add((BlockEntityType)blockEntityType.get());
            return true;
        }
        ImpatientMod.LOGGER.warn("Block with id {} does not exist.", (Object)blockEntityType);
        return false;
    }

    @Override
    public boolean blacklistBlockEntity(BlockEntityType<?> blockEntityType) {
        if (this.blacklistedTiles.contains(blockEntityType)) {
            ImpatientMod.LOGGER.warn("Block with id {} has already been blacklisted.", (Object)BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey(blockEntityType));
            return false;
        }
        this.blacklistedTiles.add(blockEntityType);
        return true;
    }

    @Override
    public boolean isBlockEntityBlacklisted(BlockEntityType<?> blockEntityType) {
        return this.blacklistedTiles.contains(blockEntityType);
    }

    public void setRemoteTiers(Map<ResourceLocation, Tier> tiers) {
        this.remoteTiers = tiers;
    }

    @Override
    public ImmutableMap<ResourceLocation, Tier> getTiers() {
        return ImmutableMap.copyOf(this.localTiers);
    }

    @Override
    public Tier getTier(ResourceLocation name) {
        return this.remoteTiers.getOrDefault(name, null);
    }
}

