/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.impatient;

import com.mojang.logging.LogUtils;
import net.biorfn.impatient.Config;
import net.biorfn.impatient.api.ImpatientAPI;
import net.biorfn.impatient.network.Reg;
import net.biorfn.impatient.platform.NetworkUtilsImpl;
import net.biorfn.impatient.registries.ModContent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="impatient")
@Mod.EventBusSubscriber(modid="impatient", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ImpatientMod {
    public static final String MODID = "impatient";
    public static final Logger LOGGER = LogUtils.getLogger();
    NetworkUtilsImpl networkUtils = NetworkUtilsImpl.getInstance();

    public ImpatientMod() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        Config.initialize();
        new Reg().register();
        ModContent.init(modEventBus);
        this.networkUtils.initialize();
        MinecraftForge.EVENT_BUS.register(ImpatientMod.class);
    }

    @SubscribeEvent
    public static void processIMC(InterModProcessEvent event) {
        event.getIMCStream().forEach(message -> {
            String method = message.getMethod();
            Object value = message.getMessageSupplier().get();
            if (method.equals("blacklist_block")) {
                if (value instanceof ResourceLocation) {
                    ImpatientAPI.INSTANCE.blacklistBlock((ResourceLocation)value);
                } else if (value instanceof Block) {
                    ImpatientAPI.INSTANCE.blacklistBlock((Block)value);
                } else {
                    LOGGER.error("Received blacklist_block message with invalid value, must be either a Block or ResourceLocation.");
                }
            } else if (method.equals("blacklist_tile")) {
                if (value instanceof ResourceLocation) {
                    ImpatientAPI.INSTANCE.blacklistBlockEntity((ResourceLocation)value);
                } else if (value instanceof BlockEntityType) {
                    ImpatientAPI.INSTANCE.blacklistBlockEntity((BlockEntityType)value);
                } else {
                    LOGGER.error("Received blacklist_tile message with invalid value, must be either a TileEntityType or ResourceLocation.");
                }
            } else {
                LOGGER.error("Received IMC message with invalid method, must be either: \"blacklist_block\" or \"blacklist_tile\".");
            }
        });
    }
}

