/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.impatient.block;

import java.util.function.Consumer;
import net.biorfn.impatient.Config;
import net.biorfn.impatient.api.TierSupplier;
import net.biorfn.impatient.block.entity.ImpatientBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class ImpatientLogic {
    public static ItemInteractionResult onUse(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.isClientSide || hand == InteractionHand.OFF_HAND) {
            return ItemInteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ImpatientBlockEntity) {
            ImpatientBlockEntity blockEntity2 = (ImpatientBlockEntity)blockEntity;
            blockEntity2.openImpatientScreen((ServerPlayer)player);
        }
        return ItemInteractionResult.SUCCESS;
    }

    public static void neighborUpdate(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean isMoving, Consumer<ImpatientBlockEntity> func) {
        if (level.isClientSide) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ImpatientBlockEntity) {
            ImpatientBlockEntity blockEntity2 = (ImpatientBlockEntity)blockEntity;
            func.accept(blockEntity2);
        }
    }

    public static void onPlaced(Level level, BlockPos pos, BlockState state, LivingEntity player, ItemStack stack, Block block) {
        if (level.isClientSide) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ImpatientBlockEntity) {
            ImpatientBlockEntity blockEntity2 = (ImpatientBlockEntity)blockEntity;
            if (stack.has(DataComponents.CUSTOM_NAME)) {
                blockEntity2.setCustomName(stack.getHoverName());
            }
        }
        if (Config.INSTANCE.log_placement) {
            String string = player == null ? "Something" : player.getDisplayName().getString() + "(" + player.getStringUUID() + ")";
        }
    }

    public static <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (state.getBlock() instanceof TierSupplier) {
            try {
                return (level1, pos, state1, entity) -> ImpatientBlockEntity.tick(level1, pos, state1, (ImpatientBlockEntity)entity);
            }
            catch (ClassCastException e) {
                return null;
            }
        }
        return null;
    }
}

