/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.impatient.block;

import net.biorfn.impatient.ImpatientMod;
import net.biorfn.impatient.api.TierSupplier;
import net.biorfn.impatient.block.ImpatientLogic;
import net.biorfn.impatient.block.entity.ImpatientBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class WallImpatientBlock
extends WallTorchBlock
implements EntityBlock,
TierSupplier {
    private final ResourceLocation tierID;

    public WallImpatientBlock(SimpleParticleType flameParticle, ResourceLocation tier, BlockBehaviour.Properties properties) {
        super(flameParticle, properties);
        this.tierID = tier;
    }

    @Override
    public ResourceLocation getTier() {
        return this.tierID;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ImpatientBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return ImpatientLogic.getTicker(level, state, type);
    }

    @Nullable
    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.IGNORE;
    }

    protected void onPlace(BlockState newState, Level level, BlockPos pos, BlockState state, boolean movedByPiston) {
        this.neighborChanged(newState, level, pos, null, null, false);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return ImpatientLogic.onUse(state, level, pos, player, hand, hit);
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        if (level.isClientSide) {
            return;
        }
        if (level.getServer() != null) {
            level.getServer().execute(() -> ImpatientLogic.neighborUpdate(state, level, pos, neighborBlock, neighborPos, movedByPiston, be -> {
                boolean powered = level.hasNeighborSignal(pos);
                be.setPoweredByRedstone(powered);
            }));
        } else {
            ImpatientMod.LOGGER.warn("Server is null, cannot execute neighbor update for position {}", (Object)pos);
        }
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        ImpatientLogic.onPlaced(level, pos, state, placer, stack, (Block)this);
    }
}

