/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.impatient.block.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.biorfn.impatient.api.ImpatientAPI;
import net.biorfn.impatient.api.Tier;
import net.biorfn.impatient.api.TierSupplier;
import net.biorfn.impatient.block.ImpatientBlock;
import net.biorfn.impatient.block.WallImpatientBlock;
import net.biorfn.impatient.platform.NetworkUtils;
import net.biorfn.impatient.registries.ImpatientBlockBlacklist;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Nameable;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImpatientBlockEntity
extends BlockEntity
implements Nameable,
TierSupplier {
    public static int randomTicks;
    private Component customName;
    private int xRange;
    private int yRange;
    private int zRange;
    private int speed;
    private int redstoneMode;
    private List<BlockPos> area = new ArrayList<BlockPos>();
    private boolean active;
    private ResourceLocation tierID;
    private String uuid = "";
    private int recursionDepth = 0;
    private final int MAX_RECURSION_DEPTH = 10;

    public ImpatientBlockEntity(BlockPos pos, BlockState blockState) {
        super(Objects.requireNonNull((BlockEntityType)BuiltInRegistries.BLOCK_ENTITY_TYPE.get(ResourceLocation.fromNamespaceAndPath((String)"impatient", (String)"impatient"))), pos, blockState);
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        if (!level.isClientSide) {
            level.getServer().tell((Runnable)new TickTask(level.getServer().getTickCount(), () -> this.getBlockState().handleNeighborChanged(level, this.worldPosition, null, null, false)));
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ImpatientBlockEntity entity) {
        if (!level.isClientSide) {
            entity.handleTick(level, pos);
        }
    }

    private synchronized void handleTick(Level level, BlockPos pos) {
        if (!this.active) {
            return;
        }
        if (this.speed == 0 || this.xRange == 0 && this.yRange == 0 && this.zRange == 0) {
            return;
        }
        randomTicks = level.getGameRules().getInt(GameRules.RULE_RANDOMTICKING);
        this.tickArea(level, pos, this.speed);
    }

    private void calculateArea(BlockPos origin) {
        this.area.clear();
        for (int x = -this.xRange; x <= this.xRange; ++x) {
            for (int y = -this.yRange; y <= this.yRange; ++y) {
                for (int z = -this.zRange; z <= this.zRange; ++z) {
                    this.area.add(origin.offset(x, y, z));
                }
            }
        }
    }

    private void tickArea(Level level, BlockPos origin, int speed) {
        for (BlockPos pos : this.area) {
            if (this.recursionDepth > 10) {
                return;
            }
            ++this.recursionDepth;
            this.tickBlock(level, pos, speed, this.recursionDepth);
            --this.recursionDepth;
        }
    }

    private void tickBlock(Level level, BlockPos pos, int speed, int recursionDepth) {
        if (!level.hasChunkAt(pos)) {
            return;
        }
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block == Blocks.AIR || block == Blocks.VOID_AIR || block == Blocks.CAVE_AIR) {
            return;
        }
        if (block instanceof ImpatientBlock || block instanceof WallImpatientBlock) {
            return;
        }
        if (ImpatientBlockBlacklist.isBlacklisted(block)) {
            return;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (state.isRandomlyTicking()) {
                for (int i = 0; i < speed; ++i) {
                    if (serverLevel.getRandom().nextInt(Mth.clamp((int)(4096 / (speed * 4)), (int)1, (int)4096)) >= randomTicks) continue;
                    state.randomTick(serverLevel, pos, serverLevel.getRandom());
                }
            }
        }
        if (block instanceof EntityBlock) {
            EntityBlock entityBlock = (EntityBlock)block;
            BlockEntity entity = level.getBlockEntity(pos);
            if (entity != null && !entity.isRemoved() && !ImpatientBlockBlacklist.isBlacklisted(entity.getBlockState().getBlock())) {
                BlockEntityType blockEntityType = entity.getType();
                for (int i = 0; i < speed && !entity.isRemoved(); ++i) {
                    BlockEntityTicker ticker = entityBlock.getTicker(level, state, blockEntityType);
                    if (ticker == null) continue;
                    if (recursionDepth <= 10) {
                        ticker.tick(level, pos, state, entity);
                        continue;
                    }
                    return;
                }
            }
        }
    }

    public boolean hasCustomName() {
        return this.customName != null;
    }

    @Nullable
    public Component getCustomName() {
        return this.customName;
    }

    public void setCustomName(Component name) {
        this.customName = name;
    }

    private String getOwner() {
        return this.uuid;
    }

    public void setOwner(String s) {
        this.uuid = s;
    }

    @NotNull
    public Component getName() {
        return this.hasCustomName() ? this.customName : Component.translatable((String)this.getBlockState().getBlock().getDescriptionId());
    }

    public boolean readClientData(int xRange, int zRange, int yRange, int speed, int redstoneMode) {
        Tier tier = (Tier)ImpatientAPI.INSTANCE.getTiers().get((Object)this.getTier());
        if (this.valueInRange(xRange, 0, tier.xzRange()) && this.valueInRange(zRange, 0, tier.xzRange()) && this.valueInRange(yRange, 0, tier.yRange()) && this.valueInRange(speed, 0, tier.maxSpeed()) && this.valueInRange(redstoneMode, 0, 3)) {
            this.xRange = xRange;
            this.zRange = zRange;
            this.yRange = yRange;
            this.speed = speed;
            this.redstoneMode = redstoneMode;
            this.calculateArea(this.worldPosition);
            return true;
        }
        return false;
    }

    private boolean valueInRange(int value, int min, int max) {
        return value >= min && value <= max;
    }

    @Override
    public ResourceLocation getTier() {
        Block block;
        if (this.tierID == null && (block = this.getBlockState().getBlock()) instanceof TierSupplier) {
            TierSupplier supplier = (TierSupplier)block;
            this.tierID = supplier.getTier();
        }
        return this.tierID;
    }

    public void setPoweredByRedstone(boolean powered) {
        switch (this.redstoneMode) {
            case 0: {
                this.active = !powered;
                break;
            }
            case 1: {
                this.active = powered;
                break;
            }
            case 2: {
                this.active = true;
                break;
            }
            case 3: {
                this.active = false;
            }
        }
        if (this.level != null && !this.level.isClientSide) {
            this.setChanged();
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.hasCustomName()) {
            assert (this.getCustomName() != null);
            tag.putString("CustomName", Component.Serializer.toJson((Component)this.getCustomName(), (HolderLookup.Provider)registries));
        }
        tag.putInt("XRange", this.xRange);
        tag.putInt("ZRange", this.zRange);
        tag.putInt("YRange", this.yRange);
        tag.putInt("Speed", this.speed);
        tag.putInt("RedstoneMode", this.redstoneMode);
        tag.putBoolean("Active", this.active);
        tag.putString("Owner", this.getOwner() == null ? "" : this.getOwner());
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("CustomName", 8)) {
            this.setCustomName((Component)Component.Serializer.fromJson((String)tag.getString("CustomName"), (HolderLookup.Provider)registries));
        }
        this.xRange = tag.getInt("XRange");
        this.zRange = tag.getInt("ZRange");
        this.yRange = tag.getInt("YRange");
        this.speed = tag.getInt("Speed");
        this.redstoneMode = tag.getInt("RedstoneMode");
        this.active = tag.getBoolean("Active");
        this.uuid = tag.getString("Owner");
        this.calculateArea(this.worldPosition);
    }

    public void updateRangesFromClient(int xRange, int zRange, int yRange, int speed, int redstoneMode) {
        this.speed = speed;
        this.xRange = xRange;
        this.yRange = yRange;
        this.zRange = zRange;
        this.redstoneMode = redstoneMode;
        this.setChanged();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
        this.loadAdditional(pkt.getTag(), lookupProvider);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        this.saveAdditional(tag, registries);
        return tag;
    }

    public void openImpatientScreen(ServerPlayer player) {
        NetworkUtils.getInstance().s2c_openImpatientScreen(player, this.worldPosition, this.getName(), this.xRange, this.zRange, this.yRange, this.speed, this.redstoneMode);
    }
}

