/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.impatient.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import net.biorfn.impatient.api.ImpatientAPI;
import net.biorfn.impatient.api.Tier;
import net.biorfn.impatient.client.screen.widgets.GradatedSliderWidget;
import net.biorfn.impatient.client.screen.widgets.StateButtonWidget;
import net.biorfn.impatient.platform.NetworkUtilsImpl;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public final class ImpatientScreen
extends Screen {
    private static final ResourceLocation SCREEN_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"impatient", (String)"textures/screens/impatient.png");
    private static final int screenWidth = 245;
    private static final int screenHeight = 123;
    private final BlockPos blockPos;
    private final Tier tier;
    private final Component cached_title;
    private int xRange;
    private int zRange;
    private int yRange;
    private int speed;
    private int redstoneMode;
    private int left;
    private int top;

    public ImpatientScreen(Component title, int xRange, int zRange, int yRange, int speed, int redstoneMode, BlockPos pos, ResourceLocation tierID) {
        super(title);
        Tier tier1 = ImpatientAPI.INSTANCE.getTier(tierID);
        if (tier1 == null) {
            throw new IllegalArgumentException("Tier with ID " + String.valueOf(tierID) + " not found.");
        }
        this.tier = ImpatientAPI.INSTANCE.getTier(tierID);
        this.blockPos = pos;
        this.xRange = xRange;
        this.zRange = zRange;
        this.yRange = yRange;
        this.speed = speed == 0 ? 1 : speed;
        this.redstoneMode = redstoneMode;
        this.cached_title = title;
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void init() {
        this.left = (this.width - 245) / 2;
        this.top = (this.height - 123) / 2;
        this.addRenderableWidget((GuiEventListener)new GradatedSliderWidget(this.left + 8, this.top + 20, 205, (double)(this.speed - 1) / (double)(this.tier.maxSpeed() - 1), this.tier.maxSpeed()){

            protected void updateMessage() {
                this.setMessage((Component)Component.translatable((String)"gui.impatient.speed", (Object[])new Object[]{100 * ImpatientScreen.this.speed}));
            }

            protected void applyValue() {
                ImpatientScreen.this.speed = 1 + (int)Math.round(this.value * (double)(ImpatientScreen.this.tier.maxSpeed() - 1));
                this.value = (double)(ImpatientScreen.this.speed - 1) / (double)(ImpatientScreen.this.tier.maxSpeed() - 1);
            }
        });
        this.addRenderableWidget((GuiEventListener)new GradatedSliderWidget(this.left + 8, this.top + 45, 205, (double)this.xRange / (double)this.tier.xzRange(), this.tier.xzRange()){

            protected void updateMessage() {
                this.setMessage((Component)Component.translatable((String)"gui.impatient.x_range", (Object[])new Object[]{ImpatientScreen.this.xRange * 2 + 1}));
            }

            protected void applyValue() {
                ImpatientScreen.this.xRange = (int)Math.round(this.value * (double)ImpatientScreen.this.tier.xzRange());
                this.value = (double)ImpatientScreen.this.xRange / (double)ImpatientScreen.this.tier.xzRange();
            }
        });
        this.addRenderableWidget((GuiEventListener)new GradatedSliderWidget(this.left + 8, this.top + 70, 205, (double)this.zRange / (double)this.tier.xzRange(), this.tier.xzRange()){

            protected void updateMessage() {
                this.setMessage((Component)Component.translatable((String)"gui.impatient.z_range", (Object[])new Object[]{ImpatientScreen.this.zRange * 2 + 1}));
            }

            protected void applyValue() {
                ImpatientScreen.this.zRange = (int)Math.round(this.value * (double)ImpatientScreen.this.tier.xzRange());
                this.value = (double)ImpatientScreen.this.zRange / (double)ImpatientScreen.this.tier.xzRange();
            }
        });
        this.addRenderableWidget((GuiEventListener)new GradatedSliderWidget(this.left + 8, this.top + 95, 205, (double)this.yRange / (double)this.tier.yRange(), this.tier.yRange()){

            protected void updateMessage() {
                this.setMessage((Component)Component.translatable((String)"gui.impatient.y_range", (Object[])new Object[]{ImpatientScreen.this.yRange * 2 + 1}));
            }

            protected void applyValue() {
                ImpatientScreen.this.yRange = (int)Math.round(this.value * (double)ImpatientScreen.this.tier.yRange());
                this.value = (double)ImpatientScreen.this.yRange / (double)ImpatientScreen.this.tier.yRange();
            }
        });
        this.addRenderableWidget((GuiEventListener)new StateButtonWidget(this, this.left + 217, this.top + 20, this.font){
            ItemStack buttonIcon;

            @Override
            protected void initialize() {
                this.setButtonMessage();
                this.setButtonIcon();
            }

            private void setButtonMessage() {
                String translationKey = switch (ImpatientScreen.this.redstoneMode) {
                    case 0 -> "gui.impatient.mode.normal";
                    case 1 -> "gui.impatient.mode.inverted";
                    case 2 -> "gui.impatient.mode.ignored";
                    case 3 -> "gui.impatient.mode.off";
                    default -> "gui.impatient.mode.error";
                };
                this.setNarrationMessage((Component)Component.translatable((String)"gui.impatient.mode", (Object[])new Object[]{Component.translatable((String)translationKey)}));
            }

            private void setButtonIcon() {
                switch (ImpatientScreen.this.redstoneMode) {
                    case 0: {
                        this.buttonIcon = new ItemStack((ItemLike)Items.REDSTONE);
                        break;
                    }
                    case 1: {
                        this.buttonIcon = new ItemStack((ItemLike)Items.REDSTONE_TORCH);
                        break;
                    }
                    case 2: {
                        this.buttonIcon = new ItemStack((ItemLike)Items.GUNPOWDER);
                        break;
                    }
                    case 3: {
                        this.buttonIcon = new ItemStack((ItemLike)Items.REDSTONE_LAMP);
                        break;
                    }
                    default: {
                        this.buttonIcon = new ItemStack((ItemLike)Items.FURNACE);
                    }
                }
            }

            @Override
            protected void nextState() {
                ImpatientScreen.this.redstoneMode = (ImpatientScreen.this.redstoneMode + 1) % 4;
                this.initialize();
            }

            @Override
            protected ItemStack getButtonIcon() {
                return this.buttonIcon;
            }
        });
    }

    public void render(GuiGraphics context, int x, int y, float partialTick) {
        context.fillGradient(0, 0, this.width, this.height, -1072689136, -804253680);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)SCREEN_TEXTURE);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        context.blit(SCREEN_TEXTURE, this.left, this.top, 0, 0, 245, 123);
        context.drawString(this.font, this.cached_title.getVisualOrderText(), (int)((float)(this.width - this.font.width((FormattedText)this.cached_title)) / 2.0f), this.top + 6, 0x404040, false);
        super.render(context, x, y, partialTick);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 || this.minecraft.options.keyInventory.matches(keyCode, 0)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void onClose() {
        NetworkUtilsImpl.getInstance().c2s_updateImpatientValues(this.blockPos, this.xRange, this.zRange, this.yRange, this.speed, this.redstoneMode);
        super.onClose();
    }
}

