/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.impatient.client.screen.widgets;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public abstract class StateButtonWidget
extends Button {
    private static final ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
    private final Screen screen;
    private Component narrationMessage;
    private Font font;

    protected StateButtonWidget(Screen screen, int x, int y, Font font) {
        super(x, y, 20, 20, (Component)Component.empty(), b -> {}, Button.DEFAULT_NARRATION);
        this.screen = screen;
        this.font = font;
        this.initialize();
    }

    public Font getFont() {
        return this.font;
    }

    protected abstract void initialize();

    protected abstract void nextState();

    protected abstract ItemStack getButtonIcon();

    protected void renderWidget(GuiGraphics context, int mouseX, int mouseY, float partialTick) {
        if (this.visible) {
            context.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, -1);
            context.renderItem(this.getButtonIcon(), this.getX() + 2, this.getY() + 2);
            if (this.isHovered) {
                context.renderTooltip(this.getFont(), this.narrationMessage, this.getX() + 14, this.getY() + 18);
            }
        }
    }

    public void onPress() {
        this.nextState();
    }

    public MutableComponent createNarrationMessage() {
        return Component.translatable((String)"gui.narrate.button", (Object[])new Object[]{this.narrationMessage});
    }

    protected void setNarrationMessage(Component narrationMessage) {
        this.narrationMessage = narrationMessage;
    }
}

